/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.qw;

import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.QWMsg;
import com.ovopark.messagehub.plugins.bridge.qw.QWResponse;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.kernel.module.QWMessage;
import com.ovopark.messagehub.plugins.qw.QWSender;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class QWSubscriber
extends CoreSubscriber<MsgContext<QWMsg>> {
    private static final Logger log = LoggerFactory.getLogger(QWSubscriber.class);
    private static final String TOPIC_DEVICE_QW = "topic-device-qw";
    private final KafkaReply kafkaReply;
    private final QWSender qwSender;

    public QWSubscriber(KafkaReply kafkaReply, QWSender qwSender) {
        this.kafkaReply = kafkaReply;
        this.qwSender = qwSender;
    }

    public void onNext(MsgContext<QWMsg> msgMsgContext) {
        QWMsg msg = (QWMsg)msgMsgContext.msg();
        com.ovopark.messagehub.plugins.bridge.qw.QWMessage qwMessage = (com.ovopark.messagehub.plugins.bridge.qw.QWMessage)msg.getBody();
        QWMessage targetMessage = new QWMessage();
        BeanUtils.copyProperties((Object)qwMessage, (Object)targetMessage);
        List<MessageReply<QWResponse>> replyList = this.qwSender.send(msg.getUsers(), targetMessage, msgMsgContext);
        for (MessageReply<QWResponse> reply : replyList) {
            this.kafkaReply.reply("messagehub-plugins-reply", reply, msgMsgContext);
        }
    }
}

