/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.voice.aliyun;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.VoiceMsg;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.plugins.voice.aliyun.VoiceSender;
import com.ovopark.messagehub.plugins.voice.aliyun.VoiceSubscriber;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import com.ovopark.module.shared.redis.RateLimiter;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="VOICE")
@Component
public class VoiceInStream {
    private static final Logger log = LoggerFactory.getLogger(VoiceInStream.class);
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private SubsRateLimiterClient subsRateLimiterClient;
    @Autowired
    private VoiceSender voiceSender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.plugins.voice.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-voice", groupId="${messagehub.plugins.voice.kafka.group:messagehub-group-voice}", containerFactory="voiceKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        VoiceMsg voiceMsg = (VoiceMsg)JSONAccessor.impl().read((String)value, VoiceMsg.class);
        log.info(voiceMsg.getMsgId() + " from KAFKA: " + String.valueOf(value));
        RateLimiter rateLimiter = this.subsRateLimiterClient.get(Subs.VOICE);
        rateLimiter.acquire();
        String msgTraceId = voiceMsg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        MDC.put((String)"traceId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)voiceMsg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.VOICE, meta);
            }).subscribe((Subscriber)new VoiceSubscriber(this.kafkaReply, this.voiceSender));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

