/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.voice.aliyun;

import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.VoiceMsg;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.bridge.voice.VoiceMessage;
import com.ovopark.messagehub.plugins.voice.aliyun.VoiceSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoiceSubscriber
extends CoreSubscriber<MsgContext<VoiceMsg>> {
    private static final Logger log = LoggerFactory.getLogger(VoiceSubscriber.class);
    private final KafkaReply kafkaReply;
    private final VoiceSender voiceSender;

    public VoiceSubscriber(KafkaReply kafkaReply, VoiceSender voiceSender) {
        this.kafkaReply = kafkaReply;
        this.voiceSender = voiceSender;
    }

    public void onNext(MsgContext<VoiceMsg> msgMsgContext) {
        VoiceMsg msg = (VoiceMsg)msgMsgContext.msg();
        VoiceMessage payload = (VoiceMessage)msg.getBody();
        MessageReply<?> messageReply = this.voiceSender.send(payload, msgMsgContext);
        this.kafkaReply.reply("messagehub-plugins-reply", messageReply, msgMsgContext);
    }
}

