/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.job;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ReleasableLock;
import com.ovopark.messagehub.sdk.internal.MessageHubJobApi;
import com.ovopark.messagehub.sdk.job.ClientNode;
import com.ovopark.messagehub.sdk.job.JobLog;
import com.ovopark.messagehub.sdk.model.internal.job.TaskLogRequest;
import com.ovopark.module.shared.BaseResult;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogImpl
implements JobLog {
    private static final Logger log = LoggerFactory.getLogger(JobLogImpl.class);
    private static final ExecutorService jobLogExecutor = new ThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), Integer.parseInt(System.getProperty("MESSAGEHUB_JOB_LOG_IO", "0"))), Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2, 64), Integer.parseInt(System.getProperty("MESSAGEHUB_JOB_LOG_IO", "0"))), 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Util.newThreadFactory((String)"messagehub-job-log-io"), new ThreadPoolExecutor.CallerRunsPolicy());
    final MessageHubJobApi messageHubJobApi;
    final Queue<String> contentQueue;
    final String traceId;
    private volatile long lastSyncLogTimeMs = System.currentTimeMillis();
    private final ReentrantReadWriteLock dataReadWriteLock = new ReentrantReadWriteLock();
    private final ReleasableLock dataSLock = new ReleasableLock((Lock)this.dataReadWriteLock.readLock());
    private final ReleasableLock dataXLock = new ReleasableLock((Lock)this.dataReadWriteLock.writeLock());
    private volatile boolean closed;
    private final long taskId;

    public JobLogImpl(MessageHubJobApi messageHubJobApi, String traceId, long taskId) {
        this.messageHubJobApi = messageHubJobApi;
        this.contentQueue = new ArrayBlockingQueue<String>(100);
        this.traceId = traceId;
        this.taskId = taskId;
    }

    public void log(Supplier<String> content) {
        this.log(content.get());
    }

    public void log(String content) {
        if (this.closed) {
            return;
        }
        String finalContent = this.traceId + " > " + content;
        if (this.contentQueue.offer(finalContent)) {
            long now = System.currentTimeMillis();
            if (now - this.lastSyncLogTimeMs > 1000L) {
                this.fsync0(false, false);
            }
        } else {
            this.fsync0(false, false);
            this.contentQueue.offer(finalContent);
        }
    }

    public void flush() {
        this.fsync0(false, false);
    }

    public void flush(boolean sync) {
        this.fsync0(false, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fsync0(boolean closed, boolean sync) {
        this.dataXLock.acquire();
        try {
            ArrayList<String> list = new ArrayList<String>(this.contentQueue.size());
            list.addAll(this.contentQueue);
            TaskLogRequest taskLogRequest = new TaskLogRequest();
            taskLogRequest.setLogList(list);
            taskLogRequest.setNode(ClientNode.UUID_STR);
            taskLogRequest.setTaskId(this.taskId);
            this.contentQueue.clear();
            this.lastSyncLogTimeMs = System.currentTimeMillis();
            Runnable command = Util.catchRunnable(() -> {
                BaseResult baseResult = this.messageHubJobApi.log(taskLogRequest);
                log.info("sync log success: " + JSONAccessor.impl().format((Object)baseResult));
            });
            if (sync) {
                command.run();
            } else {
                jobLogExecutor.execute(command);
            }
        }
        finally {
            if (closed) {
                this.closed = true;
            }
            this.dataXLock.unlock();
        }
    }

    public void close() {
        this.fsync0(true, true);
    }
}

