package com.ovopark.messagehub.sdk.internal;


import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "messagehub-interact"
//        ,url = "127.0.0.1:13700"
)
public interface MessageHubInteractApi {

    @GetMapping("/messagehub-interact/todoList/countUndone")
    BaseResult<Long> countUndone(@RequestParam("userId") int userId);

    @GetMapping("/messagehub-interact/todoList/list")
    BaseResult<Object> list(@RequestParam("userId") int userId);

}
