/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.msgstream;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.messagehub.sdk.model.kafka.UserMessageModel;
import com.ovopark.module.shared.BaseResult;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Send2ThirdProcessor {
    public void send(UserMessageContext var1);

    public static interface UserMessageContext
    extends Stream.MsgPerContext {
        public static UserMessageContext from(UserMessageModel userMessageModel) {
            return new SimpleUserMessageContext(Util.isEmpty((CharSequence)userMessageModel.getTraceId()) ? userMessageModel.getId() : userMessageModel.getTraceId(), userMessageModel);
        }

        public UserMessageModel message();

        public TypeTmp typeTmp();

        public String messageUrl();

        public String messageOAuthUrl();

        public static class SimpleUserMessageContext
        extends Stream.MsgPerContextImpl
        implements UserMessageContext {
            private static final Logger log = LoggerFactory.getLogger(SimpleUserMessageContext.class);
            final UserMessageModel userMessage;
            private final Stream.MsgPerContext.PerLogger perLogger = new Stream.MsgPerContext.PerLogger(){};
            MessageHubV2Api messageHubV2Api;
            private TypeTmp typeTmp;

            private SimpleUserMessageContext(String seq, UserMessageModel userMessage) {
                super(seq, null);
                this.userMessage = userMessage;
            }

            public Stream.MsgPerContext.PerLogger logger() {
                return this.perLogger;
            }

            @Override
            public UserMessageModel message() {
                return this.userMessage;
            }

            @Override
            public TypeTmp typeTmp() {
                return this.typeTmp;
            }

            @Override
            public String messageUrl() {
                final ThirdMessage thirdMessage = this.userMessage.getThirdMessage();
                if (thirdMessage == null) {
                    return null;
                }
                Value value = (Value)this.setAttrIfAbsentAndGet("SimpleUserMessageContext:messageUrl", new Function<String, Value<String>>(){

                    @Override
                    public Value<String> apply(String s) {
                        BaseResult<String> baseResult = messageHubV2Api.getMessageUrl(thirdMessage);
                        this.logger().info(log, "request redirect url result: " + JSONAccessor.impl().format(baseResult));
                        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                            return new Value<String>((String)baseResult.getData());
                        }
                        return new Value<Object>(null);
                    }
                });
                return (String)value.ref;
            }

            @Override
            public String messageOAuthUrl() {
                Value value = (Value)this.setAttrIfAbsentAndGet("SimpleUserMessageContext:messageOAuthUrl", new Function<String, Value<String>>(){

                    @Override
                    public Value<String> apply(String s) {
                        BaseResult<String> baseResult = messageHubV2Api.getMessageOAuthUrl(userMessage);
                        this.logger().info(log, "request redirect url result: " + JSONAccessor.impl().format(baseResult));
                        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                            return new Value<String>((String)baseResult.getData());
                        }
                        return new Value<Object>(null);
                    }
                });
                return (String)value.ref;
            }

            public void setMessageHubV2Api(MessageHubV2Api messageHubV2Api) {
                this.messageHubV2Api = messageHubV2Api;
            }

            public void setTypeTmp(TypeTmp typeTmp) {
                this.typeTmp = typeTmp;
            }
        }

        public static class Value<T> {
            final T ref;

            public Value(T ref) {
                this.ref = ref;
            }

            public T getRef() {
                return this.ref;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value other = (Value)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                T this$ref = this.getRef();
                T other$ref = other.getRef();
                return !(this$ref == null ? other$ref != null : !this$ref.equals(other$ref));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Value;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                T $ref = this.getRef();
                result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
                return result;
            }

            public String toString() {
                return "Send2ThirdProcessor.UserMessageContext.Value(ref=" + this.getRef() + ")";
            }
        }

        public static class TypeTmp {
            private String sourceModule;
            private boolean breakProcess;

            public String getSourceModule() {
                return this.sourceModule;
            }

            public boolean isBreakProcess() {
                return this.breakProcess;
            }

            public void setSourceModule(String sourceModule) {
                this.sourceModule = sourceModule;
            }

            public void setBreakProcess(boolean breakProcess) {
                this.breakProcess = breakProcess;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TypeTmp)) {
                    return false;
                }
                TypeTmp other = (TypeTmp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isBreakProcess() != other.isBreakProcess()) {
                    return false;
                }
                String this$sourceModule = this.getSourceModule();
                String other$sourceModule = other.getSourceModule();
                return !(this$sourceModule == null ? other$sourceModule != null : !this$sourceModule.equals(other$sourceModule));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TypeTmp;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isBreakProcess() ? 79 : 97);
                String $sourceModule = this.getSourceModule();
                result = result * 59 + ($sourceModule == null ? 43 : $sourceModule.hashCode());
                return result;
            }

            public String toString() {
                return "Send2ThirdProcessor.UserMessageContext.TypeTmp(sourceModule=" + this.getSourceModule() + ", breakProcess=" + this.isBreakProcess() + ")";
            }
        }
    }
}

