/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.msgstream;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.messagehub.sdk.model.kafka.UserMessageModel;
import com.ovopark.messagehub.sdk.msgstream.Send2ThirdProcessor;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMsg2OtherChannelSubscriber
extends CoreSubscriber<Send2ThirdProcessor.UserMessageContext> {
    private static final Logger log = LoggerFactory.getLogger(SendMsg2OtherChannelSubscriber.class);
    private final List<Send2ThirdProcessor> send2ThirdProcessorList;
    private final MessageHubV2Api messageHubV2Api;
    private final boolean skipHidden;

    public SendMsg2OtherChannelSubscriber(List<Send2ThirdProcessor> send2ThirdProcessorList, MessageHubV2Api messageHubV2Api) {
        this(send2ThirdProcessorList, messageHubV2Api, true);
    }

    public SendMsg2OtherChannelSubscriber(List<Send2ThirdProcessor> send2ThirdProcessorList, MessageHubV2Api messageHubV2Api, boolean skipHidden) {
        this.send2ThirdProcessorList = send2ThirdProcessorList;
        this.messageHubV2Api = messageHubV2Api;
        this.skipHidden = skipHidden;
    }

    public SendMsg2OtherChannelSubscriber(Send2ThirdProcessor send2ThirdProcessor, MessageHubV2Api messageHubV2Api) {
        this(Collections.singletonList(send2ThirdProcessor), messageHubV2Api, true);
    }

    public SendMsg2OtherChannelSubscriber(Send2ThirdProcessor send2ThirdProcessor, MessageHubV2Api messageHubV2Api, boolean skipHidden) {
        this(Collections.singletonList(send2ThirdProcessor), messageHubV2Api, skipHidden);
    }

    public static Stream<Send2ThirdProcessor.UserMessageContext> from(UserMessageModel userMessageModel) {
        return Stream.from((Object)userMessageModel).map(Send2ThirdProcessor.UserMessageContext::from);
    }

    public void onNext(Send2ThirdProcessor.UserMessageContext userMessageContext) {
        UserMessageModel userMessageModel = userMessageContext.message();
        if (this.skipHidden && userMessageModel.getHidden() == 1) {
            return;
        }
        if (userMessageModel.getGroupId() == null) {
            return;
        }
        Send2ThirdProcessor.UserMessageContext.SimpleUserMessageContext simpleUserMessageContext = (Send2ThirdProcessor.UserMessageContext.SimpleUserMessageContext)userMessageContext;
        simpleUserMessageContext.setMessageHubV2Api(this.messageHubV2Api);
        ThirdMessage thirdMessage = userMessageModel.getThirdMessage();
        Send2ThirdProcessor.UserMessageContext.TypeTmp typeTmp = thirdMessage == null ? this.typeTmp(null, userMessageModel.getMsgTypeCode(), null) : this.typeTmp(thirdMessage.getCategory(), thirdMessage.getObjectType(), thirdMessage);
        simpleUserMessageContext.setTypeTmp(typeTmp);
        for (Send2ThirdProcessor send2ThirdProcessor : this.send2ThirdProcessorList) {
            send2ThirdProcessor.send(userMessageContext);
        }
    }

    private Send2ThirdProcessor.UserMessageContext.TypeTmp typeTmp(String category, String objectType, ThirdMessage thirdMessage) {
        Send2ThirdProcessor.UserMessageContext.TypeTmp typeTmp = new Send2ThirdProcessor.UserMessageContext.TypeTmp();
        String sourceModule = null;
        if ("Problem_Capture_Notify".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5f85\u529e\u5355";
        } else if ("Problem_FeedBack_Notify".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5f85\u529e\u5355";
        } else if ("TEMP_CHECK_REPORT_NOTIFY".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5de1\u5e97\u5ba1\u6838";
        } else if ("FINAL_CHECK_REPORT_NOTIFY".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5de1\u5e97\u8bb0\u5f55";
        } else if ("TYPE_STORE_PLAN_SYSTEM".equalsIgnoreCase(category)) {
            sourceModule = "\u8ba1\u5212\u5de1\u5e97";
        } else if ("CHECK_REPORT_SUBSCRIPTION_NOTIFY".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5de1\u5e97\u62a5\u544a(\u8ba2\u9605)";
        } else if ("CHECK_REPORT_REAL_TIME_NOTIFY".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5de1\u5e97\u62a5\u544a(\u8ba2\u9605) \u5b9e\u65f6";
        } else if ("TYPE_PAPER_SYSTEM".equalsIgnoreCase(objectType)) {
            sourceModule = "\u6211\u7684\u8003\u8bd5";
        } else if ("INSPECTION_PLAN".equalsIgnoreCase(objectType)) {
            sourceModule = "\u8ba1\u5212\u5de1\u5e97";
        } else if ("CHECK_AUDIT".equalsIgnoreCase(objectType)) {
            sourceModule = "\u8ba1\u5212\u5de1\u5e97";
        } else if ("CHECK_TASK_REMIND_NOTIFY".equalsIgnoreCase(objectType) && "FINAL_CHECK_REPORT\n".equalsIgnoreCase(category)) {
            sourceModule = thirdMessage != null && Util.compare2((Comparable)thirdMessage.getMainType(), (Comparable)Integer.valueOf(0)) == 0 ? "\u73b0\u573a\u5de1\u5e97" : (thirdMessage != null && Util.compare2((Comparable)thirdMessage.getMainType(), (Comparable)Integer.valueOf(1)) == 0 ? "\u8fdc\u7a0b\u5de1\u5e97\n" : (thirdMessage != null && Util.compare2((Comparable)thirdMessage.getMainType(), (Comparable)Integer.valueOf(12)) == 0 ? "\u95e8\u5e97\u81ea\u68c0" : "\u5de1\u5e97"));
        } else if ("TYPE_TRAINING_NEW_SYSTEM".equalsIgnoreCase(objectType)) {
            sourceModule = "\u4f01\u4e1a\u8bfe\u7a0b";
        } else if ("TYPE_TRAINING_SYSTEM".equalsIgnoreCase(objectType)) {
            sourceModule = "\u4f01\u4e1a\u8bfe\u7a0b";
        } else if ("REFUSE_CHECK_REPORT_NOTIFY".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5de1\u5e97\u5ba1\u6838";
        } else if ("Problem_Remind".equalsIgnoreCase(objectType)) {
            sourceModule = "\u534f\u540c\u63d0\u9192";
        } else if ("Problem_Urging_Remind".equalsIgnoreCase(objectType)) {
            sourceModule = "\u50ac\u529e\u63d0\u9192";
        } else if ("COORDINATE_CHECK_INVITE".equalsIgnoreCase(objectType)) {
            sourceModule = "\u534f\u540c\u5de1\u5e97";
        } else if ("Problem_Remind_Merge".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5f85\u529e\u5355\u63d0\u9192";
        } else if ("Problem_Cc_Merge".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5f85\u529e\u5355";
        } else if ("TYPE_COURSE_SYSTEM".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5de1\u5e97\u5ba1\u6838";
        } else if ("TYPE_MATERIAL_SYSTEM".equalsIgnoreCase(objectType)) {
            sourceModule = "\u77e5\u8bc6\u4e0a\u65b0";
        } else if ("APPROVAL_URGING_REMIND".equalsIgnoreCase(objectType)) {
            sourceModule = "\u50ac\u529e\u63d0\u9192";
        } else if ("DISPLAY_PLAN".equalsIgnoreCase(objectType)) {
            sourceModule = "\u5de1\u5e97\u5ba1\u6838";
        } else if ("Device_Alert_Notify_Off".equalsIgnoreCase(objectType)) {
            sourceModule = "\u6389\u7ebf\u544a\u8b66";
        } else {
            typeTmp.setBreakProcess(true);
        }
        typeTmp.setSourceModule(sourceModule);
        return typeTmp;
    }
}

