/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk;

import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.internal.MessageHubSyncCnfApi;
import com.ovopark.messagehub.sdk.model.internal.SyncConfImpl;
import com.ovopark.module.shared.BaseResult;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncConfRPC
implements Stream.DBEntrySupplier.SyncConfFsync {
    @Autowired
    private MessageHubSyncCnfApi messageHubSyncCnfApi;

    public void fsync(String syncId, String syncTime, String syncPk, int syncCount, String syncStatus) {
        this.fsyncWithVcc(-1L, syncId, syncTime, syncPk, syncCount, syncStatus);
    }

    public long fsyncWithVcc(long ver, String syncId, String syncTime, String syncPk, int syncCount, String syncStatus) {
        SyncConfImpl syncConf = new SyncConfImpl();
        syncConf.setSyncId(syncId);
        syncConf.setSyncTime(syncTime);
        syncConf.setSyncPk(syncPk);
        syncConf.setSyncCount(Integer.valueOf(syncCount));
        syncConf.setSyncStatus(syncStatus);
        syncConf.setTaskTime(LocalDateTime.now());
        syncConf.setVer(ver);
        BaseResult<Long> baseResult = this.messageHubSyncCnfApi.put(syncConf);
        if (baseResult == null || baseResult.getIsError().booleanValue()) {
            throw new RuntimeException("cannot upset sync status");
        }
        return (Long)baseResult.getData();
    }

    public Stream.DBEntrySupplier.SyncConf syncConf(String syncId) {
        BaseResult<SyncConfImpl> baseResult = this.messageHubSyncCnfApi.get(syncId);
        if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
            return null;
        }
        return (Stream.DBEntrySupplier.SyncConf)baseResult.getData();
    }
}

