package com.ovopark.messagehub.sdk.msgstream;

import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.TodoMessageV2Api;
import com.ovopark.messagehub.sdk.model.kafka.TodoMsgEvent;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;

@Slf4j
public class SendTodoMsg2OtherChannelSubscriber extends CoreSubscriber<SendTodoMsg2ThirdProcessor.TodoMsgEventContext> {

    final private List<SendTodoMsg2ThirdProcessor> sendTodoMsg2ThirdProcessorList;

    final private TodoMessageV2Api todoMessageV2Api;;

    public SendTodoMsg2OtherChannelSubscriber(List<SendTodoMsg2ThirdProcessor> sendTodoMsg2ThirdProcessorList
            , TodoMessageV2Api todoMessageV2Api) {
        this.sendTodoMsg2ThirdProcessorList=sendTodoMsg2ThirdProcessorList;
        this.todoMessageV2Api=todoMessageV2Api;
    }

    public SendTodoMsg2OtherChannelSubscriber(SendTodoMsg2ThirdProcessor sendTodoMsg2ThirdProcessor
            , TodoMessageV2Api todoMessageV2Api) {
        this(Collections.singletonList(sendTodoMsg2ThirdProcessor),todoMessageV2Api);
    }

    public static Stream<SendTodoMsg2ThirdProcessor.TodoMsgEventContext> from(TodoMsgEvent todoMsgEvent){
        return Stream.from(todoMsgEvent)
                .map(SendTodoMsg2ThirdProcessor.TodoMsgEventContext::from);
    }

    @Override
    public void onNext(SendTodoMsg2ThirdProcessor.TodoMsgEventContext todoMsgEventContext) {
        ((SendTodoMsg2ThirdProcessor.TodoMsgEventContext.SimpleTodoMsgEventContext) todoMsgEventContext)
                .setTodoMessageV2Api(todoMessageV2Api);
        for (SendTodoMsg2ThirdProcessor sendTodoMsg2ThirdProcessor : sendTodoMsg2ThirdProcessorList) {
            sendTodoMsg2ThirdProcessor.send(todoMsgEventContext);
        }
    }

}
