/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk;

import com.ovopark.messagehub.sdk.TodoMessageV2Api;
import com.ovopark.messagehub.sdk.TodoMsgTagService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringTodoMsgTagService
implements TodoMsgTagService,
ApplicationContextAware {
    ApplicationContext applicationContext;
    TodoMsgTagService todoMsgTagService;

    @Autowired(required=false)
    public void setTodoMessageV2Api(TodoMessageV2Api todoMessageV2Api) {
        this.todoMsgTagService = TodoMsgTagService.newService(todoMessageV2Api);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public String get(String category, String objectType, Integer targetUserId, Long objectId, String[] others) {
        this.setTagServiceIfAbsent();
        return this.todoMsgTagService.get(category, objectType, targetUserId, objectId, others);
    }

    @Override
    public String upsert(String category, String objectType, Integer targetUserId, Long objectId, String[] others, String content) {
        this.setTagServiceIfAbsent();
        return this.todoMsgTagService.upsert(category, objectType, targetUserId, objectId, others, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTagServiceIfAbsent() {
        if (this.todoMsgTagService == null) {
            ApplicationContext applicationContext = this.applicationContext;
            synchronized (applicationContext) {
                if (this.todoMsgTagService != null) {
                    return;
                }
                TodoMessageV2Api messageV2Api = (TodoMessageV2Api)this.applicationContext.getBean(TodoMessageV2Api.class);
                if (messageV2Api == null) {
                    throw new IllegalStateException("cannot construct service");
                }
                this.todoMsgTagService = TodoMsgTagService.newService(messageV2Api);
            }
        }
    }
}

