/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.msgstream;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.TodoMessageV2Api;
import com.ovopark.messagehub.sdk.model.kafka.TodoMsgEvent;
import com.ovopark.module.shared.BaseResult;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SendTodoMsg2ThirdProcessor {
    public void send(TodoMsgEventContext var1);

    public static interface TodoMsgEventContext
    extends Stream.MsgPerContext {
        public static TodoMsgEventContext from(TodoMsgEvent todoMsgEvent) {
            return new SimpleTodoMsgEventContext(Util.isEmpty((CharSequence)todoMsgEvent.getTraceId()) ? todoMsgEvent.getOp() + "-" + todoMsgEvent.getTodoMsg().getId() : todoMsgEvent.getTraceId(), todoMsgEvent);
        }

        public TodoMsgEvent todoMsgEvent();

        public String url();

        public static class SimpleTodoMsgEventContext
        extends Stream.MsgPerContextImpl
        implements TodoMsgEventContext {
            private static final Logger log = LoggerFactory.getLogger(SimpleTodoMsgEventContext.class);
            final TodoMsgEvent todoMsgEvent;
            private final Stream.MsgPerContext.PerLogger perLogger = new Stream.MsgPerContext.PerLogger(){};
            TodoMessageV2Api todoMessageV2Api;

            private SimpleTodoMsgEventContext(String seq, TodoMsgEvent todoMsgEvent) {
                super(seq, null);
                this.todoMsgEvent = todoMsgEvent;
            }

            public Stream.MsgPerContext.PerLogger logger() {
                return this.perLogger;
            }

            @Override
            public TodoMsgEvent todoMsgEvent() {
                return this.todoMsgEvent;
            }

            @Override
            public String url() {
                if (this.todoMsgEvent == null) {
                    return null;
                }
                TodoMsgEvent.TodoMsg todoMsg = this.todoMsgEvent.getTodoMsg();
                String oauthUrl = todoMsg.getOauthUrl();
                if (Util.isNotEmpty((CharSequence)oauthUrl)) {
                    return oauthUrl;
                }
                Value value = (Value)this.setAttrIfAbsentAndGet("SimpleTodoMsgEventContext:todoMsgUrl", new Function<String, Value<String>>(){

                    @Override
                    public Value<String> apply(String s) {
                        BaseResult<String> baseResult = todoMessageV2Api.getTodoMsgUrl(todoMsgEvent);
                        this.logger().info(log, "request url result: " + JSONAccessor.impl().format(baseResult));
                        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                            return new Value<String>((String)baseResult.getData());
                        }
                        return new Value<Object>(null);
                    }
                });
                return (String)value.ref;
            }

            public void setTodoMessageV2Api(TodoMessageV2Api todoMessageV2Api) {
                this.todoMessageV2Api = todoMessageV2Api;
            }
        }

        public static class Value<T> {
            final T ref;

            public Value(T ref) {
                this.ref = ref;
            }

            public T getRef() {
                return this.ref;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value other = (Value)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                T this$ref = this.getRef();
                T other$ref = other.getRef();
                return !(this$ref == null ? other$ref != null : !this$ref.equals(other$ref));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Value;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                T $ref = this.getRef();
                result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
                return result;
            }

            public String toString() {
                return "SendTodoMsg2ThirdProcessor.TodoMsgEventContext.Value(ref=" + this.getRef() + ")";
            }
        }
    }
}

