/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.watch.common.response;

import org.slf4j.MDC;

public class BaseResult<T> {
    private Boolean isError;
    private T data;
    private String code;
    private String message;
    private String requestId = MDC.get((String)"requestId");

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    public static <T> BaseResult<T> getInstance(Boolean isError, T data, String code, String message) {
        return new BaseResult<T>(isError, data, code, message);
    }

    public static <T> BaseResult<T> invalidToken() {
        return BaseResult.getInstance(true, null, "20000", "\u65e0\u6548\u7684token");
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.getInstance(true, null, "20001", "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef");
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.getInstance(false, null, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.getInstance(false, data, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> success(T data, String code, String message) {
        return BaseResult.getInstance(false, data, code, message);
    }

    public static <T> BaseResult<T> error() {
        return BaseResult.getInstance(true, null, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return BaseResult.getInstance(true, null, code, message);
    }

    public static <T> BaseResult<T> error(T data) {
        return BaseResult.getInstance(true, data, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public abstract class CommonCode {
        public static final String SUCCESS = "0";
        public static final String ERROR = "1";
        public static final String UNKNOWN_ERROR = "-1";
        public static final String NO_PERMISSIONS = "-2";
        public static final String IS_EXIST = "10000";
        public static final String DATA_PROCESSED = "10001";
        public static final String IS_NOT_EXIST = "10002";
        public static final String INVALID_TOKEN = "20000";
        public static final String PARAM_ERROR = "20001";
        public static final String PARAM_MUST_NOT_NULL = "20002";
        public static final String EXTERNAL_SERVICE_ERROR = "20003";
        public static final String USER_OFFLINE = "20004";
        public static final String NOT_SERVICE_USER_ONLINE = "20005";
        public static final String SERVICE_USER_BUSY = "20006";
        public static final String IN_SERVICE = "20007";
        public static final String USER_EXCEPTION_NOT_HANDLER = "20008";
        public static final String USER_ONLINE = "20009";
        public static final String DEP_SERVICE_USER_BUSY = "20010";
        public static final String OTHER_SERVICE_USER_BUSY = "20011";
        public static final String MQTT_LOGIN_ERROR = "20012";

        public CommonCode(BaseResult this$0) {
        }
    }

    public abstract class CommonMessage {
        public static final String SUCCESS = "\u8bf7\u6c42\u6570\u636e\u6210\u529f!";
        public static final String ERROR = "\u8bf7\u6c42\u6570\u636e\u5931\u8d25";
        public static final String IS_EXIST = "\u8bb0\u5f55\u5df2\u5b58\u5728";
        public static final String INVALID_TOKEN = "\u65e0\u6548\u7684token";
        public static final String PARAM_ERROR = "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef";
        public static final String PARAM_MUST_NOT_NULL = "\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        public static final String EXTERNAL_SERVICE_ERROR = "\u5916\u90e8\u670d\u52a1\u8c03\u7528\u5f02\u5e38";
        public static final String NO_PERMISSIONS = "\u65e0\u6743\u9650\u8bbf\u95ee";
        public static final String DATA_PROCESSED = "\u6570\u636e\u5df2\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c";
        public static final String IS_NOT_EXIST = "\u6570\u636e\u4e0d\u5b58\u5728";
        public static final String USER_OFFLINE = "\u503c\u5b88\u4eba\u5458\u4e0d\u5728\u7ebf";
        public static final String NOT_SERVICE_USER_ONLINE = "\u65e0\u503c\u5b88\u4eba\u5458\u5728\u7ebf";
        public static final String SERVICE_USER_BUSY = "\u503c\u5b88\u4eba\u5458\u6b63\u5fd9";
        public static final String IN_SERVICE = "\u670d\u52a1\u4e2d\u4e0d\u53ef\u79bb\u5f00";
        public static final String USER_EXCEPTION_NOT_HANDLER = "\u503c\u5b88\u4eba\u5f02\u5e38\u8d85\u671f\u672a\u5904\u7406";
        public static final String USER_ONLINE = "\u7528\u6237\u5df2\u5728\u7ebf";
        public static final String DEP_SERVICE_USER_BUSY = "\u95e8\u5e97\u503c\u5b88\u4eba\u5458\u6b63\u5fd9";
        public static final String OTHER_SERVICE_USER_BUSY = "\u5176\u4ed6\u5ba2\u670d\u6b63\u5728\u670d\u52a1\u4e2d\uff0c\u4e0d\u53ef\u540c\u65f6\u670d\u52a1";
        public static final String MQTT_LOGIN_ERROR = "MQTT\u767b\u5f55\u5931\u8d25";

        public CommonMessage(BaseResult this$0) {
        }
    }
}

