/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.device.common.util.LogUtil;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static Logger log = LoggerFactory.getLogger(LogUtil.class);

    public static String getRemoteIp(HttpServletRequest request) {
        String realIp = request.getHeader("X-Real-IP");
        String remoteIp = request.getHeader("x-forwarded-for");
        if (StringUtils.isNotEmpty((CharSequence)realIp)) {
            log.info("X-Real-IP:" + realIp);
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteIp)) {
            log.info("x-forwarded-for:" + remoteIp);
            if (remoteIp.contains(",")) {
                remoteIp = remoteIp.split(",")[0].trim();
            }
            return remoteIp;
        }
        return request.getRemoteAddr();
    }

    public static JSONObject getparameters(HttpServletRequest request) {
        Enumeration parameters = request.getParameterNames();
        HashMap<String, String> map = new HashMap<String, String>();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            String value = request.getParameter(paramName);
            map.put(paramName, value);
        }
        String json = JSON.toJSONString(map);
        return JSONObject.parseObject((String)json);
    }

    public static String getPlatform(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        String platform = null;
        platform = userAgent != null ? (userAgent.contains("Android") || userAgent.contains("okhttp") ? "Android" : (userAgent.contains("iOS") ? "iOS" : "web")) : "unknown";
        return platform;
    }
}

