/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.common.util;

import com.ovopark.device.common.util.LogUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtils {
    private static Logger log = LoggerFactory.getLogger(IPUtils.class);

    public static String getMyIp() {
        String localip = null;
        String netip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    localip = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            log.error(LogUtil.getStackTraceInfo(e));
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }
}

