/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.common.util;

import com.ovopark.device.common.util.LogUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DateUtils {
    private static final Logger log = Logger.getLogger(DateUtils.class);
    public static ZoneId GMT8 = ZoneId.of("GMT+08:00");
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMAT = Format.access$000(Format.LONG_DATE_FORMAT_LINE);
    private static final DateTimeFormatter SHORT_DATE_FORMAT_NONE = Format.access$000(Format.SHORT_DATE_FORMAT_NONE);

    public static LocalDateTime parseTime(String timeStr) {
        return LocalDateTime.parse(timeStr, DEFAULT_DATETIME_FORMAT);
    }

    public static LocalDateTime parseTime(String timeStr, Format format) {
        return LocalDateTime.parse(timeStr, format.formatter);
    }

    public static String parseTime(LocalDateTime time) {
        return DEFAULT_DATETIME_FORMAT.format(time);
    }

    public static String parseTime(LocalDate date) {
        return SHORT_DATE_FORMAT_NONE.format(date);
    }

    public static String parseTime(LocalDateTime time, Format format) {
        return format.formatter.format(time);
    }

    public static String parseTime(Date time, Format format) {
        LocalDateTime localDateTime = DateUtils.dateToLocalDateTime(time);
        return format.formatter.format(localDateTime);
    }

    public static Date strToDate(String timeStr, Format format) {
        LocalDateTime dateTime = LocalDateTime.from(format.formatter.parse(timeStr));
        Date date = DateUtils.ldtToDate(dateTime);
        return date;
    }

    public static String getCurrentTime(Format format) {
        return format.formatter.format(LocalDateTime.now());
    }

    public static String getCurrentTime() {
        return DEFAULT_DATETIME_FORMAT.format(LocalDateTime.now());
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        return localDateTime;
    }

    public static Date ldtToDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        return Date.from(localDateTime.atZone(zoneId).toInstant());
    }

    public static long getNowInMillis() {
        return LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static long getNowInSecond() {
        return LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
    }

    public static long getTimeInSecond(String date) {
        return DateUtils.parseTime(date).toEpochSecond(ZoneOffset.of("+8"));
    }

    public static long getTimeInMillis(String date) {
        return DateUtils.parseTime(date).toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static String formatDateTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        Formatter ft = new Formatter(Locale.CHINA);
        return ft.format("%1$tY-%1$tm-%1$td %1$tT", cal).toString();
    }

    public static Date addDay(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, num);
        return cal.getTime();
    }

    public static long addSecond(String date, int second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.strToDate(date, Format.LONG_DATE_FORMAT_LINE));
        cal.add(13, second);
        Date newDate = cal.getTime();
        String str = DateUtils.parseTime(newDate, Format.LONG_DATE_FORMAT_LINE);
        return DateUtils.getTimeInSecond(str);
    }

    public static Date getEndTime(Date date) {
        Calendar dateEnd = Calendar.getInstance();
        dateEnd.setTime(date);
        dateEnd.set(11, 23);
        dateEnd.set(12, 59);
        dateEnd.set(13, 59);
        return dateEnd.getTime();
    }

    public static List<String> getDays(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            log.error((Object)LogUtil.getStackTraceInfo(e));
        }
        return days;
    }

    public static enum TimeType {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MIN,
        SECOND,
        MILL;

    }

    public static enum Format {
        SHORT_DATE_FORMAT_LINE("yyyy-MM-dd"),
        SHORT_DATE_FORMAT_SLASH("yyyy/MM/dd"),
        SHORT_DATE_FORMAT_DOUBLE_SLASH("yyyy\\MM\\dd"),
        SHORT_DATE_FORMAT_NONE("yyyyMMdd"),
        SHORT_DATE_FORMAT_NONEDAY("yyyyMM"),
        SHORT_DATE_FORMAT_LINE_NONEDAY("yyyy-MM"),
        LONG_DATE_FORMAT_LINE("yyyy-MM-dd HH:mm:ss"),
        LONG_DATA_FORMAT_LINE_NOSS("yyyy-MM-dd HH:mm"),
        LONG_DATE_FORMAT_LINE_ZERO("yyyy-MM-dd 00:00:00"),
        LONG_DATE_FORMAT_SLASH("yyyy/MM/dd HH:mm:ss"),
        LONG_DATA_FORMAT_SLASH_NOSS("yyyy/MM/dd HH:mm"),
        LONG_DATE_FORMAT_DOUBLE_SLASH("yyyy\\MM\\dd HH:mm:ss"),
        LONG_DATE_FORMAT_NONE("yyyyMMdd HH:mm:ss"),
        LONG_DATE_FORMAT_NONE_CHAR("yyyyMMddHHmmss"),
        LONG_DATA_FORMAT_MIN_NONE_CHAR("yyyyMMddHHmm"),
        LONG_DATE_FORMAT_LINE_HH_MM_SS("yyyy_MM_dd_HH_mm_ss"),
        LONG_DATE_FORMAT_WITH_MILSEC_LINE("yyyy-MM-dd HH:mm:ss.SSS"),
        LONG_DATE_FORMAT_WITH_MILSEC_SLASH("yyyy/MM/dd HH:mm:ss.SSS"),
        LONG_DATE_FORMAT_WITH_MILSEC_DOUBLE_SLASH("yyyy/MM/dd HH:mm:ss.SSS"),
        LONG_DATE_FORMAT_WITH_MILSEC_NONE("yyyyMMdd HH:mm:ss.SSS"),
        LONG_DATE_FORMAT_WITH_MILSEC_NONE_CHAR("yyyyMMddHHmmssSSS"),
        SHORT_DATE_FORMAT_WITH_HOURMIN("HH:mm");

        private transient DateTimeFormatter formatter;

        private Format(String pattern) {
            this.formatter = DateTimeFormatter.ofPattern(pattern);
        }
    }
}

