/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.alert;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.alert.DeviceAlertService;
import com.ovopark.device.modules.alert.mysql.DeviceAlert;
import com.ovopark.device.modules.alert.mysql.DeviceAlertMapper;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.platform.api.PicturesFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.signalling.contact.VersionConstant;
import com.ovopark.kernel.shared.Util;
import com.ovopark.service.dto.PictureDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class DeviceAlertServiceImpl
implements DeviceAlertService {
    private static final Logger log = LoggerFactory.getLogger(DeviceAlertServiceImpl.class);
    @Autowired
    private DepartmentFacade departmentFacade;
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DeviceAlertMapper deviceAlertMapper;
    @Autowired
    private PicturesFacade picturesFacade;
    @Autowired
    private MessageSource messageSource;

    @Override
    public List<DeviceAlert> getDevicesAlertList(Integer unhandled, Integer alarmType, String startTime, String endTime, Integer pageNum, Integer pageSize, String orgId, Integer userId, Integer groupId, String devicesName, Locale locale, Integer type) {
        List<DeviceAlert> result = new ArrayList<DeviceAlert>();
        Map userDepNameMap = this.departmentFacade.getUserDepNameMap(userId, groupId, orgId);
        if (CollectionUtils.isEmpty((Map)userDepNameMap)) {
            return result;
        }
        List<Integer> dtypeList = new ArrayList<Integer>();
        if (type != null) {
            switch (type) {
                case 1: {
                    dtypeList = VersionConstant.box;
                    break;
                }
                case 2: {
                    dtypeList = VersionConstant.ipc;
                    break;
                }
                case 3: {
                    dtypeList = VersionConstant.alg;
                    break;
                }
                case 4: {
                    dtypeList.add(22);
                }
            }
        } else {
            dtypeList.addAll(VersionConstant.box);
            dtypeList.addAll(VersionConstant.ipc);
            dtypeList.addAll(VersionConstant.alg);
            dtypeList.add(22);
        }
        ArrayList depIdList = new ArrayList(userDepNameMap.keySet());
        Map deviceNameMap = this.deviceStatusService.getDeviceStatusList(depIdList, devicesName, dtypeList);
        if (CollectionUtils.isEmpty((Map)deviceNameMap)) {
            return result;
        }
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 20 : pageSize;
        ArrayList deviceIdList = new ArrayList(deviceNameMap.keySet());
        Integer limitStart = (pageNum - 1) * pageSize;
        LambdaQueryWrapper deviceAlertLambdaQueryWrapper = new LambdaQueryWrapper();
        deviceAlertLambdaQueryWrapper.in(DeviceAlert::getDeviceStatusId, deviceIdList);
        if (unhandled != null) {
            deviceAlertLambdaQueryWrapper.eq(DeviceAlert::getIsHandled, (Object)unhandled);
        }
        if (alarmType != null) {
            deviceAlertLambdaQueryWrapper.eq(DeviceAlert::getAlertType, (Object)alarmType);
        }
        if (Util.isNotEmpty((CharSequence)startTime) && Util.isNotEmpty((CharSequence)endTime)) {
            deviceAlertLambdaQueryWrapper.ge(DeviceAlert::getCreateTime, (Object)startTime);
            deviceAlertLambdaQueryWrapper.le(DeviceAlert::getCreateTime, (Object)endTime);
            deviceAlertLambdaQueryWrapper.orderByDesc(DeviceAlert::getCreateTime);
        } else {
            deviceAlertLambdaQueryWrapper.orderByDesc(DeviceAlert::getId);
        }
        deviceAlertLambdaQueryWrapper.last(" limit " + limitStart.toString() + "," + pageSize);
        result = this.deviceAlertMapper.selectList((Wrapper)deviceAlertLambdaQueryWrapper);
        for (DeviceAlert alert : result) {
            PictureDTO picture;
            DeviceStatus deviceStatus = (DeviceStatus)deviceNameMap.get(alert.getDeviceStatusId());
            if (alert.getAttachId() != null && alert.getAttachId() > 0 && (picture = this.picturesFacade.getPictureById(alert.getAttachId())) != null) {
                if (picture.getOnOss() == 0) {
                    log.error("ftp \u6293\u62cd\u5e9f\u5f03");
                } else {
                    alert.setPicUrl(picture.getPath());
                }
            }
            Integer dType = deviceStatus.getDType();
            if (type != null) {
                alert.setType(type);
            } else if (VersionConstant.box.contains(dType)) {
                alert.setType(1);
            } else if (VersionConstant.ipc.contains(dType)) {
                alert.setType(2);
            } else if (VersionConstant.alg.contains(dType)) {
                alert.setType(3);
            } else if (dType != null && 22 == dType) {
                alert.setType(4);
            } else {
                throw new RuntimeException("dType is empty:" + String.valueOf(deviceStatus));
            }
            if (alert.getAlertTime() == null) {
                alert.setAlertTime(alert.getCreateTime());
            }
            if (alert.getDeviceStatusId() != null) {
                alert.setDeviceName(deviceStatus.getDeviceName());
            }
            if (Util.isNotEmpty((CharSequence)alert.getI18nKey()) && Util.isNotEmpty((CharSequence)alert.getI18nParam())) {
                Object[] params = alert.getI18nParam().split(",");
                if (alert.getAlertType() != null && params.length > 2 && alert.getAlertType() != 1) {
                    params[2] = this.messageSource.getMessage("problem.alarm." + alert.getAlertType(), null, locale);
                }
                if (alert.getAlertType() != null && params.length > 2 && alert.getAlertType() == 1) {
                    params[2] = " " + params[2];
                }
                if (alert.getAlertType() != null && params.length > 2) {
                    alert.setDescription(this.messageSource.getMessage(alert.getI18nKey(), params, locale));
                }
            }
            alert.setDepName((String)userDepNameMap.get(alert.getDepId()));
        }
        if (Util.isEmpty(result)) {
            return result;
        }
        return result;
    }
}

