/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.alert;

import com.ovopark.device.modules.alert.DeviceAlertConfigService;
import com.ovopark.device.modules.alert.DeviceOfflineCnf;
import com.ovopark.device.modules.alert.DeviceReidCnf;
import com.ovopark.device.modules.alert.DeviceVideoCnf;
import com.ovopark.device.modules.platform.ConditionOnKafka;
import com.ovopark.kernel.shared.JSONAccessor;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnKafka
@Component
public class AlertKafkaInStream {
    private static final Logger log = LoggerFactory.getLogger(AlertKafkaInStream.class);
    @Autowired
    private DeviceAlertConfigService deviceAlertConfigService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.control.sdk.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="device-alert-configure", groupId="${device.alert.kafka.group:deviceAlertConfigure}", containerFactory="deviceKafkaMainContainerFactory", id="device-alert-configure")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        String alertType = null;
        Iterable headers = record.headers().headers("alert-configure-type");
        for (Header header : headers) {
            if (!"alert-configure-type".equals(header.key())) continue;
            alertType = new String(header.value(), StandardCharsets.UTF_8);
        }
        log.info("alertType: " + alertType);
        Object value = record.value();
        if ("video".equalsIgnoreCase(alertType)) {
            message = (DeviceVideoCnf)JSONAccessor.impl().read((String)value, DeviceVideoCnf.class);
            MDC.put((String)"traceId", (String)((DeviceVideoCnf)message).getTraceId());
            MDC.put((String)"requestId", (String)("device-" + ((DeviceVideoCnf)message).getDeviceStatusId()));
            log.info(((DeviceVideoCnf)message).getDeviceStatusId() + " from SDK KAFKA: " + String.valueOf(value));
            try {
                this.deviceAlertConfigService.configureVideo((DeviceVideoCnf)message);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"requestId");
                MDC.remove((String)"traceId");
            }
        } else if ("reid".equalsIgnoreCase(alertType)) {
            message = (DeviceReidCnf)JSONAccessor.impl().read((String)value, DeviceReidCnf.class);
            MDC.put((String)"traceId", (String)((DeviceReidCnf)message).getTraceId());
            MDC.put((String)"requestId", (String)("device-" + ((DeviceReidCnf)message).getDeviceStatusId()));
            log.info(((DeviceReidCnf)message).getDeviceStatusId() + " from SDK KAFKA: " + String.valueOf(value));
            try {
                this.deviceAlertConfigService.configureReid((DeviceReidCnf)message);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"requestId");
                MDC.remove((String)"traceId");
            }
        } else {
            message = (DeviceOfflineCnf)JSONAccessor.impl().read((String)value, DeviceOfflineCnf.class);
            MDC.put((String)"traceId", (String)((DeviceOfflineCnf)message).getTraceId());
            MDC.put((String)"requestId", (String)("device-" + ((DeviceOfflineCnf)message).getDeviceStatusId()));
            log.info(((DeviceOfflineCnf)message).getDeviceStatusId() + " from SDK KAFKA: " + String.valueOf(value));
            try {
                this.deviceAlertConfigService.configureOffline((DeviceOfflineCnf)message);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"requestId");
                MDC.remove((String)"traceId");
            }
        }
    }
}

