/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.alert;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.alert.OfflineDeviceRuleService;
import com.ovopark.device.modules.alert.mysql.OfflineDeviceRule;
import com.ovopark.device.modules.alert.mysql.OfflineDeviceRuleMapper;
import com.ovopark.device.modules.alert.mysql.OfflineDeviceUser;
import com.ovopark.device.modules.alert.mysql.OfflineDeviceUserMapper;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfflineDeviceRuleServiceImpl
implements OfflineDeviceRuleService {
    @Autowired
    private OfflineDeviceRuleMapper offlineDeviceRuleMapper;
    @Autowired
    private OfflineDeviceUserMapper offlineDeviceUserMapper;
    @Resource(name="deviceStringRedisTemplate")
    private StringRedisTemplate deviceRedisTemplate;
    static OfflineDeviceRule MISSING = new OfflineDeviceRule();

    @Override
    @Transactional
    public void upset(Integer deviceId, Integer timeMin, List<Integer> userIds) {
        if (deviceId == null || timeMin == null || Util.isEmpty(userIds)) {
            return;
        }
        OfflineDeviceRule offlineDeviceRule = (OfflineDeviceRule)this.offlineDeviceRuleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(OfflineDeviceRule::getDeviceId, (Object)deviceId));
        if (offlineDeviceRule != null) {
            this.offlineDeviceUserMapper.delete((Wrapper)new LambdaQueryWrapper().eq(OfflineDeviceUser::getRuleId, (Object)offlineDeviceRule.getId()));
            this.offlineDeviceRuleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(OfflineDeviceRule::getDeviceId, (Object)deviceId));
        }
        OfflineDeviceRule rule = new OfflineDeviceRule();
        rule.setDeviceId(deviceId);
        rule.setTimeMin(timeMin);
        this.offlineDeviceRuleMapper.insert(rule);
        Util.log.info("config new rule: " + JSONAccessor.impl().format((Object)rule));
        for (Integer userId : userIds) {
            OfflineDeviceUser offlineDeviceUser = new OfflineDeviceUser();
            offlineDeviceUser.setRuleId(rule.getId());
            offlineDeviceUser.setUserId(userId);
            this.offlineDeviceUserMapper.insert(offlineDeviceUser);
        }
    }

    @Override
    @Transactional
    public void upset(List<Integer> deviceIds, Integer timeMin, List<Integer> userIds) {
        for (Integer deviceId : deviceIds) {
            this.upset(deviceId, timeMin, userIds);
        }
    }

    @Override
    public void delete(Integer deviceId) {
        OfflineDeviceRule offlineDeviceRule = (OfflineDeviceRule)this.offlineDeviceRuleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(OfflineDeviceRule::getDeviceId, (Object)deviceId));
        if (offlineDeviceRule != null) {
            this.offlineDeviceUserMapper.delete((Wrapper)new LambdaQueryWrapper().eq(OfflineDeviceUser::getRuleId, (Object)offlineDeviceRule.getId()));
            this.offlineDeviceRuleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(OfflineDeviceRule::getDeviceId, (Object)deviceId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OfflineDeviceRule ruleAtDevice(Integer deviceId) {
        OfflineDeviceRule offlineDeviceRule;
        String ruleDeviceKey = "rule-id:device:" + deviceId;
        String rule = (String)this.deviceRedisTemplate.opsForValue().get((Object)ruleDeviceKey);
        if (Util.isEmpty((CharSequence)rule)) {
            OfflineDeviceRuleServiceImpl offlineDeviceRuleServiceImpl = this;
            synchronized (offlineDeviceRuleServiceImpl) {
                Util.log.info("query rule at device: " + deviceId);
                rule = (String)this.deviceRedisTemplate.opsForValue().get((Object)ruleDeviceKey);
                if (Util.isEmpty((CharSequence)rule)) {
                    OfflineDeviceRule offlineDeviceRule2 = this.ruleAtDeviceNoCache(deviceId);
                    Util.log.info("query rule form db: " + String.valueOf(offlineDeviceRule2));
                    if (offlineDeviceRule2 == null) {
                        this.deviceRedisTemplate.opsForValue().set((Object)ruleDeviceKey, (Object)JSONAccessor.impl().format((Object)MISSING), 180L, TimeUnit.SECONDS);
                        return null;
                    }
                    this.deviceRedisTemplate.opsForValue().set((Object)ruleDeviceKey, (Object)JSONAccessor.impl().format((Object)offlineDeviceRule2), 180L, TimeUnit.SECONDS);
                    return offlineDeviceRule2;
                }
            }
        }
        OfflineDeviceRule offlineDeviceRule3 = offlineDeviceRule = Util.isEmpty((CharSequence)rule) ? null : (OfflineDeviceRule)JSONAccessor.impl().read(rule, OfflineDeviceRule.class);
        if (offlineDeviceRule != null && offlineDeviceRule.getId().compareTo(-1) == 0) {
            return null;
        }
        return offlineDeviceRule;
    }

    @Override
    public List<Integer> userIdsAtDevice(Integer deviceId) {
        OfflineDeviceRule offlineDeviceRule = this.ruleAtDeviceNoCache(deviceId);
        if (offlineDeviceRule == null) {
            return null;
        }
        List users = this.offlineDeviceUserMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(OfflineDeviceUser::getRuleId, (Object)offlineDeviceRule.getId()));
        if (Util.isNotEmpty((Collection)users)) {
            return users.stream().mapToInt(OfflineDeviceUser::getUserId).boxed().collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public OfflineDeviceRule ruleAtDeviceNoCache(Integer deviceId) {
        OfflineDeviceRule offlineDeviceRule = (OfflineDeviceRule)this.offlineDeviceRuleMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OfflineDeviceRule::getDeviceId, (Object)deviceId)).last(" limit 1"));
        return offlineDeviceRule;
    }

    static {
        MISSING.setId(-1);
    }
}

