/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.hik.manage;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.thirdparty.hik.api.HikSdkDevicesApi;
import com.ovopark.device.thirdparty.hik.model.req.CustomizationCameraListReq;
import com.ovopark.device.thirdparty.hik.model.req.CustomizationStoreInfoReq;
import com.ovopark.device.thirdparty.hik.model.req.CustomizationStoreInfoRes;
import com.ovopark.device.thirdparty.hik.model.req.HikAppKeyReq;
import com.ovopark.device.thirdparty.hik.model.req.HikCaptureReq;
import com.ovopark.device.thirdparty.hik.model.req.HikChannelListReq;
import com.ovopark.device.thirdparty.hik.model.req.HikDailyRecordReq;
import com.ovopark.device.thirdparty.hik.model.req.HikDevicesListReq;
import com.ovopark.device.thirdparty.hik.model.req.HikGetVideoUrlReq;
import com.ovopark.device.thirdparty.hik.model.req.HikGroupsActionsChildrenLisReq;
import com.ovopark.device.thirdparty.hik.model.res.HikBaseRes;
import com.ovopark.device.thirdparty.hik.model.res.HikCaptureRes;
import com.ovopark.device.thirdparty.hik.model.res.HikCustomizationCameraListRes;
import com.ovopark.device.thirdparty.hik.model.res.HikDailyRecordRes;
import com.ovopark.device.thirdparty.hik.model.res.HikDevice1Res;
import com.ovopark.device.thirdparty.hik.model.res.HikDeviceChannelRes;
import com.ovopark.device.thirdparty.hik.model.res.HikGetVideoUrlRes;
import com.ovopark.device.thirdparty.hik.model.res.HikGroupItemRes;
import com.ovopark.device.thirdparty.hik.model.res.HikPageRes;
import com.ovopark.device.thirdparty.hik.model.res.RecordDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HikSdkApiManage {
    private static final Logger log = LoggerFactory.getLogger(HikSdkApiManage.class);
    @Autowired
    private HikSdkDevicesApi hikSdkDevicesApi;

    public List<HikGroupItemRes> getAllGroups(String appKey) {
        HikAppKeyReq req = new HikAppKeyReq();
        req.setAppKey(appKey);
        log.info("hikSdkDevicesApi.getAllGroups req:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
        try {
            HikBaseRes allGroups = this.hikSdkDevicesApi.getAllGroups(req);
            log.info("hikSdkDevicesApi.getAllGroups res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)allGroups));
            return (List)allGroups.getData();
        }
        catch (Exception e) {
            log.error("hikSdkDevicesApi.getAllGroups error:{}", (Object)e.getMessage());
            return new ArrayList<HikGroupItemRes>();
        }
    }

    public List<HikGroupItemRes> getGroupsChildList(String appKey, String parentId) {
        HikGroupsActionsChildrenLisReq req = new HikGroupsActionsChildrenLisReq();
        req.setAppKey(appKey);
        req.setParentNo(parentId);
        log.info("hikSdkDevicesApi.getGroupschildrenList req:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
        try {
            HikBaseRes allGroups = this.hikSdkDevicesApi.getGroupschildrenList(req);
            log.info("hikSdkDevicesApi.getGroupschildrenList res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)allGroups));
            return (List)allGroups.getData();
        }
        catch (Exception e) {
            log.error("hikSdkDevicesApi.getGroupschildrenList error:{}", (Object)e.getMessage());
            return new ArrayList<HikGroupItemRes>();
        }
    }

    public List<CustomizationStoreInfoRes.RowsDTO> getAllStores(String appKey) {
        log.info("\u83b7\u53d6\u95e8\u5e97\u5217\u8868\u5f00\u59cb\uff1a{}", (Object)appKey);
        ArrayList<CustomizationStoreInfoRes.RowsDTO> result = new ArrayList<CustomizationStoreInfoRes.RowsDTO>();
        Integer num = 1;
        while (num < 100) {
            CustomizationStoreInfoReq req = new CustomizationStoreInfoReq();
            req.setAppKey(appKey);
            req.setPageNo(num);
            req.setPageSize(Integer.valueOf(200));
            log.info("hikSdkDevicesApi.customizationStoreInfo req:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
            try {
                List rows;
                HikBaseRes customizationStoreInfoResHikBaseRes = this.hikSdkDevicesApi.customizationStoreInfo(req);
                log.info("hikSdkDevicesApi.getGroupschildrenList res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)customizationStoreInfoResHikBaseRes));
                CustomizationStoreInfoRes data = (CustomizationStoreInfoRes)customizationStoreInfoResHikBaseRes.getData();
                Boolean hasNextPage = data.getHasNextPage();
                if (hasNextPage.booleanValue()) {
                    Integer n = num;
                    num = num + 1;
                }
                if (!CollectionUtils.isNotEmpty((Collection)(rows = data.getRows()))) continue;
                result.addAll(rows);
            }
            catch (Exception e) {
                log.error("hikSdkDevicesApi.getGroupschildrenList error:{}", (Object)e.getMessage());
                break;
            }
        }
        log.info("\u83b7\u53d6\u95e8\u5e97\u5217\u8868\u7ed3\u675f\uff1a{}", (Object)appKey);
        return result;
    }

    public List<HikCustomizationCameraListRes.RowsDTO> getStoreCameraList(String appkey, String storeId) {
        ArrayList<HikCustomizationCameraListRes.RowsDTO> res = new ArrayList<HikCustomizationCameraListRes.RowsDTO>();
        CustomizationCameraListReq req = new CustomizationCameraListReq();
        req.setPageNo(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(999));
        req.setStoreId(storeId);
        req.setAppKey(appkey);
        try {
            log.info("hikSdkDevicesApi.customizationCameraList:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
            HikBaseRes hikCustomizationCameraListResHikBaseRes = this.hikSdkDevicesApi.customizationCameraList(req);
            log.info("hikSdkDevicesApi.customizationCameraList:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)hikCustomizationCameraListResHikBaseRes));
            List rows = ((HikCustomizationCameraListRes)hikCustomizationCameraListResHikBaseRes.getData()).getRows();
            if (CollectionUtils.isNotEmpty((Collection)rows)) {
                res.addAll(rows);
            }
        }
        catch (Exception e) {
            log.error("hikSdkDevicesApi.customizationCameraList error:{}", (Object)e.getMessage());
        }
        return res;
    }

    public List<HikDevice1Res> getGroupDevices(String appKey, String groupNo) {
        Integer pageNo = 1;
        Integer pageSize = 999;
        ArrayList<HikDevice1Res> res = new ArrayList<HikDevice1Res>();
        Boolean hasMore = true;
        while (hasMore.booleanValue()) {
            HikDevicesListReq req = new HikDevicesListReq(Integer.valueOf(1), Integer.valueOf(999), groupNo, appKey);
            log.info("hikSdkDevicesApi.getDevicesList req:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
            try {
                HikBaseRes devicesList = this.hikSdkDevicesApi.getDevicesList(req);
                log.info("hikSdkDevicesApi.getDevicesList res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)devicesList));
                HikPageRes data = (HikPageRes)devicesList.getData();
                Integer total = data.getTotal();
                if (total > pageNo * pageSize) {
                    Integer n = pageNo;
                    pageNo = pageNo + 1;
                } else {
                    hasMore = false;
                }
                List rows = data.getRows();
                res.addAll(rows);
            }
            catch (Exception e) {
                log.error("hikSdkDevicesApi.getDevicesList error:{}", (Object)e.getMessage());
                hasMore = false;
            }
        }
        return res;
    }

    public List<HikDeviceChannelRes> getChannelList(String appKey, String mainDeviceNo) {
        HikChannelListReq req = new HikChannelListReq(Integer.valueOf(1), Integer.valueOf(999), mainDeviceNo, appKey);
        try {
            log.info("hikSdkDevicesApi.getChannelList req:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
            HikBaseRes channelList = this.hikSdkDevicesApi.getChannelList(req);
            log.info("hikSdkDevicesApi.getChannelList res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)channelList));
            return ((HikPageRes)channelList.getData()).getRows();
        }
        catch (Exception e) {
            log.error("hikSdkDevicesApi.getChannelList error:{}", (Object)e.getMessage());
            return new ArrayList<HikDeviceChannelRes>();
        }
    }

    public HikGetVideoUrlRes getVideoUrl(HikGetVideoUrlReq req) {
        try {
            log.info("hikSdkDevicesApi.getVideoUrl req:{}", (Object)JsonUtils.beanToJsonString((Object)req));
            HikBaseRes videoUrl = this.hikSdkDevicesApi.getVideoUrl(req);
            log.info("hikSdkDevicesApi.getVideoUrl res:{}", (Object)JsonUtils.beanToJsonString((Object)videoUrl));
            return (HikGetVideoUrlRes)videoUrl.getData();
        }
        catch (Exception e) {
            log.error("hikSdkDevicesApi.getVideoUrl error:{}", (Object)e.getMessage());
            return null;
        }
    }

    public List<RecordDetail> getDailyRecord(HikDailyRecordReq req) {
        try {
            log.info("hikSdkDevicesApi.getDailyRecord req:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
            HikBaseRes dailyRecord = this.hikSdkDevicesApi.getDailyRecord(req);
            log.info("hikSdkDevicesApi.getDailyRecord res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)dailyRecord));
            HikDailyRecordRes data = (HikDailyRecordRes)dailyRecord.getData();
            return data.getList();
        }
        catch (Exception e) {
            log.error("hikSdkDevicesApi.getDailyRecord error:{}", (Object)e.getMessage());
            return new ArrayList<RecordDetail>();
        }
    }

    public String captur(HikCaptureReq req) {
        try {
            log.info("hikSdkDevicesApi.captur req:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)req));
            HikBaseRes captur = this.hikSdkDevicesApi.captur(req);
            log.info("hikSdkDevicesApi.captur res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)captur));
            return ((HikCaptureRes)captur.getData()).getPicUrl();
        }
        catch (Exception e) {
            log.error("hikSdkDevicesApi.captur error:{}", (Object)e.getMessage());
            return null;
        }
    }
}

