/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage;

import com.ovopark.device.modules.platform.ConditionOnKafka;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnKafka
@Component
public class KKKafkaInStream {
    private static final Logger log = LoggerFactory.getLogger(KKKafkaInStream.class);

    @KafkaListener(concurrency="${messagehub.control.sdk.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="TZ-MCB-GROUP-001", groupId="${device.iotKK.kafka.group:iotKK}", containerFactory="dmsKafkaContainerFactory", id="iot-kk")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        String value = (String)record.value();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset + ",offline reason value: " + value);
    }
}

