/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.tokenflow;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEs;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEsMapper;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEsSumMapper;
import com.ovopark.device.modules.manage.mysql.LocalDayGbChannelInfoEs;
import com.ovopark.device.modules.manage.mysql.LocalDayGbChannelInfoEsMapper;
import com.ovopark.device.modules.manage.tokenflow.FlowCalculateAggr;
import com.ovopark.device.modules.manage.tokenflow.FlowCalculateRequest;
import com.ovopark.device.modules.manage.tokenflow.FlowCalculateSubscriber;
import com.ovopark.device.modules.platform.sync.DataSync;
import com.ovopark.device.modules.platform.sync.SyncConfFsyncImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.sdk.job.JobLog;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowCalculateSync
implements DataSync {
    @Autowired
    private SyncConfFsyncImpl syncConfFsync;
    @Autowired
    private LocalDayChannelInfoEsMapper localDayChannelInfoEsMapper;
    @Autowired
    private LocalDayGbChannelInfoEsMapper localDayGbChannelInfoEsMapper;
    @Autowired
    private LocalDayChannelInfoEsSumMapper localDayChannelInfoEsSumMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sync(String args, JobLog jobLog) {
        try {
            FlowCalculateRequest flowCalculateRequest;
            String seq = "FlowCalculateSync" + Util.uniqueFirstPart();
            MDC.put((String)"traceId", (String)seq);
            MDC.put((String)"requestId", (String)seq);
            Util.logLink((String)("to calculate flow: " + args)).log(arg_0 -> ((Logger)Util.log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
            FlowCalculateRequest flowCalculateRequest2 = flowCalculateRequest = Util.isEmpty((CharSequence)args) ? null : (FlowCalculateRequest)JSONAccessor.impl().read(args, FlowCalculateRequest.class);
            if (flowCalculateRequest == null) {
                flowCalculateRequest = new FlowCalculateRequest();
                flowCalculateRequest.setCountDate(Util.formatTime((LocalDate)LocalDate.now().minusDays(1L), (String[])new String[]{"yyyyMMdd"}));
            }
            String countDate = flowCalculateRequest.getCountDate();
            FlowCalculateAggr flowCalculateAggr = new FlowCalculateAggr(this.localDayChannelInfoEsSumMapper, flowCalculateRequest);
            FlowCalculateSubscriber flowCalculateSubscriber = new FlowCalculateSubscriber(flowCalculateAggr, flowCalculateRequest);
            Util.logLink((String)"to scan nvr flow ").log(arg_0 -> ((Logger)Util.log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
            int n = this.nvrFlow0(flowCalculateSubscriber, countDate);
            Util.logLink((String)("nvr processed : " + n + ", to scan gb ")).log(arg_0 -> ((Logger)Util.log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
            int g = this.gbFlow0(flowCalculateSubscriber, countDate);
            Util.logLink((String)("gb processed : " + g)).log(arg_0 -> ((Logger)Util.log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
            Util.logLink((String)"ok . all flow processed , to save to db").log(arg_0 -> ((Logger)Util.log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
            int l = flowCalculateAggr.fsync();
            Util.logLink((String)"ok . completed").log(arg_0 -> ((Logger)Util.log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
            int n2 = l;
            return n2;
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }

    private int nvrFlow0(FlowCalculateSubscriber flowCalculateSubscriber, final String countDate) {
        final AtomicInteger count = new AtomicInteger();
        String localNvrTokenFlowSyncId = "localNvrTokenFlowSyncId";
        Stream.from((Stream.DBEntrySupplier)new Stream.DBEntrySupplier<LocalDayChannelInfoEs>(){

            public List<LocalDayChannelInfoEs> get(LocalDayChannelInfoEs nextCompare, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync) {
                Stream.DBEntrySupplier.SyncConf syncConf;
                if (nextCompare == null && (syncConf = syncConfFsync.syncConf("localNvrTokenFlowSyncId")) == null) {
                    Util.log.info("exit,cannot find any config: localNvrTokenFlowSyncId");
                    return Collections.EMPTY_LIST;
                }
                StopWatch stopWatch = StopWatch.createStarted();
                Util.log.info("to pull local_summary_day_channel_info_es, top: all");
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(LocalDayChannelInfoEs::getCountDate, (Object)countDate);
                List list = FlowCalculateSync.this.localDayChannelInfoEsMapper.selectList((Wrapper)lambdaQueryWrapper);
                stopWatch.stop();
                Util.log.info("db pull local_summary_day_channel_info_es: cost: " + stopWatch.toString() + ", size: " + list.size());
                count.addAndGet(list.size());
                return list;
            }

            public boolean continueGet(int lastGetCount) {
                return false;
            }

            public void onComplete(LocalDayChannelInfoEs nextCompare, long sum, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync, Throwable t) {
                if (t != null) {
                    throw new RuntimeException(t);
                }
                if (nextCompare == null) {
                    return;
                }
                syncConfFsync.fsync("localNvrTokenFlowSyncId", null, nextCompare.getCountDate(), (int)sum, "complete");
            }
        }, (Stream.DBEntrySupplier.SyncConfFsync)this.syncConfFsync).cancelOnMax(1000000).onErrorStop().subscribe((Subscriber)flowCalculateSubscriber);
        return count.get();
    }

    private int gbFlow0(FlowCalculateSubscriber flowCalculateSubscriber, final String countDate) {
        String localGbTokenFlowSyncId = "localGbTokenFlowSyncId";
        final AtomicInteger count = new AtomicInteger();
        Stream.from((Stream.DBEntrySupplier)new Stream.DBEntrySupplier<LocalDayGbChannelInfoEs>(){

            public List<LocalDayGbChannelInfoEs> get(LocalDayGbChannelInfoEs nextCompare, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync) {
                Stream.DBEntrySupplier.SyncConf syncConf;
                if (nextCompare == null && (syncConf = syncConfFsync.syncConf("localGbTokenFlowSyncId")) == null) {
                    Util.log.info("exit,cannot find any config: localGbTokenFlowSyncId");
                    return Collections.EMPTY_LIST;
                }
                StopWatch stopWatch = StopWatch.createStarted();
                Util.log.info("to pull local_summary_day_gb_channel_info_es, top: all");
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(LocalDayGbChannelInfoEs::getCountDate, (Object)countDate);
                List list = FlowCalculateSync.this.localDayGbChannelInfoEsMapper.selectList((Wrapper)lambdaQueryWrapper);
                stopWatch.stop();
                Util.log.info("db pull local_summary_day_gb_channel_info_es: cost: " + stopWatch.toString() + ", size: " + list.size());
                count.addAndGet(list.size());
                return list;
            }

            public boolean continueGet(int lastGetCount) {
                return false;
            }

            public void onComplete(LocalDayGbChannelInfoEs nextCompare, long sum, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync, Throwable t) {
                if (nextCompare == null) {
                    return;
                }
                syncConfFsync.fsync("localGbTokenFlowSyncId", null, nextCompare.getCountDate(), (int)sum, "complete");
            }
        }, (Stream.DBEntrySupplier.SyncConfFsync)this.syncConfFsync).cancelOnMax(1000000).onErrorStop().subscribe((Subscriber)flowCalculateSubscriber);
        return count.get();
    }
}

