/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.tokenflow;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.manage.mysql.DayChannelInfoEs;
import com.ovopark.device.modules.manage.mysql.DayChannelInfoEsMapper;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEs;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEsMapper;
import com.ovopark.device.modules.platform.sync.DataSync;
import com.ovopark.device.modules.platform.sync.SyncConfFsyncImpl;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.sdk.job.JobLog;
import com.ovopark.module.shared.spring.InfoCollector;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NVRTokenDataSync
implements DataSync {
    private static final String nvrTokenFlowSyncId = "nvrTokenFlowSyncId";
    @Autowired
    private SyncConfFsyncImpl syncConfFsync;
    @Autowired
    private DayChannelInfoEsMapper dayChannelInfoEsMapper;
    @Autowired
    private LocalDayChannelInfoEsMapper localDayChannelInfoEsMapper;
    final AtomicLong sumCount = new AtomicLong();

    public int sync(String args, JobLog jobLog) {
        final String countDate = Util.isNotEmpty((CharSequence)args) ? args : Util.formatTime((LocalDate)LocalDate.now().minusDays(1L), (String[])new String[]{"yyyyMMdd"});
        final AtomicInteger count = new AtomicInteger();
        Stream.from((Stream.DBEntrySupplier)new Stream.DBEntrySupplier<DayChannelInfoEs>(){

            public List<DayChannelInfoEs> get(DayChannelInfoEs nextCompare, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync) {
                Stream.DBEntrySupplier.SyncConf syncConf;
                if (nextCompare == null && (syncConf = syncConfFsync.syncConf(NVRTokenDataSync.nvrTokenFlowSyncId)) == null) {
                    Util.log.info("exit,cannot find any config: nvrTokenFlowSyncId");
                    return Collections.EMPTY_LIST;
                }
                StopWatch stopWatch = StopWatch.createStarted();
                Util.log.info("to pull summary_day_channel_info_es, top: all");
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(DayChannelInfoEs::getCountDate, (Object)countDate);
                List list = NVRTokenDataSync.this.dayChannelInfoEsMapper.selectList((Wrapper)lambdaQueryWrapper);
                stopWatch.stop();
                Util.log.info("db pull summary_day_channel_info_es: cost: " + stopWatch.toString() + ", size: " + list.size());
                return list;
            }

            public boolean continueGet(int lastGetCount) {
                return false;
            }

            public void onComplete(DayChannelInfoEs nextCompare, long sum, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync, Throwable t) {
                if (t != null) {
                    throw new RuntimeException(t);
                }
                if (nextCompare == null) {
                    return;
                }
                syncConfFsync.fsync(NVRTokenDataSync.nvrTokenFlowSyncId, null, nextCompare.getCountDate(), (int)sum, "complete");
            }
        }, (Stream.DBEntrySupplier.SyncConfFsync)this.syncConfFsync).cancelOnMax(1000000).partition(1000).onErrorStop().subscribe((Subscriber)new CoreSubscriber<List<DayChannelInfoEs>>(){

            public void onNext(List<DayChannelInfoEs> records) {
                for (DayChannelInfoEs record : records) {
                    LocalDayChannelInfoEs localDayChannelInfoEs = new LocalDayChannelInfoEs();
                    BeanUtils.copyProperties((Object)record, (Object)localDayChannelInfoEs);
                    LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(LocalDayChannelInfoEs.class).eq(LocalDayChannelInfoEs::getLicenseToken, (Object)record.getLicenseToken())).eq(LocalDayChannelInfoEs::getMac, (Object)record.getMac())).eq(LocalDayChannelInfoEs::getCountDate, (Object)record.getCountDate());
                    Long l = NVRTokenDataSync.this.localDayChannelInfoEsMapper.selectCount((Wrapper)queryWrapper);
                    if (l > 0L) {
                        NVRTokenDataSync.this.localDayChannelInfoEsMapper.delete((Wrapper)queryWrapper);
                    }
                    NVRTokenDataSync.this.localDayChannelInfoEsMapper.insert(localDayChannelInfoEs);
                    count.incrementAndGet();
                }
            }

            public void onComplete() {
                Util.log.info("summary_day_channel_info_es complete.");
            }

            public void onError(Throwable t) {
                throw new RuntimeException(t);
            }
        });
        this.sumCount.addAndGet(count.get());
        InfoCollector.getOrCreate().put("SUM_SYNC_COUNT", String.valueOf(this.sumCount.get()));
        return count.get();
    }
}

