/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.tokenflow;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.manage.mysql.DayGbChannelInfoEs;
import com.ovopark.device.modules.manage.mysql.DayGbChannelInfoEsMapper;
import com.ovopark.device.modules.manage.mysql.LocalDayGbChannelInfoEs;
import com.ovopark.device.modules.manage.mysql.LocalDayGbChannelInfoEsMapper;
import com.ovopark.device.modules.platform.sync.DataSync;
import com.ovopark.device.modules.platform.sync.SyncConfFsyncImpl;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.sdk.job.JobLog;
import com.ovopark.module.shared.spring.InfoCollector;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GbTokenDataSync
implements DataSync {
    private static final String gbTokenFlowSyncId = "gbTokenFlowSyncId";
    @Autowired
    private SyncConfFsyncImpl syncConfFsync;
    @Autowired
    private DayGbChannelInfoEsMapper dayGbChannelInfoEsMapper;
    @Autowired
    private LocalDayGbChannelInfoEsMapper localDayGbChannelInfoEsMapper;
    final AtomicLong sumCount = new AtomicLong();

    public int sync(String args, JobLog jobLog) {
        final String countDate = Util.isNotEmpty((CharSequence)args) ? args : Util.formatTime((LocalDate)LocalDate.now().minusDays(1L), (String[])new String[]{"yyyyMMdd"});
        final AtomicInteger count = new AtomicInteger();
        Stream.from((Stream.DBEntrySupplier)new Stream.DBEntrySupplier<DayGbChannelInfoEs>(){

            public List<DayGbChannelInfoEs> get(DayGbChannelInfoEs nextCompare, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync) {
                Stream.DBEntrySupplier.SyncConf syncConf;
                if (nextCompare == null && (syncConf = syncConfFsync.syncConf(GbTokenDataSync.gbTokenFlowSyncId)) == null) {
                    Util.log.info("exit,cannot find any config: gbTokenFlowSyncId");
                    return Collections.EMPTY_LIST;
                }
                StopWatch stopWatch = StopWatch.createStarted();
                Util.log.info("to pull summary_day_gb_channel_info_es, top: all");
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(DayGbChannelInfoEs::getCountDate, (Object)countDate);
                List list = GbTokenDataSync.this.dayGbChannelInfoEsMapper.selectList((Wrapper)lambdaQueryWrapper);
                stopWatch.stop();
                Util.log.info("db pull summary_day_gb_channel_info_es: cost: " + stopWatch.toString() + ", size: " + list.size());
                return list;
            }

            public boolean continueGet(int lastGetCount) {
                return false;
            }

            public void onComplete(DayGbChannelInfoEs nextCompare, long sum, Stream.DBEntrySupplier.SyncConfFsync syncConfFsync, Throwable t) {
                if (t != null) {
                    throw new RuntimeException(t);
                }
                if (nextCompare == null) {
                    return;
                }
                syncConfFsync.fsync(GbTokenDataSync.gbTokenFlowSyncId, null, nextCompare.getCountDate(), (int)sum, "complete");
            }
        }, (Stream.DBEntrySupplier.SyncConfFsync)this.syncConfFsync).cancelOnMax(1000000).partition(1000).onErrorStop().subscribe((Subscriber)new CoreSubscriber<List<DayGbChannelInfoEs>>(){

            public void onNext(List<DayGbChannelInfoEs> records) {
                for (DayGbChannelInfoEs record : records) {
                    LocalDayGbChannelInfoEs localDayGbChannelInfoEs = new LocalDayGbChannelInfoEs();
                    BeanUtils.copyProperties((Object)record, (Object)localDayGbChannelInfoEs);
                    LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(LocalDayGbChannelInfoEs.class).eq(LocalDayGbChannelInfoEs::getLicenseToken, (Object)record.getLicenseToken())).eq(LocalDayGbChannelInfoEs::getDeviceId, (Object)record.getDeviceId())).eq(LocalDayGbChannelInfoEs::getCountDate, (Object)record.getCountDate());
                    Long l = GbTokenDataSync.this.localDayGbChannelInfoEsMapper.selectCount((Wrapper)queryWrapper);
                    if (l > 0L) {
                        GbTokenDataSync.this.localDayGbChannelInfoEsMapper.delete((Wrapper)queryWrapper);
                    }
                    GbTokenDataSync.this.localDayGbChannelInfoEsMapper.insert(localDayGbChannelInfoEs);
                    count.incrementAndGet();
                }
            }

            public void onComplete() {
                Util.log.info("summary_day_gb_channel_info_es complete.");
            }

            public void onError(Throwable t) {
                throw new RuntimeException(t);
            }
        });
        this.sumCount.addAndGet(count.get());
        InfoCollector.getOrCreate().put("SUM_SYNC_COUNT", String.valueOf(this.sumCount.get()));
        return count.get();
    }
}

