/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.tokenflow;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEsSumMapper;
import com.ovopark.device.modules.manage.tokenflow.FlowStatService;
import com.ovopark.device.modules.manage.tokenflow.GroupFlowQuery;
import com.ovopark.device.modules.manage.tokenflow.GroupFlowVo;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowStatServiceImpl
implements FlowStatService {
    @Autowired
    private LocalDayChannelInfoEsSumMapper localDayChannelInfoEsSumMapper;
    @Autowired
    private RPCFacade rpcFacade;

    @Override
    public PageModel<GroupFlowVo> groupFlow(GroupFlowQuery groupFlowQuery) {
        Page page = new Page();
        long pageNumber = groupFlowQuery.getPageNumber();
        page.setCurrent(pageNumber);
        int pageSize = groupFlowQuery.getPageSize();
        page.setSize((long)pageSize);
        IPage<GroupFlowVo> groupFlowVoIPage = this.localDayChannelInfoEsSumMapper.queryPage((Page<GroupFlowVo>)page, groupFlowQuery.getStartTime(), groupFlowQuery.getEndTime());
        if (Util.isEmpty((Collection)groupFlowVoIPage.getRecords())) {
            return PageModel.from((long)pageNumber, (int)pageSize, (long)0L, null);
        }
        List<Integer> list = groupFlowVoIPage.getRecords().stream().map(GroupFlowVo::getEnterpriseId).toList();
        List enterpriseGroupMoList = this.rpcFacade.enterpriseList(list);
        Map<Integer, EnterpriseGroupMo> enterpriseGroupMoMap = enterpriseGroupMoList.stream().collect(Collectors.toMap(EnterpriseGroupMo::getId, v -> v));
        for (GroupFlowVo record : groupFlowVoIPage.getRecords()) {
            EnterpriseGroupMo enterpriseGroupMo = enterpriseGroupMoMap.get(record.getEnterpriseId());
            if (enterpriseGroupMo != null) continue;
        }
        return PageModel.from((long)pageNumber, (int)pageSize, (long)groupFlowVoIPage.getTotal(), (List)groupFlowVoIPage.getRecords());
    }
}

