/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage;

import com.ovopark.device.modules.manage.diskerror.DiskStatService;
import com.ovopark.device.modules.platform.ConditionOnKafka;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnKafka
@Component
public class DiskErrorKafkaInStream {
    private static final Logger log = LoggerFactory.getLogger(DiskErrorKafkaInStream.class);
    @Autowired
    private DiskStatService diskStatService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.control.sdk.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="DISK-ERROR-STAT", groupId="${device.diskErrorStat.kafka.group:diskErrorStat}", containerFactory="dmsKafkaContainerFactory", id="disk-error-stat")
    public void diskErrorStat(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        Map map = JSONAccessor.impl().read((String)value);
        String uuid = Util.convert2String(map.get("uuid"));
        MDC.put((String)"traceId", (String)uuid);
        MDC.put((String)"requestId", (String)("disk-error-stat-" + uuid));
        log.info(uuid + " from DISK ERROR STAT KAFKA: " + String.valueOf(value));
        try {
            this.diskStatService.insert(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

