/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.device.modules.platform.DeviceNewService;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.modules.platform.mysql.DevicesMapper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceNewServiceImpl
implements DeviceNewService {
    private static final Logger log = LoggerFactory.getLogger(DeviceNewServiceImpl.class);
    @Resource
    private DevicesMapper devicesMapper;

    @Override
    public Map<Integer, Integer> getDepDeviceNum(List<Integer> depIds) {
        if (depIds == null || depIds.isEmpty()) {
            return new HashMap<Integer, Integer>();
        }
        HashMap<Integer, Integer> depDeviceNum = new HashMap<Integer, Integer>(depIds.size());
        for (Integer depId : depIds) {
            depDeviceNum.put(depId, 0);
        }
        List devices = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).in(Devices::getDepId, depIds)).select(new SFunction[]{Devices::getDepId}));
        for (Devices item : devices) {
            depDeviceNum.put(item.getDepId(), (Integer)depDeviceNum.get(item.getDepId()) + 1);
        }
        return depDeviceNum;
    }

    @Override
    public Map<Integer, Integer> getDepDeviceNumByGroupId(Integer groupId) {
        HashMap<Integer, Integer> depDeviceNum = new HashMap<Integer, Integer>();
        List devices = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).in(Devices::getGroupId, new Object[]{groupId})).select(new SFunction[]{Devices::getDepId}));
        for (Devices item : devices) {
            depDeviceNum.put(item.getDepId(), depDeviceNum.getOrDefault(item.getDepId(), 0) + 1);
        }
        return depDeviceNum;
    }

    @Override
    public List<Integer> getDepDeviceIdList(Integer depId) {
        return this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getDepId, (Object)depId)).select(new SFunction[]{Devices::getId})).stream().map(Devices::getId).toList();
    }

    @Override
    public List<Devices> getDeviceList(Integer depId) {
        return this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getDepId, (Object)depId));
    }

    @Override
    public List<Devices> getDeviceListByDepIdListAndGroupId(@NotNull List<Integer> depIdList, @NotNull Integer groupId) {
        return this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getGroupId, (Object)groupId)).in(Devices::getDepId, depIdList));
    }

    @Override
    public List<Integer> getDepIdListByDeviceName(String deviceName, Integer groupId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List devices = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getGroupId, (Object)groupId)).isNotNull(Devices::getDepId)).like(Devices::getName, (Object)("%" + deviceName + "%"))).groupBy(Devices::getDepId)).select(new SFunction[]{Devices::getDepId}));
        for (Devices item : devices) {
            result.add(item.getDepId());
        }
        return result;
    }

    @Override
    public Devices getDeviceById(Integer deviceId) {
        return (Devices)this.devicesMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getId, (Object)deviceId));
    }
}

