/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.PlatformsMapper;
import com.ovopark.device.platform.api.UserDepartmentPrivilegeFacade;
import com.ovopark.device.platform.api.UserRoleFacade;
import com.ovopark.device.platform.api.UsersFacade;
import com.ovopark.kernel.shared.Util;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.privilege.pojo.UsersPojo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceStatusServiceImpl
implements DeviceStatusService {
    private static final Logger log = LoggerFactory.getLogger(DeviceStatusServiceImpl.class);
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    private PlatformsMapper platformsMapper;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Resource
    private UsersFacade usersFacade;
    @Resource
    private UserRoleFacade userRoleFacade;
    @Resource
    private UserDepartmentPrivilegeFacade userDepartmentPrivilegeFacade;

    @Override
    public List<DeviceStatus> listDevice(@NotNull Integer deptId) {
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).eq(DeviceStatus::getDepId, (Object)deptId)).eq(DeviceStatus::getIsDelete, (Object)0));
        return deviceStatusList;
    }

    @Override
    public DeviceStatus getById(@NotNull Integer id) {
        return (DeviceStatus)this.deviceStatusMapper.selectById(id);
    }

    @Override
    public List<DeviceStatus> getDeviceStatusListByIds(List<Integer> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            return this.deviceStatusMapper.selectList((Wrapper)new LambdaQueryWrapper().in(DeviceStatus::getId, ids));
        }
        return Lists.newArrayList();
    }

    @Override
    public Map<Integer, String> getUserDepNameMap(Integer userId, Integer enterpriseId, String organizeId) {
        HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setUserId(userId);
        mo.setUserGroupId(enterpriseId);
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            mo.setOrganizeIdList(Arrays.asList(split));
        }
        mo.setIsDel(Integer.valueOf(0));
        Map<Integer, DepartmentOrgMo> userDepNameMapNew = this.getUserDepNameMapNew(mo);
        for (Integer depId : userDepNameMapNew.keySet()) {
            DepartmentOrgMo departmentOrgMo = userDepNameMapNew.get(depId);
            if (departmentOrgMo == null) continue;
            nameMap.put(depId, departmentOrgMo.getName());
        }
        return nameMap;
    }

    private Map<Integer, DepartmentOrgMo> getUserDepNameMapNew(DepIdsAndUserMo mo) {
        HashMap<Integer, DepartmentOrgMo> result = new HashMap<Integer, DepartmentOrgMo>();
        try {
            BaseResult userPrivilegeDepByOrganizeIds = this.userDepPrivilegeApi.getUserPrivilegeDepByOrganizeIds(mo);
            List data = (List)userPrivilegeDepByOrganizeIds.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (DepartmentOrgMo item : data) {
                    result.put(item.getDepId(), item);
                }
            }
        }
        catch (Exception e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
        }
        return result;
    }

    @Override
    public List<DeviceStatus> getUserDeviceStatus(Integer userId, Integer groupId, List<Integer> deptIds) {
        return this.getUserDeviceStatus(userId, groupId, deptIds, null, null);
    }

    @Override
    public List<DeviceStatus> getUserDeviceStatus(Integer userId, Integer groupId, List<Integer> deptIds, List<String> deviceTypeList, List<Integer> excludeDtypeList) {
        long start = System.currentTimeMillis();
        ArrayList<DeviceStatus> result1 = new ArrayList<DeviceStatus>();
        if (groupId == null) {
            return result1;
        }
        int pageSize = 600;
        UsersPojo users = this.usersFacade.getUsersById(userId);
        Boolean supureFlag = false;
        if (this.userRoleFacade.isSystemAdmin(userId, null).booleanValue() || users.getIsAgency() == 2) {
            supureFlag = true;
        }
        if (!supureFlag.booleanValue()) {
            supureFlag = this.userRoleFacade.isSuperAdmin(userId, groupId);
        }
        if (supureFlag.booleanValue()) {
            if (deptIds == null || deptIds.size() <= pageSize) {
                LambdaQueryWrapper deviceStatusLambdaQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)deviceStatusLambdaQueryWrapper.eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getGroupId, (Object)groupId);
                if (CollectionUtils.isNotEmpty(deptIds)) {
                    deviceStatusLambdaQueryWrapper.in(DeviceStatus::getDepId, deptIds);
                }
                if (CollectionUtils.isNotEmpty(deviceTypeList)) {
                    deviceStatusLambdaQueryWrapper.in(DeviceStatus::getDeviceType, deviceTypeList);
                }
                if (CollectionUtils.isNotEmpty(excludeDtypeList)) {
                    deviceStatusLambdaQueryWrapper.notIn(DeviceStatus::getDType, excludeDtypeList);
                }
                deviceStatusLambdaQueryWrapper.orderByAsc(DeviceStatus::getDepId);
                List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)deviceStatusLambdaQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)deviceStatusList)) {
                    result1.addAll(deviceStatusList);
                }
            } else {
                List partition = Lists.partition(deptIds, (int)pageSize);
                for (List item : partition) {
                    LambdaQueryWrapper deviceStatusLambdaQueryWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)deviceStatusLambdaQueryWrapper.eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getGroupId, (Object)groupId);
                    if (CollectionUtils.isNotEmpty((Collection)item)) {
                        deviceStatusLambdaQueryWrapper.in(DeviceStatus::getDepId, (Collection)item);
                    }
                    if (CollectionUtils.isNotEmpty(deviceTypeList)) {
                        deviceStatusLambdaQueryWrapper.in(DeviceStatus::getDeviceType, deviceTypeList);
                    }
                    if (CollectionUtils.isNotEmpty(excludeDtypeList)) {
                        deviceStatusLambdaQueryWrapper.notIn(DeviceStatus::getDType, excludeDtypeList);
                    }
                    deviceStatusLambdaQueryWrapper.orderByAsc(DeviceStatus::getDepId);
                    List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)deviceStatusLambdaQueryWrapper);
                    if (!CollectionUtils.isNotEmpty((Collection)deviceStatusList)) continue;
                    result1.addAll(deviceStatusList);
                }
            }
        } else {
            List userDepIds = this.userDepartmentPrivilegeFacade.getUserDepIds(userId, groupId);
            if (CollectionUtils.isNotEmpty((Collection)userDepIds)) {
                userDepIds.retainAll(deptIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)userDepIds)) {
                if (userDepIds.size() <= pageSize) {
                    List deviceStatusList;
                    LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).in(DeviceStatus::getDepId, (Collection)userDepIds)).eq(DeviceStatus::getGroupId, (Object)groupId)).orderByAsc(DeviceStatus::getDepId);
                    if (CollectionUtils.isNotEmpty(deviceTypeList)) {
                        queryWrapper.in(DeviceStatus::getDeviceType, deviceTypeList);
                    }
                    if (CollectionUtils.isNotEmpty(excludeDtypeList)) {
                        queryWrapper.notIn(DeviceStatus::getDType, excludeDtypeList);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper)))) {
                        result1.addAll(deviceStatusList);
                    }
                } else {
                    List partition = Lists.partition((List)userDepIds, (int)pageSize);
                    for (List item : partition) {
                        List deviceStatusList;
                        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).in(DeviceStatus::getDepId, (Collection)item)).eq(DeviceStatus::getGroupId, (Object)groupId)).orderByAsc(DeviceStatus::getDepId);
                        if (CollectionUtils.isNotEmpty(deviceTypeList)) {
                            queryWrapper.in(DeviceStatus::getDeviceType, deviceTypeList);
                        }
                        if (CollectionUtils.isNotEmpty(excludeDtypeList)) {
                            queryWrapper.notIn(DeviceStatus::getDType, excludeDtypeList);
                        }
                        if (!CollectionUtils.isNotEmpty((Collection)(deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper)))) continue;
                        result1.addAll(deviceStatusList);
                    }
                }
            }
        }
        long end = System.currentTimeMillis();
        log.info("\u8fd0\u884c\u65f6\u95f4\uff1a{},groupId:{},\u53c2\u6570deptList.size:{}", new Object[]{end - start, groupId, deptIds == null ? 0 : deptIds.size()});
        return result1;
    }

    @Override
    public List<DeviceStatus> getDeviceStatusList(Integer groupId, List<Integer> deptIds, List<Integer> exitDeptList, List<String> deviceTypeList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (groupId != null) {
            queryWrapper.eq(DeviceStatus::getGroupId, (Object)groupId);
        }
        if (CollectionUtils.isNotEmpty(deptIds) && CollectionUtils.isNotEmpty(exitDeptList)) {
            if (deptIds.size() >= exitDeptList.size()) {
                queryWrapper.in(DeviceStatus::getDepId, deptIds);
            } else {
                queryWrapper.notIn(DeviceStatus::getDepId, exitDeptList);
            }
        } else {
            if (CollectionUtils.isNotEmpty(deptIds)) {
                queryWrapper.in(DeviceStatus::getDepId, deptIds);
            }
            if (CollectionUtils.isNotEmpty(exitDeptList)) {
                queryWrapper.notIn(DeviceStatus::getDepId, exitDeptList);
            }
        }
        if (CollectionUtils.isNotEmpty(deviceTypeList)) {
            queryWrapper.in(DeviceStatus::getDeviceType, deviceTypeList);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getIsDelete, (Object)0)).orderByAsc(DeviceStatus::getDepId);
        return this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DeviceStatus> getDeviceList(@NotNull String thirdpartDevId, @NotNull Integer channelId, @NotNull Integer dtype, Integer delFlag) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getThirdpartDevId, (Object)thirdpartDevId)).eq(DeviceStatus::getChannelId, (Object)channelId)).eq(DeviceStatus::getDType, (Object)dtype)).eq(delFlag != null, DeviceStatus::getIsDelete, (Object)delFlag);
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
        return deviceStatusList;
    }

    @Override
    public void insert(DeviceStatus deviceStatus) {
        this.deviceStatusMapper.insert(deviceStatus);
    }

    @Override
    public void updateDelFlagById(Integer deviceStatusId, Integer delFlag) {
        this.deviceStatusMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(DeviceStatus::getId, (Object)deviceStatusId)).set(DeviceStatus::getIsDelete, (Object)delFlag));
    }
}

