/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.ovopark.device.cloud.api.DeviceStatusApi;
import com.ovopark.device.common.response.BaseResult;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.model.OnOffVo;
import com.ovopark.kernel.shared.Util;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="com.ovopark.device.modules.platform.OnlineFacadeRPC")
public class OnlineFacadeRPC
implements OnlineFacade {
    public static final String BEAN_NAME = "com.ovopark.device.modules.platform.OnlineFacadeRPC";
    @Resource
    private DeviceStatusApi deviceStatusApi;

    public Map<Integer, Integer> onOffRT(List<Integer> deviceStatusIdList) {
        BaseResult dmsOnlineMap = this.deviceStatusApi.getDmsOnlineMap(deviceStatusIdList);
        if (dmsOnlineMap != null && !dmsOnlineMap.getIsError().booleanValue()) {
            return (Map)dmsOnlineMap.getData();
        }
        return null;
    }

    public Map<Integer, Integer> onOffNRT(List<Integer> deviceStatusIdList) {
        return this.onOffRT(deviceStatusIdList);
    }

    public Map<Integer, OnOffVo> onOffTimeRT(List<Integer> deviceStatusIdList) {
        BaseResult dmsOnOffMap = this.deviceStatusApi.getDmsOnOffMap(deviceStatusIdList);
        if (dmsOnOffMap != null && !dmsOnOffMap.getIsError().booleanValue() && Util.isNotEmpty((Map)((Map)dmsOnOffMap.getData()))) {
            HashMap<Integer, OnOffVo> onOffVoMap = new HashMap<Integer, OnOffVo>();
            ((Map)dmsOnOffMap.getData()).forEach((k, v) -> {
                OnOffVo onOffVo = new OnOffVo();
                onOffVo.setId(v.getId());
                onOffVo.setOnline(v.getOnline());
                onOffVo.setOfflineTimeStamp(v.getOfflineTimeStamp());
                onOffVoMap.put((Integer)k, onOffVo);
            });
            return onOffVoMap;
        }
        return null;
    }

    public Map<Integer, OnOffVo> onOffTimeNRT(List<Integer> deviceStatusIdList) {
        return this.onOffTimeRT(deviceStatusIdList);
    }
}

