/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.device.modules.platform.DeviceNewService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.modules.platform.mysql.DevicesMapper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceNewServiceImpl
implements DeviceNewService {
    private static final Logger log = LoggerFactory.getLogger(DeviceNewServiceImpl.class);
    @Resource
    private DevicesMapper devicesMapper;
    @Autowired
    private DeviceStatusService deviceStatusService;

    @Override
    public Map<Integer, Integer> getDepDeviceNum(List<Integer> depIds) {
        if (depIds == null || depIds.isEmpty()) {
            return new HashMap<Integer, Integer>();
        }
        HashMap<Integer, Integer> depDeviceNum = new HashMap<Integer, Integer>(depIds.size());
        for (Integer depId : depIds) {
            depDeviceNum.put(depId, 0);
        }
        List devices = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).in(Devices::getDepId, depIds)).select(new SFunction[]{Devices::getDepId}));
        for (Devices item : devices) {
            depDeviceNum.put(item.getDepId(), (Integer)depDeviceNum.get(item.getDepId()) + 1);
        }
        return depDeviceNum;
    }

    @Override
    public Map<Integer, Integer> getDepDeviceNumByGroupId(Integer groupId) {
        HashMap<Integer, Integer> depDeviceNum = new HashMap<Integer, Integer>();
        List devices = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).in(Devices::getGroupId, new Object[]{groupId})).select(new SFunction[]{Devices::getDepId}));
        for (Devices item : devices) {
            depDeviceNum.put(item.getDepId(), depDeviceNum.getOrDefault(item.getDepId(), 0) + 1);
        }
        return depDeviceNum;
    }

    @Override
    public List<Integer> getDepDeviceIdList(Integer depId) {
        return this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getDepId, (Object)depId)).select(new SFunction[]{Devices::getId})).stream().map(Devices::getId).toList();
    }

    @Override
    public List<Devices> getDeviceList(Integer depId) {
        return this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getDepId, (Object)depId));
    }

    @Override
    public List<Devices> getDeviceListByDepIdListAndGroupId(@NotNull List<Integer> depIdList, @NotNull Integer groupId) {
        return this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getGroupId, (Object)groupId)).in(Devices::getDepId, depIdList));
    }

    @Override
    public List<Integer> getDepIdListByDeviceName(String deviceName, Integer groupId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List devices = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getGroupId, (Object)groupId)).isNotNull(Devices::getDepId)).like(Devices::getName, (Object)("%" + deviceName + "%"))).groupBy(Devices::getDepId)).select(new SFunction[]{Devices::getDepId}));
        for (Devices item : devices) {
            result.add(item.getDepId());
        }
        return result;
    }

    @Override
    public Devices getDeviceById(Integer deviceId) {
        return (Devices)this.devicesMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getId, (Object)deviceId));
    }

    @Override
    public void insert(Devices devices) {
        this.devicesMapper.insert(devices);
    }

    @Override
    public void updateDelFlagByDeviceInfoId(Integer deviceStatusId, Integer delFlag) {
        this.devicesMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(Devices::getDeviceinfoId, (Object)deviceStatusId)).set(Devices::getIsDelete, (Object)delFlag));
    }

    @Override
    public Long getGroupDeviceNum(Integer groupId) {
        Long num = this.devicesMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getGroupId, (Object)groupId)).isNotNull(Devices::getDepId)).select(new SFunction[]{Devices::getId}));
        return num;
    }

    @Override
    public void deviceEnterpriseMigration(Integer sourceEnterpriseId, Integer targetEnterpriseId, Integer userId) {
        int update = this.devicesMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(Devices::getGroupId, (Object)targetEnterpriseId)).eq(Devices::getGroupId, (Object)sourceEnterpriseId));
        log.info("devicesMapper deviceEnterpriseMigration sourceEnterpriseId:{} targetEnterpriseId:{} numm:{}", new Object[]{sourceEnterpriseId, targetEnterpriseId, update});
    }

    @Override
    public Map<Integer, String> getDepDeviceAndMacMap(@NotNull Integer depId, @NotNull List<Integer> deviceIdList) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(deviceIdList.size());
        List devices = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Devices::getIsDelete, (Object)0)).eq(Devices::getDepId, (Object)depId)).in(Devices::getId, deviceIdList));
        if (CollectionUtils.isEmpty((Collection)devices)) {
            return result;
        }
        List<DeviceStatus> deviceStatusList = this.deviceStatusService.listDevice(depId);
        if (CollectionUtils.isEmpty(deviceStatusList)) {
            return result;
        }
        HashMap<Integer, String> deviceInfoIdAndMacMap = new HashMap<Integer, String>(deviceStatusList.size());
        for (DeviceStatus deviceStatus : deviceStatusList) {
            deviceInfoIdAndMacMap.put(deviceStatus.getId(), deviceStatus.getMac());
        }
        for (Devices item : devices) {
            Integer id = item.getId();
            Integer deviceinfoId = item.getDeviceinfoId();
            String mac = (String)deviceInfoIdAndMacMap.get(deviceinfoId);
            if (!StringUtils.isNotEmpty((CharSequence)mac)) continue;
            result.put(id, mac);
        }
        return result;
    }
}

