/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ovopark.device.modules.platform.DeviceOfflineDetailService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceOfflineDetail;
import com.ovopark.device.modules.platform.mysql.DeviceOfflineDetailMapper;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DeviceOfflineDetailServiceImpl
implements DeviceOfflineDetailService {
    @Resource
    private DeviceOfflineDetailMapper deviceOfflineDetailMapper;
    @Resource
    private DeviceStatusService deviceStatusService;

    @Override
    public void addLog(String mac, Long onlineTimestamp, Long offlineTimestamp, String offlineType, Long offlineSecond) {
        DeviceStatus deviceStatus = this.deviceStatusService.getMainDevice(mac, 0);
        if (deviceStatus == null) {
            return;
        }
        DeviceOfflineDetail deviceOfflineDetail = new DeviceOfflineDetail();
        deviceOfflineDetail.setOnlineTimestamp(onlineTimestamp);
        deviceOfflineDetail.setOfflineTimestamp(offlineTimestamp);
        deviceOfflineDetail.setOfflineSecond(offlineSecond);
        deviceOfflineDetail.setOfflineType(offlineType);
        deviceOfflineDetail.setMac(mac);
        deviceOfflineDetail.setDeviceStatusId(deviceStatus.getId());
        deviceOfflineDetail.setDepId(deviceStatus.getDepId());
        deviceOfflineDetail.setGroupId(deviceStatus.getGroupId());
        deviceOfflineDetail.setCreateTime(LocalDateTime.now());
        this.deviceOfflineDetailMapper.insert(deviceOfflineDetail);
    }

    @Override
    public List<DeviceOfflineDetail> getDeviceOfflineDetailList(List<Integer> deviceStatusIds, List<Integer> depIds, Integer groupId, LocalDateTime offlineStartTime, LocalDateTime offlineEndTime, List<String> offlineTypeList, Long minOfflineSecond, Long maxOfflineSecond, Long pageNum, Long pageSize) {
        if (CollectionUtils.isNotEmpty(offlineTypeList)) {
            offlineTypeList = offlineTypeList.stream().filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        String offlineType = null;
        if (CollectionUtils.isNotEmpty(offlineTypeList) && offlineTypeList.size() == 1) {
            offlineType = offlineTypeList.getFirst();
            offlineTypeList.clear();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(CollectionUtils.isNotEmpty(deviceStatusIds), DeviceOfflineDetail::getDeviceStatusId, deviceStatusIds)).in(CollectionUtils.isNotEmpty(depIds), DeviceOfflineDetail::getDepId, depIds)).eq(groupId != null, DeviceOfflineDetail::getGroupId, (Object)groupId)).ge(offlineStartTime != null, DeviceOfflineDetail::getOfflineTimestamp, offlineStartTime == null ? null : Long.valueOf(offlineStartTime.toEpochSecond(ZoneOffset.UTC)))).le(offlineEndTime != null, DeviceOfflineDetail::getOfflineTimestamp, offlineEndTime == null ? null : Long.valueOf(offlineEndTime.toEpochSecond(ZoneOffset.UTC)))).in(CollectionUtils.isNotEmpty(offlineTypeList), DeviceOfflineDetail::getOfflineType, offlineTypeList)).ge(minOfflineSecond != null, DeviceOfflineDetail::getOfflineSecond, (Object)minOfflineSecond)).le(maxOfflineSecond != null, DeviceOfflineDetail::getOfflineSecond, (Object)maxOfflineSecond)).eq(StringUtils.isNotEmpty((CharSequence)offlineType), DeviceOfflineDetail::getOfflineType, (Object)offlineType)).in(CollectionUtils.isNotEmpty(offlineTypeList), DeviceOfflineDetail::getOfflineType, offlineTypeList)).orderByDesc(DeviceOfflineDetail::getId);
        if (pageNum != null && pageSize != null) {
            queryWrapper.last("LIMIT " + (pageNum - 1L) * pageSize + ", " + pageSize);
        }
        return this.deviceOfflineDetailMapper.selectList((Wrapper)queryWrapper);
    }
}

