/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform.config;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.jdk21.JakartaServletRequest;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthenticationInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    @Autowired
    private SessionClient sessionClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        if (request.getRequestURL().toString().contains("/feign/log") || request.getRequestURL().toString().contains("/feign/device-log/") || request.getRequestURL().toString().contains("/error") || request.getRequestURL().toString().contains("/k8s/health") || request.getRequestURL().toString().contains("/k8s/shutdown") || request.getRequestURL().toString().contains("/test/messageType/import") || request.getRequestURL().toString().contains("/feign/messagehub-job/processing/submit") || request.getRequestURL().toString().contains("/feign/iohub-job/processing") || request.getRequestURL().toString().contains("/videoRecordReport/delVideoRecordByGroupId") || !this.authorizeOnPath(request) || request.getRequestURL().toString().contains("/feign/occupancy/listenerOccupancyPeopleNum") || request.getRequestURL().toString().contains("/feign/occupancy/regionalPlan")) {
            return true;
        }
        try {
            Session session = this.sessionClient.session((SharedRequest)new JakartaServletRequest(request));
            if (session != null) {
                Session.getOrCreate().set(session);
                return true;
            }
            response.setContentType("application/json;charset=utf-8");
            response.getWriter().append(JSONAccessor.impl().format((Object)BaseResult.invalidToken()));
            return false;
        }
        catch (Exception e) {
            log.error("AuthenticationInterceptor error:", (Throwable)e);
            response.setContentType("application/json;charset=utf-8");
            response.getWriter().append(JSONAccessor.impl().format((Object)BaseResult.invalidToken()));
            return false;
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Session.getOrCreate().remove();
    }

    protected boolean authorizeOnPath(HttpServletRequest request) {
        return true;
    }
}

