/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform.config;

import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
public class RedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisConfiguration.class);
    @Value(value="${redis.timeout}")
    private int timeout;
    @Value(value="${redis.pool.max-active}")
    private int maxActive;
    @Value(value="${redis.pool.max-idle}")
    private int maxIdle;
    @Value(value="${redis.pool.min-idle}")
    private int minIdle;
    @Value(value="${redis.pool.max-wait}")
    private int maxWait;
    @Value(value="${redis.shopweb.host}")
    private String shopWebHost;
    @Value(value="${redis.shopweb.port}")
    private int shopWebPort;
    @Value(value="${redis.shopweb.password}")
    private String shopWebPassword;
    @Value(value="${redis.shopweb.database}")
    private int shopWebDatabase;
    @Value(value="${redis.device.host}")
    private String deviceHost;
    @Value(value="${redis.device.port}")
    private int devicePort;
    @Value(value="${redis.device.password}")
    private String devicePassword;
    @Value(value="${redis.device.database}")
    private int deviceDatabase;
    @Value(value="${redis.dms.host}")
    private String dmsHost;
    @Value(value="${redis.dms.port}")
    private int dmsPort;
    @Value(value="${redis.dms.password:#{null}}")
    private String dmsPassword;
    @Value(value="${redis.dms.database.kd}")
    private int dmsKdDatabase;
    @Value(value="${redis.dms.database.dms}")
    private int dmsDmsDatabase;
    @Value(value="${redis.dms.database.gb}")
    private int dmsGbDatabase;
    @Value(value="${redis.dms.database.wifi:7}")
    private int dmsWifiDmsDatabase;
    @Value(value="${redis.dms.database.gbCascade}")
    private int dmsGbCascadeDatabase;

    @Bean
    public GenericObjectPoolConfig getPoolConfig() {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(this.maxActive);
        poolConfig.setMaxIdle(this.maxIdle);
        poolConfig.setMinIdle(this.minIdle);
        poolConfig.setMaxWaitMillis((long)this.maxWait);
        return poolConfig;
    }

    @Bean(name={"shopwebStringRedisTemplate"})
    public StringRedisTemplate getShopwebRedisTemplate() {
        return this.getStringRedisTemplate(this.shopWebHost, this.shopWebPort, this.shopWebPassword, this.shopWebDatabase);
    }

    @Bean(name={"deviceStringRedisTemplate"})
    public StringRedisTemplate getDeviceRedisTemplate() {
        return this.getStringRedisTemplate(this.deviceHost, this.devicePort, this.devicePassword, this.deviceDatabase);
    }

    @Bean(name={"dmsDmsStringRedisTemplate"})
    public StringRedisTemplate getDmsDmsStringRedisTemplate() {
        return this.getStringRedisTemplate(this.dmsHost, this.dmsPort, this.dmsPassword, this.dmsDmsDatabase);
    }

    @Bean(name={"dmsWifiStringRedisTemplate"})
    public StringRedisTemplate getDmsWifiStringRedisTemplate() {
        log.info("dmsWifiStringRedisTemplate inint {}   {}  {}  {}", new Object[]{this.dmsHost, this.dmsPort, this.dmsPassword, this.dmsWifiDmsDatabase});
        return this.getStringRedisTemplate(this.dmsHost, this.dmsPort, this.dmsPassword, this.dmsWifiDmsDatabase);
    }

    @Bean(name={"dmsKdStringRedisTemplate"})
    public StringRedisTemplate getDmsKdRedisTemplate() {
        return this.getStringRedisTemplate(this.dmsHost, this.dmsPort, this.dmsPassword, this.dmsKdDatabase);
    }

    @Bean(name={"dmsGbStringRedisTemplate"})
    public StringRedisTemplate getDmsGbRedisTemplate() {
        return this.getStringRedisTemplate(this.dmsHost, this.dmsPort, this.dmsPassword, this.dmsGbDatabase);
    }

    @Bean(name={"dmsGbCascadeStringRedisTemplate"})
    public StringRedisTemplate getDmsGbCascadeRedisTemplate() {
        return this.getStringRedisTemplate(this.dmsHost, this.dmsPort, this.dmsPassword, this.dmsGbCascadeDatabase);
    }

    private StringRedisTemplate getStringRedisTemplate(String host, Integer port, String password, Integer database) {
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration();
        configuration.setHostName(host);
        configuration.setPort(port.intValue());
        configuration.setPassword(RedisPassword.of((String)password));
        LettucePoolingClientConfiguration clientConfiguration = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofSeconds(this.timeout)).poolConfig(this.getPoolConfig()).build();
        LettuceConnectionFactory factory = new LettuceConnectionFactory(configuration, (LettuceClientConfiguration)clientConfiguration);
        factory.setDatabase(database.intValue());
        factory.afterPropertiesSet();
        return new StringRedisTemplate((RedisConnectionFactory)factory);
    }
}

