/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform.oss;

import com.ovopark.device.modules.platform.oss.OssUploadResult;
import com.ovopark.kernel.shared.JSONAccessor;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class OSSService {
    private static final Logger log = LoggerFactory.getLogger(OSSService.class);
    @Autowired
    private RestTemplate restTemplate;

    public String upload(String ossUploadUrl, File file, String customFilePath, String customFileName) {
        String url = ossUploadUrl;
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"multipart/form-data");
        headers.setContentType(type);
        headers.add("storageType", "aliyun");
        headers.add("moduleId", "1");
        headers.add("isDate", "true");
        FileSystemResource fileSystemResource = new FileSystemResource(file);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"file", (Object)fileSystemResource);
        form.add((Object)"customFilePath", (Object)customFilePath);
        form.add((Object)"customFileName", (Object)customFileName);
        HttpEntity files = new HttpEntity((Object)form, (MultiValueMap)headers);
        try {
            String resultStr = (String)this.restTemplate.postForObject(url, (Object)files, String.class, new Object[0]);
            log.info(resultStr);
            OssUploadResult resultJson = (OssUploadResult)JSONAccessor.impl().read(resultStr, OssUploadResult.class);
            if (resultJson != null && !resultJson.isError() && resultJson.getData() != null) {
                return resultJson.getData().getOssUrl();
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

