/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.ovopark.device.common.util.DateUtils;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.modules.model.vo.DeviceAbilityVo;
import com.ovopark.device.modules.model.vo.DeviceStatusForAppVo;
import com.ovopark.device.modules.platform.DeviceNewService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.PlatformsService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.platform.mysql.PlatformsMapper;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.UserDepartmentPrivilegeFacade;
import com.ovopark.device.platform.api.UserRoleFacade;
import com.ovopark.device.platform.api.UsersFacade;
import com.ovopark.device.platform.api.model.ChildDeviceAddMo;
import com.ovopark.device.platform.utils.SmartDataQueryUtil;
import com.ovopark.device.sdk.common.model.vo.AiMainDeviceVo;
import com.ovopark.device.sdk.common.model.vo.YzsDeviceFeignVo;
import com.ovopark.device.signalling.model.request.GetStorageInfoParamsReq;
import com.ovopark.device.signalling.model.response.GetStorageInfoParamsRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import com.ovopark.device.signalling.util.AbilityUtil;
import com.ovopark.device.signalling.util.DiskUtil;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.dms.DmsStatusRes;
import com.ovopark.device.thirdparty.ovoIot.service.DmsProxyService;
import com.ovopark.kernel.shared.Util;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.privilege.pojo.UsersPojo;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceStatusServiceImpl
implements DeviceStatusService {
    private static final Logger log = LoggerFactory.getLogger(DeviceStatusServiceImpl.class);
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    private PlatformsMapper platformsMapper;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Resource
    private UsersFacade usersFacade;
    @Resource
    private UserRoleFacade userRoleFacade;
    @Resource
    private UserDepartmentPrivilegeFacade userDepartmentPrivilegeFacade;
    @Resource
    private DeviceNewService deviceNewService;
    @Autowired
    private OnlineFacade onlineFacadeRPC;
    @Autowired
    private DmsProxyService dmsProxyService;
    @Resource
    private PlatformsService platformsService;

    @Override
    public List<DeviceStatus> listDevice(@NotNull Integer deptId) {
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).eq(DeviceStatus::getDepId, (Object)deptId)).eq(DeviceStatus::getIsDelete, (Object)0));
        return deviceStatusList;
    }

    @Override
    public DeviceStatus getById(@NotNull Integer id) {
        return (DeviceStatus)this.deviceStatusMapper.selectById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DeviceStatus> getDeviceStatusListByIdsAsync(List<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        int batchSize = 1000;
        int maxConcurrency = 5;
        int threadPoolSize = Math.min(maxConcurrency, (ids.size() + batchSize - 1) / batchSize);
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);
        ArrayList<CompletableFuture<List>> futures = new ArrayList<CompletableFuture<List>>();
        try {
            for (int i = 0; i < ids.size(); i += batchSize) {
                int endIndex = Math.min(i + batchSize, ids.size());
                List<Integer> list = ids.subList(i, endIndex);
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        return this.deviceStatusMapper.selectList((Wrapper)new LambdaQueryWrapper().in(DeviceStatus::getId, (Collection)batchIds));
                    }
                    catch (Exception e) {
                        log.error("Failed to batch query device status, batch: {}", (Object)batchIds, (Object)e);
                        return new ArrayList();
                    }
                }, executor);
                futures.add(future);
            }
            ArrayList result = new ArrayList();
            for (CompletableFuture completableFuture : futures) {
                try {
                    List batchResult = (List)completableFuture.get(30L, TimeUnit.SECONDS);
                    result.addAll(batchResult);
                }
                catch (TimeoutException e) {
                    log.error("Query timeout", (Throwable)e);
                    completableFuture.cancel(true);
                }
                catch (Exception e) {
                    log.error("Failed to get query result", (Throwable)e);
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public List<DeviceStatus> getDeviceStatusListByIds(List<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        if (ids.size() <= 5000) {
            return this.getDeviceStatusListByIdsSync(ids);
        }
        return this.getDeviceStatusListByIdsAsync(ids);
    }

    private List<DeviceStatus> getDeviceStatusListByIdsSync(List<Integer> ids) {
        ArrayList<DeviceStatus> result = new ArrayList<DeviceStatus>();
        int batchSize = 1000;
        for (int i = 0; i < ids.size(); i += batchSize) {
            int endIndex = Math.min(i + batchSize, ids.size());
            List<Integer> batchIds = ids.subList(i, endIndex);
            try {
                List batchResult = this.deviceStatusMapper.selectList((Wrapper)new LambdaQueryWrapper().in(DeviceStatus::getId, batchIds));
                result.addAll(batchResult);
                if (i + batchSize >= ids.size()) continue;
                Thread.sleep(10L);
                continue;
            }
            catch (Exception e) {
                log.error("Failed to batch query device status, batch: {}", batchIds, (Object)e);
            }
        }
        return result;
    }

    @Override
    public Map<Integer, String> getUserDepNameMap(Integer userId, Integer enterpriseId, String organizeId) {
        HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setUserId(userId);
        mo.setUserGroupId(enterpriseId);
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            mo.setOrganizeIdList(Arrays.asList(split));
        }
        mo.setIsDel(Integer.valueOf(0));
        Map<Integer, DepartmentOrgMo> userDepNameMapNew = this.getUserDepNameMapNew(mo);
        for (Integer depId : userDepNameMapNew.keySet()) {
            DepartmentOrgMo departmentOrgMo = userDepNameMapNew.get(depId);
            if (departmentOrgMo == null) continue;
            nameMap.put(depId, departmentOrgMo.getName());
        }
        return nameMap;
    }

    private Map<Integer, DepartmentOrgMo> getUserDepNameMapNew(DepIdsAndUserMo mo) {
        HashMap<Integer, DepartmentOrgMo> result = new HashMap<Integer, DepartmentOrgMo>();
        try {
            BaseResult userPrivilegeDepByOrganizeIds = this.userDepPrivilegeApi.getUserPrivilegeDepByOrganizeIds(mo);
            List data = (List)userPrivilegeDepByOrganizeIds.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (DepartmentOrgMo item : data) {
                    result.put(item.getDepId(), item);
                }
            }
        }
        catch (Exception e) {
            log.error(LogUtil.getStackTraceInfo((Exception)e));
        }
        return result;
    }

    @Override
    public List<DeviceStatus> getUserDeviceStatus(Integer userId, Integer groupId, List<Integer> deptIds) {
        return this.getUserDeviceStatus(userId, groupId, deptIds, null, null);
    }

    @Override
    public List<DeviceStatus> getUserDeviceStatus(Integer userId, Integer groupId, List<Integer> deptIds, List<String> deviceTypeList, List<Integer> excludeDtypeList) {
        return this.getUserDeviceStatus(userId, groupId, deptIds, deviceTypeList, excludeDtypeList, null);
    }

    @Override
    public List<DeviceStatus> getUserDeviceStatus(Integer userId, Integer groupId, List<Integer> deptIds, List<String> deviceTypeList, List<Integer> excludeDtypeList, List<Integer> dtypeList) {
        long start = System.currentTimeMillis();
        List<DeviceStatus> result1 = new ArrayList<DeviceStatus>();
        if (groupId == null) {
            return result1;
        }
        UsersPojo users = this.usersFacade.getUsersById(userId);
        Boolean supureFlag = false;
        if (this.userRoleFacade.isSystemAdmin(userId, null).booleanValue() || users.getIsAgency() == 2) {
            supureFlag = true;
        }
        if (!supureFlag.booleanValue()) {
            supureFlag = this.userRoleFacade.isSuperAdmin(userId, groupId);
        }
        if (supureFlag.booleanValue()) {
            result1 = deptIds != null && !deptIds.isEmpty() ? SmartDataQueryUtil.executeSmartQuery(deptIds, deptIdPartition -> this.queryDeviceStatusByDeptIds(groupId, (List<Integer>)deptIdPartition, deviceTypeList, excludeDtypeList, dtypeList), (String)"\u8d85\u7ea7\u7ba1\u7406\u5458\u8bbe\u5907\u72b6\u6001\u67e5\u8be2") : this.queryDeviceStatusByDeptIds(groupId, null, deviceTypeList, excludeDtypeList, dtypeList);
        } else {
            List userDepIds = this.userDepartmentPrivilegeFacade.getUserDepIds(userId, groupId);
            if (CollectionUtils.isNotEmpty((Collection)userDepIds)) {
                userDepIds.retainAll(deptIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)userDepIds)) {
                result1 = SmartDataQueryUtil.executeSmartQuery((List)userDepIds, deptIdPartition -> this.queryDeviceStatusByDeptIds(groupId, (List<Integer>)deptIdPartition, deviceTypeList, excludeDtypeList, dtypeList), (String)"\u666e\u901a\u7528\u6237\u8bbe\u5907\u72b6\u6001\u67e5\u8be2");
            }
        }
        long end = System.currentTimeMillis();
        log.info("\u8fd0\u884c\u65f6\u95f4\uff1a{},groupId:{},\u53c2\u6570deptList.size:{}", new Object[]{end - start, groupId, deptIds == null ? 0 : deptIds.size()});
        return result1;
    }

    private List<DeviceStatus> queryDeviceStatusByDeptIds(Integer groupId, List<Integer> deptIds, List<String> deviceTypeList, List<Integer> excludeDtypeList, List<Integer> dtypeList) {
        LambdaQueryWrapper deviceStatusLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)deviceStatusLambdaQueryWrapper.eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getGroupId, (Object)groupId);
        if (CollectionUtils.isNotEmpty(deptIds)) {
            deviceStatusLambdaQueryWrapper.in(DeviceStatus::getDepId, deptIds);
        }
        if (CollectionUtils.isNotEmpty(deviceTypeList)) {
            deviceStatusLambdaQueryWrapper.in(DeviceStatus::getDeviceType, deviceTypeList);
        }
        if (CollectionUtils.isNotEmpty(excludeDtypeList)) {
            deviceStatusLambdaQueryWrapper.notIn(DeviceStatus::getDType, excludeDtypeList);
        }
        if (CollectionUtils.isNotEmpty(dtypeList)) {
            deviceStatusLambdaQueryWrapper.in(DeviceStatus::getDType, dtypeList);
        }
        deviceStatusLambdaQueryWrapper.orderByAsc(DeviceStatus::getDepId);
        return this.deviceStatusMapper.selectList((Wrapper)deviceStatusLambdaQueryWrapper);
    }

    @Override
    public List<DeviceStatus> getDeviceStatusList(Integer groupId, List<Integer> deptIds, List<Integer> exitDeptList, List<String> deviceTypeList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (groupId != null) {
            queryWrapper.eq(DeviceStatus::getGroupId, (Object)groupId);
        }
        if (CollectionUtils.isNotEmpty(deptIds) && CollectionUtils.isNotEmpty(exitDeptList)) {
            if (deptIds.size() >= exitDeptList.size()) {
                queryWrapper.in(DeviceStatus::getDepId, deptIds);
            } else {
                queryWrapper.notIn(DeviceStatus::getDepId, exitDeptList);
            }
        } else {
            if (CollectionUtils.isNotEmpty(deptIds)) {
                queryWrapper.in(DeviceStatus::getDepId, deptIds);
            }
            if (CollectionUtils.isNotEmpty(exitDeptList)) {
                queryWrapper.notIn(DeviceStatus::getDepId, exitDeptList);
            }
        }
        if (CollectionUtils.isNotEmpty(deviceTypeList)) {
            queryWrapper.in(DeviceStatus::getDeviceType, deviceTypeList);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getIsDelete, (Object)0)).orderByAsc(DeviceStatus::getDepId);
        return this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DeviceStatus> getDeviceList(@NotNull String thirdpartDevId, @NotNull Integer channelId, @NotNull Integer dtype, Integer delFlag) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getThirdpartDevId, (Object)thirdpartDevId)).eq(DeviceStatus::getChannelId, (Object)channelId)).eq(DeviceStatus::getDType, (Object)dtype)).eq(delFlag != null, DeviceStatus::getIsDelete, (Object)delFlag);
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
        return deviceStatusList;
    }

    @Override
    public void insert(DeviceStatus deviceStatus) {
        this.deviceStatusMapper.insert(deviceStatus);
    }

    @Override
    public void updateDelFlagById(Integer deviceStatusId, Integer delFlag) {
        this.deviceStatusMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(DeviceStatus::getId, (Object)deviceStatusId)).set(DeviceStatus::getIsDelete, (Object)delFlag));
    }

    @Override
    public List<YzsDeviceFeignVo> getDeviceStatusListByDepIdForYzs(Integer depId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getDepId, (Object)depId)).eq(DeviceStatus::getIsDelete, (Object)0);
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
        List<Devices> deviceList = this.deviceNewService.getDeviceList(depId);
        HashMap<Integer, Devices> deviceStatusIdAndDeviceIdMap = new HashMap<Integer, Devices>(deviceList.size());
        for (Devices item : deviceList) {
            Integer deviceinfoId = item.getDeviceinfoId();
            if (deviceinfoId == null) continue;
            deviceStatusIdAndDeviceIdMap.put(deviceinfoId, item);
        }
        ArrayList<YzsDeviceFeignVo> result = new ArrayList<YzsDeviceFeignVo>();
        Boolean hasMainDevice = false;
        LocalDateTime hasMainDeviceRegTime = null;
        DeviceStatus mainDevice = null;
        Map onlineMap = this.onlineFacadeRPC.onOffRT(deviceStatusList.stream().map(DeviceStatus::getId).toList());
        Map dmsStatus = onlineMap == null ? new HashMap() : onlineMap;
        for (DeviceStatus item : deviceStatusList) {
            YzsDeviceFeignVo yzsDeviceFeignVo = new YzsDeviceFeignVo();
            Integer deviceStatusId = item.getId();
            Integer dType = item.getDType();
            Devices devices = (Devices)deviceStatusIdAndDeviceIdMap.get(deviceStatusId);
            yzsDeviceFeignVo.setDeviceStatusId(deviceStatusId);
            yzsDeviceFeignVo.setYzsMainIpc(Integer.valueOf(0));
            yzsDeviceFeignVo.setDeviceName(item.getDeviceName());
            yzsDeviceFeignVo.setDeviceType(item.getDeviceType());
            yzsDeviceFeignVo.setDtype(dType);
            yzsDeviceFeignVo.setOnline(dmsStatus.getOrDefault(deviceStatusId, 0));
            yzsDeviceFeignVo.setCreateTime(item.getCreateTime() == null ? "" : DateUtils.parseTime((LocalDateTime)item.getCreateTime(), (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_LINE));
            if (devices != null) {
                yzsDeviceFeignVo.setThumbUrl(devices.getThumbUrl());
                yzsDeviceFeignVo.setDeviceId(devices.getId());
                Integer mainIpc = devices.getMainIpc();
                if (mainIpc != null && mainIpc == 1) {
                    yzsDeviceFeignVo.setYzsMainIpc(Integer.valueOf(1));
                }
                yzsDeviceFeignVo.setIsCanptz(devices.getIsCanptz());
            }
            yzsDeviceFeignVo.setCanOutLine(Integer.valueOf(1));
            yzsDeviceFeignVo.setCanUpdateName(Integer.valueOf(1));
            yzsDeviceFeignVo.setPId(item.getPId());
            yzsDeviceFeignVo.setMac(item.getMac());
            yzsDeviceFeignVo.setChannelId(item.getChannelId());
            result.add(yzsDeviceFeignVo);
            if (dType != 20) continue;
            hasMainDevice = true;
            hasMainDeviceRegTime = item.getCreateTime();
            mainDevice = item;
        }
        if (hasMainDevice.booleanValue()) {
            DmsStatusRes.DataBean first;
            List data;
            ArrayList<Integer> audioOutputNums = new ArrayList<Integer>();
            ArrayList<Integer> doorNums = new ArrayList<Integer>();
            Integer platformId = mainDevice.getPlatformId();
            Platforms platforms = (Platforms)this.platformsMapper.selectById(platformId);
            DmsStatusRes mainDeviceStatus = this.dmsProxyService.getMainDeviceStatus(mainDevice.getMac(), platforms.getNewDmsFlag(), platforms.getUpgradeServer());
            if (mainDeviceStatus != null && CollectionUtils.isNotEmpty((Collection)(data = mainDeviceStatus.getData())) && (first = (DmsStatusRes.DataBean)data.getFirst()) != null) {
                List extendList;
                List audioOutputs = first.getAudioOutputs();
                if (CollectionUtils.isNotEmpty((Collection)audioOutputs)) {
                    for (DmsStatusRes.AudioOutput item : audioOutputs) {
                        audioOutputNums.add(item.getNumber());
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(extendList = first.getExtendList()))) {
                    for (DmsStatusRes.ExtendDto dto : extendList) {
                        List data1;
                        String type = dto.getType();
                        if (!StringUtils.equals((CharSequence)"door", (CharSequence)type) || !CollectionUtils.isNotEmpty((Collection)(data1 = dto.getData()))) continue;
                        for (DmsStatusRes.ExtendDataDto extendDataDto : data1) {
                            doorNums.add(extendDataDto.getId());
                        }
                    }
                }
            }
            this.addVirtualDevice(result, hasMainDeviceRegTime, audioOutputNums, doorNums, mainDevice.getOnline());
        }
        return result;
    }

    private void addVirtualDevice(List<YzsDeviceFeignVo> deviceFeignVos, LocalDateTime hasMainDeviceRegTime, List<Integer> audioOutputNums, List<Integer> doorNums, Integer manDeviceOnlineStatus) {
        YzsDeviceFeignVo yzsDeviceFeignVo;
        HashMap<String, Integer> deviceNameAndDtypeMap = new HashMap<String, Integer>();
        deviceNameAndDtypeMap.put("\u663e\u793a\u5668", 301);
        deviceNameAndDtypeMap.put("\u62fe\u97f3\u5668", 303);
        for (String item : deviceNameAndDtypeMap.keySet()) {
            yzsDeviceFeignVo = new YzsDeviceFeignVo();
            yzsDeviceFeignVo.setDeviceName(item);
            yzsDeviceFeignVo.setDtype((Integer)deviceNameAndDtypeMap.get(item));
            yzsDeviceFeignVo.setOnline(manDeviceOnlineStatus);
            yzsDeviceFeignVo.setCreateTime(DateUtils.parseTime((LocalDateTime)hasMainDeviceRegTime, (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_LINE));
            yzsDeviceFeignVo.setCanOutLine(Integer.valueOf(0));
            yzsDeviceFeignVo.setCanUpdateName(Integer.valueOf(0));
            yzsDeviceFeignVo.setYzsMainIpc(Integer.valueOf(0));
            deviceFeignVos.add(yzsDeviceFeignVo);
        }
        for (Integer numer : audioOutputNums) {
            yzsDeviceFeignVo = new YzsDeviceFeignVo();
            yzsDeviceFeignVo.setDeviceName("\u97f3\u54cd:" + numer);
            yzsDeviceFeignVo.setDtype(Integer.valueOf(304));
            yzsDeviceFeignVo.setOnline(manDeviceOnlineStatus);
            yzsDeviceFeignVo.setCreateTime(DateUtils.parseTime((LocalDateTime)hasMainDeviceRegTime, (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_LINE));
            yzsDeviceFeignVo.setCanOutLine(Integer.valueOf(0));
            yzsDeviceFeignVo.setCanUpdateName(Integer.valueOf(0));
            yzsDeviceFeignVo.setYzsMainIpc(Integer.valueOf(0));
            yzsDeviceFeignVo.setAudioOutputNumber(numer);
            yzsDeviceFeignVo.setIndex(numer);
            deviceFeignVos.add(yzsDeviceFeignVo);
        }
        for (Integer numer : doorNums) {
            yzsDeviceFeignVo = new YzsDeviceFeignVo();
            yzsDeviceFeignVo.setDeviceName("\u95e8\u7981:" + numer);
            yzsDeviceFeignVo.setDtype(Integer.valueOf(302));
            yzsDeviceFeignVo.setOnline(manDeviceOnlineStatus);
            yzsDeviceFeignVo.setCreateTime(DateUtils.parseTime((LocalDateTime)hasMainDeviceRegTime, (DateUtils.Format)DateUtils.Format.LONG_DATE_FORMAT_LINE));
            yzsDeviceFeignVo.setCanOutLine(Integer.valueOf(0));
            yzsDeviceFeignVo.setCanUpdateName(Integer.valueOf(0));
            yzsDeviceFeignVo.setYzsMainIpc(Integer.valueOf(0));
            yzsDeviceFeignVo.setIndex(numer);
            deviceFeignVos.add(yzsDeviceFeignVo);
        }
    }

    @Override
    public void updateDeviceName(String deviceName, Integer deviceStatusId, Integer userId) {
        log.info("update deviceName id {} name {} userId {}", new Object[]{deviceStatusId, deviceName, userId});
        this.deviceStatusMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(DeviceStatus::getId, (Object)deviceStatusId)).set(DeviceStatus::getDeviceName, (Object)deviceName));
        this.deviceNewService.updateDeviceName(deviceName, deviceStatusId);
    }

    @Override
    public DeviceStatus getMainDevice(String mac, Integer delFlag) {
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getMac, (Object)mac)).isNull(DeviceStatus::getPId)).eq(DeviceStatus::getIsDelete, (Object)delFlag));
        if (CollectionUtils.isNotEmpty((Collection)deviceStatusList)) {
            return (DeviceStatus)deviceStatusList.getFirst();
        }
        return null;
    }

    @Override
    public List<DeviceStatus> getMainDmsDeviceList(@NotNull Integer groupId, @NotNull List<Integer> deptIds, String mac, List<Integer> dtypeList) {
        return this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getGroupId, (Object)groupId)).eq(Util.isNotEmpty((CharSequence)mac), DeviceStatus::getMac, (Object)mac)).in(Util.isNotEmpty(dtypeList), DeviceStatus::getDType, dtypeList)).in(DeviceStatus::getDepId, deptIds));
    }

    @Override
    public Map<Integer, DeviceStatus> getDeviceStatusList(List<Integer> depIdList, String devicesName, List<Integer> dtypeList) {
        HashMap<Integer, DeviceStatus> result = new HashMap<Integer, DeviceStatus>();
        if (CollectionUtils.isNotEmpty(depIdList)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).in(DeviceStatus::getDepId, depIdList);
            if (Util.isNotEmpty((CharSequence)devicesName)) {
                queryWrapper.like(DeviceStatus::getDeviceName, (Object)("%" + devicesName + "%"));
            }
            if (CollectionUtils.isNotEmpty(dtypeList)) {
                queryWrapper.in(DeviceStatus::getDType, dtypeList);
            }
            queryWrapper.select(new SFunction[]{DeviceStatus::getId, DeviceStatus::getDeviceName, DeviceStatus::getDType, DeviceStatus::getMac});
            List deviceStatuses = this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)deviceStatuses)) {
                for (DeviceStatus item : deviceStatuses) {
                    result.put(item.getId(), item);
                }
            }
        }
        return result;
    }

    @Override
    public Long getGroupDeviceNum(Integer groupId) {
        Long num = this.deviceStatusMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getGroupId, (Object)groupId)).isNotNull(DeviceStatus::getDepId)).select(new SFunction[]{DeviceStatus::getId}));
        return num;
    }

    @Override
    public void deviceEnterpriseMigration(Integer sourceEnterpriseId, Integer targetEnterpriseId, Integer userId) {
        int update = this.deviceStatusMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(DeviceStatus::getGroupId, (Object)targetEnterpriseId)).eq(DeviceStatus::getGroupId, (Object)sourceEnterpriseId));
        log.info("deviceStatusMapper deviceEnterpriseMigration sourceEnterpriseId:{} targetEnterpriseId:{} numm:{}", new Object[]{sourceEnterpriseId, targetEnterpriseId, update});
    }

    @Override
    public List<DeviceStatus> getEnterpriseDeviceStatusList(Integer groupId, Integer delFlag) {
        return this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getGroupId, (Object)groupId)).eq(delFlag != null, DeviceStatus::getIsDelete, (Object)delFlag));
    }

    @Override
    public List<AiMainDeviceVo> getAiMainDeviceList(Integer userId, Integer groupId) {
        ArrayList<AiMainDeviceVo> result = new ArrayList<AiMainDeviceVo>();
        Map<Integer, String> userDepNameMap = this.getUserDepNameMap(userId, groupId, null);
        if (CollectionUtils.isEmpty(userDepNameMap)) {
            return result;
        }
        ArrayList<Integer> dtypeList = new ArrayList<Integer>();
        dtypeList.add(61);
        dtypeList.add(20);
        List<DeviceStatus> mainDmsDeviceList = this.getMainDmsDeviceList(groupId, new ArrayList<Integer>(userDepNameMap.keySet()), null, dtypeList);
        ArrayList<Integer> deviceStatusIdList = new ArrayList<Integer>();
        Iterator<DeviceStatus> iterator = mainDmsDeviceList.iterator();
        while (iterator.hasNext()) {
            DeviceStatus item = iterator.next();
            Integer dType = item.getDType();
            Integer id = item.getId();
            String extendCapacity = item.getExtendCapacity();
            Boolean supportedSetAlgoList = com.ovopark.device.thirdparty.ovoIot.util.AbilityUtil.supportSetAlgoList((Integer)dType, (String)extendCapacity);
            if (!supportedSetAlgoList.booleanValue()) {
                iterator.remove();
            }
            deviceStatusIdList.add(id);
        }
        if (CollectionUtils.isEmpty(deviceStatusIdList)) {
            return result;
        }
        Map onlineMap = this.onlineFacadeRPC.onOffRT(deviceStatusIdList);
        for (DeviceStatus item : mainDmsDeviceList) {
            Integer id = item.getId();
            AiMainDeviceVo vo = new AiMainDeviceVo();
            vo.setDeviceStatusId(id);
            vo.setMac(item.getMac());
            vo.setDtype(item.getDType());
            vo.setDeviceType(item.getDeviceType());
            vo.setOnline(onlineMap.getOrDefault(id, 0));
            Integer depId = item.getDepId();
            vo.setDepId(depId);
            vo.setDepName(userDepNameMap.get(depId));
            vo.setDeviceName(item.getDeviceName());
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<DeviceStatus> getDeviceListByName(@NotNull String name, @NotNull Integer groupId, List<Integer> depIds) {
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getGroupId, (Object)groupId)).in(DeviceStatus::getDepId, depIds)).like(DeviceStatus::getDeviceName, (Object)("%" + name + "%")));
        return deviceStatusList;
    }

    @Override
    public List<DeviceStatus> getDepDeviceList(Integer depId) {
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getDepId, (Object)depId));
        return deviceStatusList;
    }

    @Override
    public List<DeviceStatus> getDeviceStatusListByPid(@NotNull Integer deviceStatusId, @NotNull Integer delFlag, @NotNull Integer dtype) {
        return this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)delFlag)).eq(DeviceStatus::getPId, (Object)deviceStatusId)).eq(DeviceStatus::getDType, (Object)dtype));
    }

    @Override
    public void addChild(ChildDeviceAddMo childDeviceAddMo) {
        log.info("addChild Param:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)childDeviceAddMo));
        String childMac = childDeviceAddMo.getChildMac();
        Integer dtype = childDeviceAddMo.getDtype();
        String masterMac = childDeviceAddMo.getMainMac();
        String ip = childDeviceAddMo.getIp();
        String deviceType = childDeviceAddMo.getDeviceType();
        Integer channelId = childDeviceAddMo.getChannelId();
        if (channelId == null) {
            channelId = 0;
        }
        if (StringUtils.isEmpty((CharSequence)childMac) || StringUtils.isEmpty((CharSequence)masterMac)) {
            throw new CommonException(ExceptionEnum.PARAM_ERROR);
        }
        childMac = childMac.replace(":", "").replace("-", "").toLowerCase();
        DeviceStatus deviceStatusById = (DeviceStatus)this.deviceStatusMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getMac, (Object)masterMac)).eq(DeviceStatus::getIsDelete, (Object)0)).isNull(DeviceStatus::getPId));
        if (deviceStatusById == null || deviceStatusById.getIsDelete() == 1) {
            log.error("masterMac search null");
            throw new CommonException(ExceptionEnum.PARAM_ERROR);
        }
        Integer masterDevId = deviceStatusById.getId();
        Integer depId = deviceStatusById.getDepId();
        List<DeviceStatus> deviceStatusOldList = this.getDeviceStatusList(childMac, dtype, null);
        DeviceStatus child = null;
        if (CollectionUtils.isNotEmpty(deviceStatusOldList)) {
            for (DeviceStatus item : deviceStatusOldList) {
                Integer isDelete = item.getIsDelete();
                Integer devDepId = item.getDepId();
                if (isDelete == 0) {
                    throw new CommonException(ExceptionEnum.DEVICE_REGISTERED);
                }
                if (!Objects.equals(devDepId, depId)) continue;
                item.setPId(masterDevId);
                child = item;
                break;
            }
        }
        if (child == null) {
            child = new DeviceStatus();
            child.setMac(childMac);
            child.setChannelId(channelId);
            child.setDeviceName(childMac);
            child.setCreateTime(LocalDateTime.now());
            child.setDType(dtype);
            child.setPId(masterDevId);
            child.setDeviceType(deviceType);
            child.setDepId(deviceStatusById.getDepId());
            child.setOnline(1);
            child.setGroupId(deviceStatusById.getGroupId());
            child.setIsDelete(0);
            child.setThirdpartType(dtype);
            child.setIsGbDevice(0);
            child.setDeviceIp(ip);
        } else {
            child.setMac(childMac);
            child.setChannelId(channelId);
            child.setDeviceName(childMac);
            child.setDType(dtype);
            child.setPId(masterDevId);
            child.setDepId(deviceStatusById.getDepId());
            child.setOnline(1);
            child.setDeviceType(deviceType);
            child.setGroupId(deviceStatusById.getGroupId());
            child.setIsDelete(0);
            child.setDeviceIp(ip);
            child.setThirdpartType(dtype);
            child.setIsGbDevice(0);
        }
        Integer childId = child.getId();
        if (childId == null) {
            this.deviceStatusMapper.insert(child);
        } else {
            this.deviceStatusMapper.updateById(child);
        }
    }

    @Override
    public List<DeviceStatus> getDeviceStatusList(Integer groupId, List<Integer> dtypeList) {
        LambdaQueryWrapper in = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getGroupId, (Object)groupId)).eq(DeviceStatus::getIsDelete, (Object)0)).in(DeviceStatus::getDType, dtypeList);
        return this.deviceStatusMapper.selectList((Wrapper)in);
    }

    public List<DeviceStatus> getDeviceStatusList(@NotNull String mac, @NotNull Integer dType, Integer delFlag) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceStatus::getMac, (Object)mac)).eq(DeviceStatus::getDType, (Object)dType);
        if (delFlag != null) {
            queryWrapper.eq(DeviceStatus::getIsDelete, (Object)delFlag);
        }
        return this.deviceStatusMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DeviceStatusForAppVo> getDeviceStatusListForApp(Integer userId, Integer depId, Integer onlyVideoFlag, Integer needSDStorageInfoFlag) {
        ArrayList<DeviceStatusForAppVo> result = new ArrayList<DeviceStatusForAppVo>();
        List<DeviceStatus> depDeviceList = this.getDepDeviceList(depId);
        if (CollectionUtils.isEmpty(depDeviceList)) {
            return result;
        }
        List<Devices> deviceList = this.deviceNewService.getDeviceList(depId);
        HashMap deviceInfoIdAndDevicesMap = new HashMap();
        if (CollectionUtils.isNotEmpty(deviceList)) {
            for (Devices item : deviceList) {
                Integer deviceinfoId = item.getDeviceinfoId();
                if (deviceinfoId == null) continue;
                deviceInfoIdAndDevicesMap.put(deviceinfoId, item);
            }
        }
        Map onlineMap = this.onlineFacadeRPC.onOffRT(depDeviceList.stream().map(DeviceStatus::getId).toList());
        HashMap<Integer, ArrayList<DeviceStatusForAppVo>> pidAndChildListMap = new HashMap<Integer, ArrayList<DeviceStatusForAppVo>>();
        for (DeviceStatus deviceStatus : depDeviceList) {
            Integer deviceInfoId = deviceStatus.getId();
            deviceStatus.setOnline(onlineMap.getOrDefault(deviceInfoId, 0));
            DeviceStatusForAppVo vo = new DeviceStatusForAppVo();
            vo.setDeviceStatusId(deviceInfoId);
            Devices devices = (Devices)deviceInfoIdAndDevicesMap.get(deviceInfoId);
            if (devices != null) {
                vo.setDeviceId(devices.getId());
                vo.setThumbUrl(devices.getThumbUrl());
                vo.setPtzEnable(devices.getIsCanptz());
                if (vo.getPtzEnable() == null) {
                    vo.setPtzEnable(1);
                }
            }
            vo.setName(deviceStatus.getDeviceName());
            vo.setOnline(deviceStatus.getOnline());
            vo.setDeviceType(deviceStatus.getDeviceType());
            vo.setDtype(deviceStatus.getDType());
            vo.setChannelId(deviceStatus.getChannelId());
            String mac = deviceStatus.getMac();
            if (StringUtils.isNotEmpty((CharSequence)deviceStatus.getDeviceCode())) {
                mac = deviceStatus.getDeviceCode();
            }
            if (StringUtils.isNotEmpty((CharSequence)deviceStatus.getThirdpartDevId())) {
                mac = deviceStatus.getThirdpartDevId();
            }
            Integer pId = deviceStatus.getPId();
            vo.setMac(mac);
            if (pId != null && deviceStatus.getDType() != 56) {
                ArrayList<DeviceStatusForAppVo> deviceStatusForAppVos = (ArrayList<DeviceStatusForAppVo>)pidAndChildListMap.get(pId);
                if (CollectionUtils.isEmpty((Collection)deviceStatusForAppVos)) {
                    deviceStatusForAppVos = new ArrayList<DeviceStatusForAppVo>();
                }
                deviceStatusForAppVos.add(vo);
                pidAndChildListMap.put(pId, deviceStatusForAppVos);
                continue;
            }
            result.add(vo);
        }
        for (DeviceStatusForAppVo deviceStatusForAppVo : result) {
            Integer deviceStatusId = deviceStatusForAppVo.getDeviceStatusId();
            List deviceStatusForAppVos = (List)pidAndChildListMap.get(deviceStatusId);
            deviceStatusForAppVo.setChildList(deviceStatusForAppVos);
        }
        if (onlyVideoFlag != null && onlyVideoFlag == 1) {
            ArrayList<DeviceStatusForAppVo> newResult = new ArrayList<DeviceStatusForAppVo>();
            for (DeviceStatusForAppVo item : result) {
                List<DeviceStatusForAppVo> childList;
                Integer deviceId = item.getDeviceId();
                if (deviceId != null) {
                    newResult.add(item);
                }
                if (!CollectionUtils.isNotEmpty(childList = item.getChildList())) continue;
                for (DeviceStatusForAppVo child : childList) {
                    Integer childDeviceId = child.getDeviceId();
                    if (childDeviceId == null) continue;
                    newResult.add(child);
                }
            }
            return newResult;
        }
        if (needSDStorageInfoFlag != null && needSDStorageInfoFlag == 1) {
            Map<Integer, GetStorageInfoParamsRes> sdStorageInfoMap = this.getSDStorageInfoMap(depDeviceList);
            for (DeviceStatusForAppVo vo : result) {
                GetStorageInfoParamsRes getStorageInfoParamsRes = sdStorageInfoMap.get(vo.getDeviceStatusId());
                if (getStorageInfoParamsRes == null) continue;
                vo.setStorageInfo(getStorageInfoParamsRes);
            }
        }
        return result;
    }

    @Override
    public DeviceAbilityVo getDeviceAbility(Integer deviceId) {
        DeviceAbilityVo vo = new DeviceAbilityVo();
        vo.setSupportHalfSpeed(0);
        Devices deviceById = this.deviceNewService.getDeviceById(deviceId);
        if (deviceById == null || deviceById.getIsDelete() == 1) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        Integer deviceinfoId = deviceById.getDeviceinfoId();
        if (deviceinfoId != null) {
            DeviceStatus ipc;
            DeviceStatus nvr = ipc = this.getById(deviceinfoId);
            if (ipc != null) {
                Integer pId = ipc.getPId();
                if (pId != null) {
                    nvr = this.getById(pId);
                }
                if (nvr != null && AbilityUtil.supportOneHalfTimesSpeed((Integer)nvr.getDType(), (String)nvr.getExtendCapacity())) {
                    vo.setSupportHalfSpeed(1);
                }
            }
        }
        return vo;
    }

    @Override
    public List<DeviceStatus> getEnterpriseDeviceStatusList(@NotNull Integer groupId, Integer delFlag, List<Integer> dtypeList, Integer pageNum, Integer pageSize) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue(), false);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DeviceStatus::getGroupId, (Object)groupId);
        queryWrapper.eq(delFlag != null, DeviceStatus::getIsDelete, (Object)delFlag);
        queryWrapper.in(CollectionUtils.isNotEmpty(dtypeList), DeviceStatus::getDType, dtypeList);
        Page deviceStatusPage = (Page)this.deviceStatusMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return deviceStatusPage.getRecords();
    }

    private Map<Integer, GetStorageInfoParamsRes> getSDStorageInfoMap(List<DeviceStatus> list) {
        HashMap<Integer, GetStorageInfoParamsRes> map = new HashMap<Integer, GetStorageInfoParamsRes>();
        ArrayList<DeviceStatus> o3psList = new ArrayList<DeviceStatus>();
        for (DeviceStatus deviceStatus : list) {
            Integer dType = deviceStatus.getDType();
            if (dType != 22) continue;
            o3psList.add(deviceStatus);
        }
        String requestId = MDC.get((String)"requestId");
        Map contextMap = MDC.getCopyOfContextMap();
        int maxConcurrent = Math.min(o3psList.size(), 20);
        Semaphore semaphore = new Semaphore(maxConcurrent);
        ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
        ArrayList futures = new ArrayList();
        for (DeviceStatus deviceStatus : o3psList) {
            futures.add(executor.submit(() -> {
                MDC.setContextMap((Map)contextMap);
                boolean acquired = false;
                try {
                    semaphore.acquire();
                    acquired = true;
                    Integer platformId = o3ps.getPlatformId();
                    if (platformId == null) {
                        throw new CommonException(ExceptionEnum.PLATFORM_IS_NULL);
                    }
                    Platforms platforms = this.platformsService.getPlatformsById(platformId);
                    if (platforms == null) {
                        throw new CommonException(ExceptionEnum.PLATFORM_NOT_EXIST);
                    }
                    String mac = o3ps.getMac();
                    GetStorageInfoParamsReq req = new GetStorageInfoParamsReq();
                    req.setChannelId(0);
                    req.setIpcmac(mac);
                    GetStorageInfoParamsRes storageInfo = DiskUtil.getStorageInfo((String)mac, (GetStorageInfoParamsReq)req, (String)platforms.getUpgradeServer(), (Integer)platforms.getUpgradePort(), (String)SocketUtil.authentication);
                    map.put(o3ps.getId(), storageInfo);
                }
                catch (Exception e) {
                    log.error("DiskUtil.getStorageInfo failed, deviceId: {}, mac: {}, error: {}", new Object[]{o3ps.getId(), o3ps.getMac(), e.getMessage(), e});
                }
                finally {
                    if (acquired) {
                        semaphore.release();
                    }
                    MDC.clear();
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Task execution failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        executor.shutdown();
        if (map.size() < o3psList.size()) {
            log.warn("Some devices failed to retrieve storage info, expected: {}, actual: {}", (Object)o3psList.size(), (Object)map.size());
        }
        return map;
    }
}

