/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.videoconfig.report;

import com.ovopark.device.modules.videoconfig.DeviceReportConfig;
import com.ovopark.device.modules.videoconfig.VideoConfigParam;
import com.ovopark.device.modules.videoconfig.VideoDeviceService;
import com.ovopark.device.modules.videoconfig.report.DeviceVideoConfigExcel;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.Session;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/exportDeviceStatusVideoConfigList")
public class VideoConfigReport
implements JobOutTaskFlow<VideoConfigParam> {
    private static final Logger log = LoggerFactory.getLogger(VideoConfigReport.class);
    @Autowired
    private VideoDeviceService videoDeviceService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DeviceReportConfig deviceReportConfig;
    static Semaphore semaphore = new Semaphore(131072);

    public VideoConfigParam requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        VideoConfigParam paramMo = (VideoConfigParam)JSONAccessor.impl().read(requestBody, VideoConfigParam.class);
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setUserId(session.getUserId());
        Integer sessionGroupId = session.getGroupId();
        if (sessionGroupId != null) {
            paramMo.setGroupId(sessionGroupId);
        }
        return paramMo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(VideoConfigParam requestParamBody, OutStore outStore) {
        boolean got;
        Integer userId = requestParamBody.getUserId();
        Integer groupId = requestParamBody.getGroupId();
        String organizeId = requestParamBody.getOrganizeId();
        String deviceType = requestParamBody.getDeviceType();
        Integer onOffStatus = requestParamBody.getOnOffStatus();
        String deviceName = requestParamBody.getDeviceName();
        Locale locale = requestParamBody.getLocale();
        String excelName = this.messageSource.getMessage("report.device.video.config", null, locale);
        OutStore.SegmentWriter segment = outStore.createSegment(excelName);
        segment.header().all(DeviceVideoConfigExcel.class);
        segment.title().title(excelName);
        int permits = this.deviceReportConfig.getParallelism();
        try {
            got = semaphore.tryAcquire(permits, 30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (got) {
            ExecutorService executorService = Executors.newFixedThreadPool(permits, Thread.ofVirtual().factory());
            try {
                this.videoDeviceService.exportDeviceStatusVideoConfigList(userId, groupId, organizeId, deviceType, onOffStatus, deviceName, segment, outStore.limitLogger(), executorService);
            }
            finally {
                semaphore.release(permits);
                executorService.shutdown();
            }
        } else {
            throw new IllegalArgumentException("cannot get enough resource : " + semaphore.availablePermits());
        }
        segment.feature().supportRangeMerge(true);
        segment.commit();
        outStore.feature().supportRangeMerge(true);
    }
}

