/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.modules.platform.PlatformsService;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.platform.mysql.PlatformsMapper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PlatformsServiceImpl
implements PlatformsService {
    @Autowired
    private PlatformsMapper platformsMapper;
    @Resource(name="shopwebStringRedisTemplate")
    private StringRedisTemplate shopwebRedisTemplate;
    private static final String KEY_F = "cache:device:platform:";

    @Override
    public List<Platforms> getPlatforms(List<Integer> platformIds) {
        if (CollectionUtils.isEmpty(platformIds)) {
            return new ArrayList<Platforms>();
        }
        return this.platformsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Platforms::getId, platformIds));
    }

    @Override
    public Platforms getPlatformsById(Integer platformId) {
        Platforms result = null;
        result = this.getFromCache(platformId);
        if (result != null) {
            return result;
        }
        result = (Platforms)this.platformsMapper.selectById(platformId);
        if (result != null) {
            this.setCache(platformId, result);
        }
        return result;
    }

    private void setCache(Integer id, Platforms p) {
        this.shopwebRedisTemplate.opsForValue().set((Object)(KEY_F + id), (Object)JsonUtils.beanToJsonString((Object)p), 5L, TimeUnit.MINUTES);
    }

    private void removeCache(Integer id) {
        this.shopwebRedisTemplate.delete((Object)(KEY_F + id));
    }

    private Platforms getFromCache(Integer id) {
        String o = (String)this.shopwebRedisTemplate.opsForValue().get((Object)(KEY_F + id));
        if (o != null) {
            return (Platforms)JsonUtils.jsonToBean((String)o, Platforms.class);
        }
        return null;
    }
}

