/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform.openapi;

import com.ovopark.device.modules.platform.config.OpenApiConfig;
import com.ovopark.device.modules.platform.openapi.OpenApiSender;
import com.ovopark.device.modules.platform.openapi.ProduceMessage;
import com.ovopark.device.modules.platform.openapi.ReqMessage;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class OpenApiSenderImpl
implements OpenApiSender {
    @Resource(name="openApiKafkaTemplate")
    private KafkaTemplate<String, String> kafkaOpenApiTemplate;
    @Autowired
    private OpenApiConfig openApiConfig;
    private static final RestTemplate restTemplate;

    @Override
    public void send2OpenApi(Object object, int messageType, Integer groupId, String rout, String moduleKey) {
        if (object == null) {
            return;
        }
        String bussinesType = this.openApiConfig.getAnalyticalRulesBussinesType();
        Object url = this.openApiConfig.getAnalyticalRulesUrl();
        url = (String)url + "?businessType={businessType}";
        url = (String)url + "&moduleKey={moduleKey}";
        url = (String)url + "&messageType={messageType}";
        url = (String)url + "&enterpriseId={enterpriseId}";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("businessType", bussinesType);
        paramMap.put("moduleKey", moduleKey);
        paramMap.put("messageType", messageType);
        paramMap.put("enterpriseId", groupId);
        Util.log.info("request analytical rule: " + (String)url + ", params: " + JSONAccessor.impl().format(paramMap));
        String s = (String)restTemplate.getForObject((String)url, String.class, paramMap);
        Util.log.info("analytical rule, response: " + s);
        ReqMessage reqMessage = (ReqMessage)JSONAccessor.impl().read(s, ReqMessage.class);
        if (reqMessage != null && reqMessage.getCode() == 0) {
            if (reqMessage.getData().getCode() == 0) {
                ProduceMessage produceMessage = new ProduceMessage();
                produceMessage.setBusinessType(reqMessage.getData().getBusinessType());
                produceMessage.setEnterpriseId(reqMessage.getData().getEnterpriseId());
                produceMessage.setModuleKey(reqMessage.getData().getModuleKey());
                produceMessage.setMessage(object);
                produceMessage.setMessageType(messageType);
                String topic = reqMessage.getData().getResult();
                if (topic == null || topic.equals("")) {
                    return;
                }
                this.send2OpenApiKafka(produceMessage, topic, rout);
                Util.log.info("todolist / message already send to openapi: " + JSONAccessor.impl().format((Object)produceMessage));
            } else if (reqMessage.getData().getCode() == 1 || reqMessage.getData().getCode() == 2) {
                // empty if block
            }
        }
    }

    private void send2OpenApiKafka(ProduceMessage obj, String topic, String rout) {
        String obj2String = JSONAccessor.impl().format((Object)obj);
        CompletableFuture future = this.kafkaOpenApiTemplate.send(topic, (Object)rout, (Object)obj2String);
        future.handleAsync(new BiFunction<SendResult, Throwable, Object>(this){

            @Override
            public Object apply(SendResult result, Throwable ex) {
                if (ex != null) {
                    Util.log.error(ex.getMessage(), ex);
                    return null;
                }
                RecordMetadata metadata = result.getRecordMetadata();
                int partition = metadata.partition();
                long offset = metadata.offset();
                Util.log.info("record,partition: " + partition + ", offset:" + offset);
                return null;
            }
        });
    }

    static {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
    }
}

