/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.forshopwebcore;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.forshopwebcore.sdk.model.pojo.DeviceAlertPojo;
import com.ovopark.device.forshopwebcore.sdk.model.pojo.DeviceStatusPojo;
import com.ovopark.device.forshopwebcore.sdk.model.pojo.DevicesPojo;
import com.ovopark.device.forshopwebcore.sdk.model.pojo.DevicesVo;
import com.ovopark.device.forshopwebcore.sdk.model.pojo.FaceDevicesVo;
import com.ovopark.device.forshopwebcore.sdk.model.pojo.IdAndNameVo;
import com.ovopark.device.modules.forshopwebcore.DeviceService;
import com.ovopark.device.modules.forshopwebcore.mysql.DeviceAlertForShopWebCore;
import com.ovopark.device.modules.forshopwebcore.mysql.DeviceAlertForShopwebCoreMapper;
import com.ovopark.device.modules.forshopwebcore.mysql.DeviceStatusForShopWebCore;
import com.ovopark.device.modules.forshopwebcore.mysql.DeviceStatusForShopwebCoreMapper;
import com.ovopark.device.modules.forshopwebcore.mysql.DevicesForShopWebCore;
import com.ovopark.device.modules.forshopwebcore.mysql.DevicesForShopwebCoreMapper;
import com.ovopark.device.modules.forshopwebcore.mysql.FaceDevices;
import com.ovopark.device.modules.forshopwebcore.mysql.FaceDevicesMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeviceServiceImpl
implements DeviceService {
    @Autowired
    private FaceDevicesMapper faceDevicesMapper;
    @Autowired
    private DeviceStatusForShopwebCoreMapper deviceStatusMapper;
    @Autowired
    private DevicesForShopwebCoreMapper devicesMapper;
    @Autowired
    private DeviceAlertForShopwebCoreMapper deviceAlertMapper;

    @Override
    public List<DeviceStatusPojo> getDeviceStatusListByMacList(List<String> macList) {
        List list = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DeviceStatusForShopWebCore::getMac, macList)).eq(DeviceStatusForShopWebCore::getIsDelete, (Object)0));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<DeviceStatusPojo> result = new ArrayList<DeviceStatusPojo>();
            for (DeviceStatusForShopWebCore deviceStatusForShopWebCore : list) {
                DeviceStatusPojo pojo = new DeviceStatusPojo();
                BeanUtils.copyProperties((Object)deviceStatusForShopWebCore, (Object)pojo);
                result.add(pojo);
            }
            return result;
        }
        return null;
    }

    @Override
    public void unbindEnterpriseHotspotMapByMapId(Integer enterpriseId, Integer mapId) {
        this.deviceStatusMapper.unbindEnterpriseHotspotMapByMapId(enterpriseId, mapId);
    }

    @Override
    public List<DeviceStatusPojo> listHotspotDeviceByCondition(Integer depId, Integer mapId) {
        if (depId == null && mapId == null) {
            return new ArrayList<DeviceStatusPojo>();
        }
        return this.deviceStatusMapper.listHotspotDeviceByCondition(depId, mapId);
    }

    @Override
    public void bindHotspotDevice(DeviceStatusPojo pojo) {
        DeviceStatusForShopWebCore ds = new DeviceStatusForShopWebCore();
        BeanUtils.copyProperties((Object)pojo, (Object)ds);
        this.deviceStatusMapper.updateById(ds);
    }

    @Override
    public DeviceStatusPojo getDeviceStatusByDeviceId(Integer deviceId) {
        if (deviceId == null) {
            return null;
        }
        DeviceStatusForShopWebCore ds = this.getDeviceStatusById(deviceId);
        if (ds != null) {
            DeviceStatusPojo pojo = new DeviceStatusPojo();
            BeanUtils.copyProperties((Object)ds, (Object)pojo);
            return pojo;
        }
        return null;
    }

    @Override
    public List<DeviceStatusPojo> getDeviceStatusListByDeviceIds(List<Integer> deviceIds) {
        List deviceStatusForShopWebCores = this.deviceStatusMapper.selectList((Wrapper)new LambdaQueryWrapper().in(DeviceStatusForShopWebCore::getId, deviceIds));
        ArrayList<DeviceStatusPojo> result = new ArrayList<DeviceStatusPojo>();
        if (!CollectionUtils.isEmpty((Collection)deviceStatusForShopWebCores)) {
            for (DeviceStatusForShopWebCore deviceStatusForShopWebCore : deviceStatusForShopWebCores) {
                DeviceStatusPojo pojo = new DeviceStatusPojo();
                BeanUtils.copyProperties((Object)deviceStatusForShopWebCore, (Object)pojo);
                result.add(pojo);
            }
        }
        return result;
    }

    @Override
    public List<DeviceStatusPojo> getDeviceStatusByDepId(Integer depId, Integer warningOpen) {
        return this.deviceStatusMapper.getDeviceStatusByDepId(depId, warningOpen);
    }

    @Override
    public DeviceStatusForShopWebCore getDeviceStatusById(Integer id) {
        return (DeviceStatusForShopWebCore)this.deviceStatusMapper.selectById(id);
    }

    @Override
    public List<DeviceStatusPojo> getValidDeviceByMac(String mac) {
        List list = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatusForShopWebCore::getMac, (Object)mac)).eq(DeviceStatusForShopWebCore::getIsDelete, (Object)0));
        ArrayList<DeviceStatusPojo> result = new ArrayList<DeviceStatusPojo>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (DeviceStatusForShopWebCore deviceStatusForShopWebCore : list) {
                DeviceStatusPojo pojo = new DeviceStatusPojo();
                BeanUtils.copyProperties((Object)deviceStatusForShopWebCore, (Object)pojo);
                result.add(pojo);
            }
        }
        return result;
    }

    @Override
    public DeviceStatusPojo getValidDeviceByMacOrMac1(String mac) {
        List<DeviceStatusForShopWebCore> deviceStatusForShopWebCoreList = this.deviceStatusMapper.getValidDeviceByMacOrMac1(mac);
        if (!CollectionUtils.isEmpty(deviceStatusForShopWebCoreList)) {
            DeviceStatusPojo pojo = new DeviceStatusPojo();
            BeanUtils.copyProperties((Object)deviceStatusForShopWebCoreList.get(0), (Object)pojo);
            return pojo;
        }
        return null;
    }

    @Override
    public List<DeviceStatusPojo> getEnterpriseCountDevices(Integer groupId) {
        List<DeviceStatusForShopWebCore> deviceStatusForShopWebCoreList = this.deviceStatusMapper.getEnterpriseCountDevices(groupId);
        ArrayList<DeviceStatusPojo> pojoList = new ArrayList<DeviceStatusPojo>();
        if (!CollectionUtils.isEmpty(deviceStatusForShopWebCoreList)) {
            for (DeviceStatusForShopWebCore deviceStatusForShopWebCore : deviceStatusForShopWebCoreList) {
                if ("PC8-B".equalsIgnoreCase(deviceStatusForShopWebCore.getDeviceType()) && (deviceStatusForShopWebCore.getIsPassengerFlow() == null || deviceStatusForShopWebCore.getIsPassengerFlow() != 1)) continue;
                DeviceStatusPojo pojo = new DeviceStatusPojo();
                BeanUtils.copyProperties((Object)deviceStatusForShopWebCore, (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<FaceDevicesVo> getCountFaceDevices(Integer groupId) {
        List<FaceDevices> faceDevicesList = this.faceDevicesMapper.getCountFaceDevices(groupId);
        ArrayList<FaceDevicesVo> voList = new ArrayList<FaceDevicesVo>();
        if (!CollectionUtils.isEmpty(faceDevicesList)) {
            for (FaceDevices faceDevices : faceDevicesList) {
                FaceDevicesVo vo = new FaceDevicesVo();
                BeanUtils.copyProperties((Object)faceDevices, (Object)vo);
                voList.add(vo);
            }
        }
        return voList;
    }

    @Override
    public DeviceAlertPojo getDeviceAlertById(Integer alertId) {
        DeviceAlertForShopWebCore deviceAlertForShopWebCore = (DeviceAlertForShopWebCore)this.deviceAlertMapper.selectById(alertId);
        if (deviceAlertForShopWebCore != null) {
            DeviceAlertPojo deviceAlertPojo = new DeviceAlertPojo();
            BeanUtils.copyProperties((Object)deviceAlertForShopWebCore, (Object)deviceAlertPojo);
            return deviceAlertPojo;
        }
        return null;
    }

    @Override
    public DeviceAlertPojo saveOrUpdateAlert(DeviceAlertPojo alert) {
        DeviceAlertForShopWebCore deviceAlertForShopWebCore = new DeviceAlertForShopWebCore();
        BeanUtils.copyProperties((Object)alert, (Object)deviceAlertForShopWebCore);
        if (alert.getId() != null) {
            this.deviceAlertMapper.updateById(deviceAlertForShopWebCore);
        } else {
            this.deviceAlertMapper.insert(deviceAlertForShopWebCore);
            alert.setId(deviceAlertForShopWebCore.getId());
        }
        return alert;
    }

    @Override
    public DevicesPojo getDeviceById(Integer deviceId) {
        DevicesForShopWebCore devicesForShopWebCore = this.getDevicesById(deviceId);
        if (devicesForShopWebCore != null) {
            DevicesPojo devicesPojo = new DevicesPojo();
            BeanUtils.copyProperties((Object)devicesForShopWebCore, (Object)devicesPojo);
            return devicesPojo;
        }
        return null;
    }

    @Override
    public List<DeviceStatusPojo> getCountDevicesByDepId(Integer depId) {
        List<DeviceStatusForShopWebCore> deviceStatusForShopWebCoreList = this.deviceStatusMapper.getCountDevicesByDepId(depId);
        ArrayList<DeviceStatusPojo> pojoList = new ArrayList<DeviceStatusPojo>();
        if (!CollectionUtils.isEmpty(deviceStatusForShopWebCoreList)) {
            for (DeviceStatusForShopWebCore deviceStatusForShopWebCore : deviceStatusForShopWebCoreList) {
                if ("PC8-B".equalsIgnoreCase(deviceStatusForShopWebCore.getDeviceType()) && (deviceStatusForShopWebCore.getIsPassengerFlow() == null || deviceStatusForShopWebCore.getIsPassengerFlow() != 1)) continue;
                DeviceStatusPojo pojo = new DeviceStatusPojo();
                BeanUtils.copyProperties((Object)deviceStatusForShopWebCore, (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public DevicesForShopWebCore getDevicesById(Integer deviceId) {
        return (DevicesForShopWebCore)this.devicesMapper.selectById(deviceId);
    }

    @Override
    public List<DeviceStatusPojo> getHotspotDevicesByDepIds(List<Integer> depIds) {
        return this.deviceStatusMapper.getHotspotDevicesByDepIds(depIds);
    }

    @Override
    public List<IdAndNameVo> selectIdAndName(List<Integer> idList) {
        return this.devicesMapper.selectIdAndName(idList);
    }

    @Override
    public List<DevicesVo> selectDevicesListBydepId(Integer depId) {
        return this.devicesMapper.selectDevicesListBydepId(depId);
    }

    @Override
    public int initRandomCheck(Integer userId) {
        return this.devicesMapper.clearRandomCheckDevices(userId);
    }
}

