/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.tokenflow;

import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEs;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEsSum;
import com.ovopark.device.modules.manage.mysql.LocalDayGbChannelInfoEs;
import com.ovopark.device.modules.manage.tokenflow.FlowCalculateAggr;
import com.ovopark.device.modules.manage.tokenflow.FlowCalculateRequest;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import java.util.HashMap;
import java.util.Map;

public class FlowCalculateSubscriber
extends CoreSubscriber<Object> {
    final Map<String, LocalDayChannelInfoEsSum> localDayChannelInfoEsSumMap = new HashMap<String, LocalDayChannelInfoEsSum>();
    final FlowCalculateAggr flowCalculateAggr;
    final FlowCalculateRequest flowCalculateRequest;

    public FlowCalculateSubscriber(FlowCalculateAggr flowCalculateAggr, FlowCalculateRequest flowCalculateRequest) {
        this.flowCalculateAggr = flowCalculateAggr;
        this.flowCalculateRequest = flowCalculateRequest;
    }

    public void onNext(Object object) {
        String countDate;
        String licenseToken = null;
        Long flow = null;
        Long channelSum = null;
        if (object instanceof LocalDayChannelInfoEs) {
            LocalDayChannelInfoEs localDayChannelInfoEs = (LocalDayChannelInfoEs)object;
            licenseToken = localDayChannelInfoEs.getLicenseToken();
            flow = localDayChannelInfoEs.getFlow();
            channelSum = localDayChannelInfoEs.getChannelSum();
            countDate = localDayChannelInfoEs.getCountDate();
        } else if (object instanceof LocalDayGbChannelInfoEs) {
            LocalDayGbChannelInfoEs localDayGbChannelInfoEs = (LocalDayGbChannelInfoEs)object;
            licenseToken = localDayGbChannelInfoEs.getLicenseToken();
            flow = localDayGbChannelInfoEs.getFlow();
            channelSum = localDayGbChannelInfoEs.getChannelSum();
            countDate = localDayGbChannelInfoEs.getCountDate();
        } else {
            Object countDate2 = null;
            throw new UnsupportedOperationException();
        }
        if (Util.compare2((Comparable)((Object)countDate), (Comparable)((Object)this.flowCalculateRequest.getCountDate())) != 0) {
            throw new RuntimeException("date is invalid");
        }
        LocalDayChannelInfoEsSum localDayChannelInfoEsSum = this.localDayChannelInfoEsSumMap.computeIfAbsent(licenseToken, s -> {
            LocalDayChannelInfoEsSum localDayChannelInfoEsSum1 = new LocalDayChannelInfoEsSum();
            localDayChannelInfoEsSum1.setLicenseToken((String)s);
            localDayChannelInfoEsSum1.setCountDate(countDate);
            localDayChannelInfoEsSum1.setFlow(0L);
            localDayChannelInfoEsSum1.setChannelSum(0L);
            return localDayChannelInfoEsSum1;
        });
        localDayChannelInfoEsSum.setFlow(localDayChannelInfoEsSum.getFlow() + (Long)Util.convert2Self((Object)flow, (Object)0L));
        localDayChannelInfoEsSum.setChannelSum(localDayChannelInfoEsSum.getChannelSum() + (Long)Util.convert2Self((Object)channelSum, (Object)0L));
    }

    public void onComplete() {
        this.flowCalculateAggr.emit(this.localDayChannelInfoEsSumMap);
    }

    public void onError(Throwable t) {
        throw new RuntimeException(t);
    }
}

