/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.tokenflow;

import com.ovopark.device.modules.manage.tokenflow.EnterpriseFlowQuery;
import com.ovopark.device.modules.manage.tokenflow.EnterpriseFlowVo;
import com.ovopark.device.modules.manage.tokenflow.FlowStatService;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.LimitLogger;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.Session;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/exportEnterpriseFlow")
public class FlowExport
implements JobOutTaskFlow<EnterpriseFlowQuery> {
    private static final Logger log = LoggerFactory.getLogger(FlowExport.class);
    @Autowired
    FlowStatService flowStatService;
    @Autowired
    private MessageSource messageSource;

    public EnterpriseFlowQuery requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        EnterpriseFlowQuery enterpriseFlowQuery = (EnterpriseFlowQuery)((Object)JSONAccessor.impl().read(requestBody, EnterpriseFlowQuery.class));
        enterpriseFlowQuery.setLocale(session.clientInfo().getLocale());
        enterpriseFlowQuery.setFetchGroupFlow(false);
        return enterpriseFlowQuery;
    }

    public void execute(EnterpriseFlowQuery requestParamBody, OutStore outStore) {
        Locale locale = requestParamBody.getLocale();
        requestParamBody.setPageNumber(0L);
        requestParamBody.setPageSize(1000000);
        OutStore.SegmentWriter segment = outStore.createSegment("\u4f01\u4e1a\u6d41\u91cf\u62a5\u8868");
        segment.title().title("\u4f01\u4e1a\u6d41\u91cf\u62a5\u8868 " + requestParamBody.getStartTime() + " - " + requestParamBody.getEndTime());
        segment.header().all(EnterpriseFlowVo.class, path -> this.messageSource.getMessage(path, null, locale));
        Util.logLink((String)"groupFlow start, ").log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((LimitLogger)outStore.limitLogger()).log(arg_0));
        PageModel<EnterpriseFlowVo> enterpriseFlowVoPageModel = this.flowStatService.groupFlow(requestParamBody);
        Util.logLink((String)"groupFlow end, ").log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((LimitLogger)outStore.limitLogger()).log(arg_0));
        List enterpriseFlowVoList = enterpriseFlowVoPageModel.getData();
        for (EnterpriseFlowVo enterpriseFlowVo : enterpriseFlowVoList) {
            segment.append((Model)enterpriseFlowVo);
        }
        segment.commit();
    }
}

