/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.platform.api.UserRoleFacade;
import com.ovopark.privilege.api.UserApi;
import com.ovopark.privilege.response.BaseResult;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserRoleFacadeImpl
implements UserRoleFacade {
    private static final Logger log = LoggerFactory.getLogger(UserRoleFacadeImpl.class);
    @Resource
    private UserApi userApi;

    public Boolean isSuperAdmin(Integer userId, Integer groupId) {
        try {
            BaseResult superAdmin = this.userApi.isSuperAdmin(userId, groupId);
            return (Boolean)superAdmin.getData();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528 userApi.isSuperAdmin \u5931\u8d25{}", (Object)LogUtil.getStackTraceInfo((Exception)e));
            return false;
        }
    }

    public Boolean isSystemAdmin(Integer userId, Integer groupId) {
        try {
            BaseResult superAdmin = this.userApi.isSystemAdmin(userId, null);
            return (Boolean)superAdmin.getData();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528 userApi.isSystemAdmin \u5931\u8d25{}", (Object)LogUtil.getStackTraceInfo((Exception)e));
            return false;
        }
    }

    public Boolean isGroupAdmin(Integer userId, Integer groupId) {
        if (userId == null) {
            return false;
        }
        boolean isSuperAdmin = this.isSuperAdmin(userId, groupId);
        return isSuperAdmin && groupId != null;
    }
}

