/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportdevice.report;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.reportdevice.DeviceStatusRecordServiceImpl;
import com.ovopark.device.modules.reportdevice.report.DeviceOnlineRateExcel;
import com.ovopark.device.modules.reportdevice.report.DeviceStatusCurrentExcel;
import com.ovopark.device.modules.reportdevice.vo.DeviceOnlineRateVo;
import com.ovopark.device.modules.reportdevice.vo.DeviceStatusReportVo;
import com.ovopark.device.modules.reportdevice.vo.ExportDeviceStatusCurrentMo;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.platform.api.model.OnOffVo;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.NoPrivilegeException;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.Session;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="/ovopark-device-report-form/deviceReport/realReport")
public class RealReport
implements JobOutTaskFlow<ExportDeviceStatusCurrentMo> {
    private static final Logger log = LoggerFactory.getLogger(RealReport.class);
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Autowired
    private DeviceStatusRecordServiceImpl deviceStatusRecordService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private OnlineFacade onlineFacadeRPC;

    public ExportDeviceStatusCurrentMo requestParamBody(String requestBody, Session session) throws NoPrivilegeException {
        log.info("Request param body: {}", (Object)requestBody);
        log.info("Session info: {}", (Object)JSONAccessor.impl().format((Object)session));
        ExportDeviceStatusCurrentMo paramMo = (ExportDeviceStatusCurrentMo)JSONAccessor.impl().read(requestBody, ExportDeviceStatusCurrentMo.class);
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setUserId(session.getUserId());
        Integer sessionGroupId = session.getGroupId();
        if (sessionGroupId != null) {
            paramMo.setEnterpriseId(sessionGroupId);
        }
        return paramMo;
    }

    public void execute(ExportDeviceStatusCurrentMo requestParamBody, OutStore outStore) {
        try {
            ExportParams exportParams = this.extractExportParams(requestParamBody);
            Boolean exportFlag = true;
            log.info("Starting concurrent device status data query, userId: {}, enterpriseId: {}", (Object)exportParams.getUserId(), (Object)exportParams.getEnterpriseId());
            Map mdcContext = MDC.getCopyOfContextMap();
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                CompletableFuture<PageModel> deviceStatusFuture = CompletableFuture.supplyAsync(() -> this.executeWithMdcContext(mdcContext, "getDeviceStatusCurrentList", () -> this.deviceStatusRecordService.getDeviceStatusCurrentList(exportParams.getUserId(), exportParams.getEnterpriseId(), exportParams.getOrganizeId(), exportParams.getType(), exportParams.getDeviceOnline(), exportParams.getSearchName(), exportParams.getDeviceTypeList(), exportParams.getOfflineSecond(), exportParams.getDeptStatus(), exportParams.getOffLineTimeFilterSecond(), exportParams.getOffLineTimeFilterType(), exportParams.getDeptTagList(), exportParams.getValidateStatus(), 1, Integer.MAX_VALUE, exportFlag)), executor);
                CompletableFuture<DeviceOnlineRateVo> deviceOnlineRateFuture = CompletableFuture.supplyAsync(() -> this.executeWithMdcContext(mdcContext, "getDeviceOnlineRateData", () -> this.getDeviceOnlineRateData(exportParams)), executor);
                CompletableFuture<Void> allTasks = CompletableFuture.allOf(deviceStatusFuture, deviceOnlineRateFuture);
                allTasks.get(20L, TimeUnit.MINUTES);
                PageModel deviceStatusReportVos = deviceStatusFuture.get();
                DeviceOnlineRateVo deviceOnlineRateVo = deviceOnlineRateFuture.get();
                log.info("Concurrent execution completed, device status data count: {}, online rate data: {}", (Object)(deviceStatusReportVos != null ? deviceStatusReportVos.getData().size() : 0), (Object)(deviceOnlineRateVo != null ? "retrieved" : "no data"));
                List deviceStatusData = deviceStatusReportVos != null ? deviceStatusReportVos.getData() : new ArrayList();
                this.generateExcelReport(deviceStatusData, deviceOnlineRateVo, exportParams, outStore);
            }
            catch (Exception e) {
                log.error("Failed to execute concurrent device status query", (Throwable)e);
                throw new RuntimeException("Failed to execute concurrent device status query", e);
            }
        }
        catch (Exception e) {
            log.error("Failed to generate device status report", (Throwable)e);
            throw new RuntimeException("Failed to generate device status report", e);
        }
    }

    private <T> T executeWithMdcContext(Map<String, String> mdcContext, String taskName, Supplier<T> task) {
        Map originalContext = MDC.getCopyOfContextMap();
        try {
            if (mdcContext != null) {
                MDC.setContextMap(mdcContext);
            }
            log.info("Starting execution of {}, thread: {}", (Object)taskName, (Object)Thread.currentThread());
            long startTime = System.currentTimeMillis();
            T result = task.get();
            long endTime = System.currentTimeMillis();
            log.info("Completed execution of {}, duration: {}ms, thread: {}", new Object[]{taskName, endTime - startTime, Thread.currentThread()});
            T t = result;
            return t;
        }
        catch (Exception e) {
            log.error("Failed to execute {}, thread: {}", new Object[]{taskName, Thread.currentThread(), e});
            throw e;
        }
        finally {
            try {
                if (originalContext != null) {
                    MDC.setContextMap((Map)originalContext);
                } else {
                    MDC.clear();
                }
            }
            catch (Exception e) {
                log.warn("Failed to cleanup MDC context", (Throwable)e);
            }
        }
    }

    private ExportParams extractExportParams(ExportDeviceStatusCurrentMo requestParamBody) {
        return ExportParams.builder().userId(requestParamBody.getUserId()).enterpriseId(requestParamBody.getEnterpriseId()).organizeId(requestParamBody.getOrganizeId()).type(requestParamBody.getType()).deviceTypeList(requestParamBody.getDeviceTypeList()).locale(requestParamBody.getLocale()).deptTagList(requestParamBody.getDeptTagList()).offlineSecond(requestParamBody.getOfflineSecond()).deviceOnline(requestParamBody.getDeviceOnline()).searchName(requestParamBody.getSearchName()).offLineTimeFilterType(requestParamBody.getOffLineTimeFilterType()).offLineTimeFilterSecond(requestParamBody.getOffLineTimeFilterSecond()).deptStatus(requestParamBody.getDeptStatus()).validateStatus(requestParamBody.getValidateStatus()).build();
    }

    private DeviceOnlineRateVo getDeviceOnlineRateData(ExportParams exportParams) {
        DepAndTagsPojo depAndTagsPojo = this.buildDepartmentQueryCondition(exportParams.getUserId(), exportParams.getEnterpriseId(), exportParams.getOrganizeId(), exportParams.getDeptStatus(), exportParams.getValidateStatus(), exportParams.getDeptTagList());
        List deptIdList = this.rpcFacade.getUserPrivilegeDepByOrganizeIdsAndUser(depAndTagsPojo);
        if (Util.isEmpty((Collection)deptIdList)) {
            return null;
        }
        List<Integer> excludeDtypeList = Arrays.asList(62);
        List<DeviceStatus> userDeviceStatus = this.deviceStatusService.getUserDeviceStatus(exportParams.getUserId(), exportParams.getEnterpriseId(), deptIdList, null, excludeDtypeList);
        if (CollectionUtils.isEmpty(userDeviceStatus)) {
            return null;
        }
        Map dmsStatusVoMap = this.onlineFacadeRPC.onOffTimeRT(userDeviceStatus.stream().map(DeviceStatus::getId).collect(Collectors.toList()));
        Map<Integer, Integer> dmsStatus = this.calculateOnlineStatus(dmsStatusVoMap, exportParams.getOfflineSecond());
        return this.deviceStatusRecordService.getDeviceOnlineRate(userDeviceStatus, dmsStatus, exportParams.getType(), exportParams.getDeviceTypeList());
    }

    private DepAndTagsPojo buildDepartmentQueryCondition(Integer userId, Integer enterpriseId, String organizeId, Integer deptStatus, Integer validateStatus, List<Integer> deptTagList) {
        DepAndTagsPojo depAndTagsPojo = new DepAndTagsPojo();
        depAndTagsPojo.setUserId(userId);
        depAndTagsPojo.setGroupId(enterpriseId);
        depAndTagsPojo.setContainAll(Boolean.valueOf(false));
        if (deptStatus != null) {
            depAndTagsPojo.setOpenStatue(Arrays.asList(deptStatus));
        }
        if (validateStatus != null) {
            depAndTagsPojo.setValidateStatus(Arrays.asList(validateStatus));
        }
        ArrayList<Object> typeIds = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)organizeId)) {
            typeIds.addAll(Arrays.asList(organizeId.split(",")));
        }
        if (Util.isNotEmpty(deptTagList)) {
            typeIds.addAll(deptTagList.stream().map(v -> "T_" + v).collect(Collectors.toList()));
        }
        if (Util.isEmpty(typeIds)) {
            Integer rootOrganize = this.rpcFacade.getRootOrganize(enterpriseId);
            typeIds.add("O_" + rootOrganize);
        }
        depAndTagsPojo.setTypeIds(typeIds);
        return depAndTagsPojo;
    }

    private Map<Integer, Integer> calculateOnlineStatus(Map<Integer, OnOffVo> dmsStatusVoMap, int offlineSecond) {
        long nowTime = System.currentTimeMillis() / 1000L;
        HashMap<Integer, Integer> dmsStatus = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, OnOffVo> entry : dmsStatusVoMap.entrySet()) {
            Integer id = entry.getKey();
            OnOffVo onlineVo = entry.getValue();
            if (onlineVo == null) {
                dmsStatus.put(id, 0);
                continue;
            }
            Integer online = onlineVo.getOnline();
            if (online == 0 && onlineVo.getOfflineTimeStamp() != 0L && nowTime - onlineVo.getOfflineTimeStamp() < (long)offlineSecond) {
                online = 1;
            }
            dmsStatus.put(id, online);
        }
        return dmsStatus;
    }

    private void generateExcelReport(List<DeviceStatusReportVo> deviceStatusReportVos, DeviceOnlineRateVo deviceOnlineRateVo, ExportParams exportParams, OutStore outStore) {
        this.generateDeviceOnlineRateSheet(deviceOnlineRateVo, exportParams, outStore);
        this.generateDeviceStatusDetailSheet(deviceStatusReportVos, exportParams, outStore);
        String excelName = this.messageSource.getMessage("DeviceReport.deviceCurrent.excel", null, exportParams.getLocale());
        outStore.fileName(excelName);
    }

    private void generateDeviceOnlineRateSheet(DeviceOnlineRateVo deviceOnlineRateVo, ExportParams exportParams, OutStore outStore) {
        OutStore.SegmentWriter firstSegment = outStore.createSegment(this.messageSource.getMessage("DeviceReport.deviceCurrent.sheet.rate", null, exportParams.getLocale()));
        firstSegment.header().all(DeviceOnlineRateExcel.class, p -> this.messageSource.getMessage(p, null, exportParams.getLocale()));
        if (deviceOnlineRateVo != null) {
            DeviceOnlineRateExcel deviceOnlineRateExcel = this.buildDeviceOnlineRateExcel(deviceOnlineRateVo, exportParams.getType());
            firstSegment.append((Model)deviceOnlineRateExcel);
        }
        firstSegment.commit();
    }

    private DeviceOnlineRateExcel buildDeviceOnlineRateExcel(DeviceOnlineRateVo deviceOnlineRateVo, Integer type) {
        DeviceOnlineRateExcel deviceOnlineRateExcel = new DeviceOnlineRateExcel();
        DeviceCountInfo countInfo = this.getDeviceCountByType(deviceOnlineRateVo, type);
        deviceOnlineRateExcel.setDeviceTotal(Integer.toString(countInfo.getTotal()));
        deviceOnlineRateExcel.setOnlineNum(Integer.toString(countInfo.getOnlineNum()));
        deviceOnlineRateExcel.setOnlineRate(this.calculateOnlineRate(countInfo.getTotal(), countInfo.getOnlineNum()));
        return deviceOnlineRateExcel;
    }

    private DeviceCountInfo getDeviceCountByType(DeviceOnlineRateVo deviceOnlineRateVo, Integer type) {
        int total = 0;
        int onlineNum = 0;
        switch (type) {
            case 0: {
                total = deviceOnlineRateVo.getDeviceTotal();
                onlineNum = deviceOnlineRateVo.getDeviceOnlineNum();
                break;
            }
            case 1: {
                total = deviceOnlineRateVo.getNvrTotal();
                onlineNum = deviceOnlineRateVo.getNvrOnlineNum();
                break;
            }
            case 2: {
                total = deviceOnlineRateVo.getIpcTotal();
                onlineNum = deviceOnlineRateVo.getIpcOnlineNum();
                break;
            }
            case 3: {
                total = deviceOnlineRateVo.getPcTotal();
                onlineNum = deviceOnlineRateVo.getPcOnlineNum();
                break;
            }
            case 4: {
                total = deviceOnlineRateVo.getGatewayIpcTotal();
                onlineNum = deviceOnlineRateVo.getGatewayIpcOnlineNum();
                break;
            }
        }
        return new DeviceCountInfo(total, onlineNum);
    }

    private String calculateOnlineRate(int total, int onlineNum) {
        if (total == 0) {
            return "0.00%";
        }
        BigDecimal rate = new BigDecimal((float)onlineNum / (float)total);
        DecimalFormat df = new DecimalFormat("0.00%");
        BigDecimal roundedRate = rate.setScale(4, RoundingMode.HALF_UP);
        return df.format(roundedRate);
    }

    private void generateDeviceStatusDetailSheet(List<DeviceStatusReportVo> deviceStatusReportVos, ExportParams exportParams, OutStore outStore) {
        OutStore.SegmentWriter secondSegment = outStore.createSegment(this.messageSource.getMessage("DeviceReport.deviceCurrent.sheet.online", null, exportParams.getLocale()));
        secondSegment.header().all(DeviceStatusCurrentExcel.class, p -> this.messageSource.getMessage(p, null, exportParams.getLocale()));
        if (CollectionUtils.isNotEmpty(deviceStatusReportVos)) {
            List<DeviceStatusCurrentExcel> excelDataList = this.buildDeviceStatusExcelData(deviceStatusReportVos, exportParams);
            excelDataList.forEach(arg_0 -> ((OutStore.SegmentWriter)secondSegment).append(arg_0));
        }
        secondSegment.commit();
    }

    private List<DeviceStatusCurrentExcel> buildDeviceStatusExcelData(List<DeviceStatusReportVo> deviceStatusReportVos, ExportParams exportParams) {
        String online = this.messageSource.getMessage("DeviceReport.device.online", null, exportParams.getLocale());
        String offline = this.messageSource.getMessage("DeviceReport.device.offline", null, exportParams.getLocale());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        long searchTimeL = now.getTime() / 1000L;
        String searchTimeStr = sdf.format(now);
        return deviceStatusReportVos.stream().map(vo -> this.buildDeviceStatusCurrentExcel((DeviceStatusReportVo)vo, online, offline, sdf, searchTimeL, searchTimeStr, exportParams.getLocale())).collect(Collectors.toList());
    }

    private DeviceStatusCurrentExcel buildDeviceStatusCurrentExcel(DeviceStatusReportVo vo, String online, String offline, SimpleDateFormat sdf, long searchTimeL, String searchTimeStr, Locale locale) {
        DeviceStatusCurrentExcel excel = new DeviceStatusCurrentExcel();
        excel.setDeviceName(vo.getDeviceName());
        excel.setMac(vo.getMac());
        excel.setOnline(vo.getOnline() == 1 ? online : offline);
        excel.setDeviceType(vo.getdType());
        excel.setDeviceTypeName(vo.getDeviceType());
        excel.setCreateTime(vo.getCreateTime());
        excel.setOrgName(vo.getOrgName());
        excel.setDepName(vo.getDepName());
        excel.setTagNames(vo.getTagNames());
        excel.setShopId(vo.getShopId());
        excel.setSearchTime(searchTimeStr);
        this.setOfflineTimeInfo(excel, vo.getOfflineTimeStamp(), sdf, searchTimeL);
        excel.setDepOpenStatus(this.setDepOpenStatus(vo.getDepOpenStatus(), locale));
        excel.setDepValidateStatus(this.setDepValidateStatus(vo.getValidateStatus(), locale));
        String depTel = vo.getDepTel();
        excel.setDepTel(Util.isNotEmpty((CharSequence)depTel) ? depTel : "-");
        return excel;
    }

    private void setOfflineTimeInfo(DeviceStatusCurrentExcel excel, long offlineTimeStamp, SimpleDateFormat sdf, long searchTimeL) {
        if (offlineTimeStamp == 0L) {
            excel.setOfflineTime("-");
            excel.setOfflineTimes("-");
        } else {
            excel.setOfflineTime(sdf.format(new Date(offlineTimeStamp * 1000L)));
            excel.setOfflineTimes(RealReport.secToTime(searchTimeL - offlineTimeStamp));
        }
    }

    public static String secToTime(Long seconds) {
        long hour = seconds / 3600L;
        long minute = (seconds - hour * 3600L) / 60L;
        long second = seconds - hour * 3600L - minute * 60L;
        StringBuilder sb = new StringBuilder();
        if (hour > 9L) {
            sb.append(hour).append(":");
        } else if (hour > 0L) {
            sb.append("0").append(hour).append(":");
        } else {
            sb.append("00:");
        }
        if (minute > 9L) {
            sb.append(minute).append(":");
        } else if (minute > 0L) {
            sb.append("0").append(minute).append(":");
        } else {
            sb.append("00:");
        }
        if (second > 9L) {
            sb.append(second);
        } else if (second > 0L) {
            sb.append("0").append(second);
        } else {
            sb.append("00");
        }
        return sb.toString();
    }

    private String setDepOpenStatus(Integer openStatus, Locale locale) {
        String status = "";
        switch (openStatus) {
            case 0: {
                status = this.messageSource.getMessage("department.export.status.preparing", null, locale);
                break;
            }
            case 1: {
                status = this.messageSource.getMessage("department.export.status.open", null, locale);
                break;
            }
            case 2: {
                status = this.messageSource.getMessage("department.export.status.closed", null, locale);
                break;
            }
            case 3: {
                status = this.messageSource.getMessage("department.export.status.temporarily-closed", null, locale);
                break;
            }
        }
        return status;
    }

    private String setDepValidateStatus(Integer validateStatus, Locale locale) {
        String status = "";
        switch (validateStatus) {
            case 0: {
                status = this.messageSource.getMessage("department.export.validateStatus.not-expired", null, locale);
                break;
            }
            case 1: {
                status = this.messageSource.getMessage("department.export.validateStatus.expired", null, locale);
                break;
            }
            case 2: {
                status = this.messageSource.getMessage("department.export.validateStatus.about-to-expire", null, locale);
                break;
            }
        }
        return status;
    }

    private static class ExportParams {
        private final Integer userId;
        private final Integer enterpriseId;
        private final String organizeId;
        private final Integer type;
        private final List<String> deviceTypeList;
        private final Locale locale;
        private final List<Integer> deptTagList;
        private final int offlineSecond;
        private final Integer deviceOnline;
        private final String searchName;
        private final Integer offLineTimeFilterType;
        private final Integer offLineTimeFilterSecond;
        private final Integer deptStatus;
        private final Integer validateStatus;

        private ExportParams(Builder builder) {
            this.userId = builder.userId;
            this.enterpriseId = builder.enterpriseId;
            this.organizeId = builder.organizeId;
            this.type = builder.type;
            this.deviceTypeList = builder.deviceTypeList;
            this.locale = builder.locale;
            this.deptTagList = builder.deptTagList;
            this.offlineSecond = builder.offlineSecond;
            this.deviceOnline = builder.deviceOnline;
            this.searchName = builder.searchName;
            this.offLineTimeFilterType = builder.offLineTimeFilterType;
            this.offLineTimeFilterSecond = builder.offLineTimeFilterSecond;
            this.deptStatus = builder.deptStatus;
            this.validateStatus = builder.validateStatus;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Integer getUserId() {
            return this.userId;
        }

        public Integer getEnterpriseId() {
            return this.enterpriseId;
        }

        public String getOrganizeId() {
            return this.organizeId;
        }

        public Integer getType() {
            return this.type;
        }

        public List<String> getDeviceTypeList() {
            return this.deviceTypeList;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public List<Integer> getDeptTagList() {
            return this.deptTagList;
        }

        public int getOfflineSecond() {
            return this.offlineSecond;
        }

        public Integer getDeviceOnline() {
            return this.deviceOnline;
        }

        public String getSearchName() {
            return this.searchName;
        }

        public Integer getOffLineTimeFilterType() {
            return this.offLineTimeFilterType;
        }

        public Integer getOffLineTimeFilterSecond() {
            return this.offLineTimeFilterSecond;
        }

        public Integer getDeptStatus() {
            return this.deptStatus;
        }

        public Integer getValidateStatus() {
            return this.validateStatus;
        }

        public static class Builder {
            private Integer userId;
            private Integer enterpriseId;
            private String organizeId;
            private Integer type;
            private List<String> deviceTypeList;
            private Locale locale;
            private List<Integer> deptTagList;
            private int offlineSecond;
            private Integer deviceOnline;
            private String searchName;
            private Integer offLineTimeFilterType;
            private Integer offLineTimeFilterSecond;
            private Integer deptStatus;
            private Integer validateStatus;

            public Builder userId(Integer userId) {
                this.userId = userId;
                return this;
            }

            public Builder enterpriseId(Integer enterpriseId) {
                this.enterpriseId = enterpriseId;
                return this;
            }

            public Builder organizeId(String organizeId) {
                this.organizeId = organizeId;
                return this;
            }

            public Builder type(Integer type) {
                this.type = type;
                return this;
            }

            public Builder deviceTypeList(List<String> deviceTypeList) {
                this.deviceTypeList = deviceTypeList;
                return this;
            }

            public Builder locale(Locale locale) {
                this.locale = locale;
                return this;
            }

            public Builder deptTagList(List<Integer> deptTagList) {
                this.deptTagList = deptTagList;
                return this;
            }

            public Builder offlineSecond(int offlineSecond) {
                this.offlineSecond = offlineSecond;
                return this;
            }

            public Builder deviceOnline(Integer deviceOnline) {
                this.deviceOnline = deviceOnline;
                return this;
            }

            public Builder searchName(String searchName) {
                this.searchName = searchName;
                return this;
            }

            public Builder offLineTimeFilterType(Integer offLineTimeFilterType) {
                this.offLineTimeFilterType = offLineTimeFilterType;
                return this;
            }

            public Builder offLineTimeFilterSecond(Integer offLineTimeFilterSecond) {
                this.offLineTimeFilterSecond = offLineTimeFilterSecond;
                return this;
            }

            public Builder deptStatus(Integer deptStatus) {
                this.deptStatus = deptStatus;
                return this;
            }

            public Builder validateStatus(Integer validateStatus) {
                this.validateStatus = validateStatus;
                return this;
            }

            public ExportParams build() {
                return new ExportParams(this);
            }
        }
    }

    private static class DeviceCountInfo {
        private final int total;
        private final int onlineNum;

        public DeviceCountInfo(int total, int onlineNum) {
            this.total = total;
            this.onlineNum = onlineNum;
        }

        public int getTotal() {
            return this.total;
        }

        public int getOnlineNum() {
            return this.onlineNum;
        }
    }
}

