/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportdisk;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.common.util.ListUtil;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.reportdisk.DeviceDiskService;
import com.ovopark.device.modules.reportdisk.DiskInfoService;
import com.ovopark.device.modules.reportdisk.DiskTimeStatus;
import com.ovopark.device.modules.reportdisk.mysql.DeviceStorage;
import com.ovopark.device.modules.reportdisk.mysql.DeviceStorageMapper;
import com.ovopark.device.modules.reportdisk.mysql.DiskStatusHistory;
import com.ovopark.device.modules.reportdisk.mysql.DiskStatusHistoryMapper;
import com.ovopark.device.modules.reportdisk.vo.DiskErrDeviceVo;
import com.ovopark.device.modules.reportdisk.vo.DiskStatusNewV2Vo;
import com.ovopark.device.modules.reportdisk.vo.DisksListBeanVo;
import com.ovopark.device.platform.api.UserDepartmentPrivilegeFacade;
import com.ovopark.device.signalling.util.AbilityUtil;
import com.ovopark.device.thirdparty.ovoIot.model.dms.Dms1DiskByMaclistReq;
import com.ovopark.device.thirdparty.ovoIot.model.dms.Dms1DiskByMaclistRes;
import com.ovopark.device.thirdparty.ovoIot.model.mms.MmsRsp;
import com.ovopark.device.thirdparty.ovoIot.service.DmsSumFeign;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiskInfoServiceImpl
implements DiskInfoService {
    @Autowired
    private DeviceStatusService deviceReportService;
    @Autowired
    private DmsSumFeign dmsSumFeign;
    @Autowired
    private DeviceDiskService deviceDiskService;
    @Autowired
    private DeviceStorageMapper deviceStorageMapper;
    @Autowired
    private DiskStatusHistoryMapper diskStatusHistoryMapper;
    @Autowired
    private UserDepartmentPrivilegeFacade userDepartmentPrivilegeFacade;

    @Override
    public PageModel<DiskStatusNewV2Vo> diskInfo(Integer groupId, String organizationId, Integer type, String startTime, String endTime, Integer diskNum, Integer pageNum, Integer pageSize, Integer sessionUserId, Integer status) {
        int total;
        ArrayList resList;
        block69: {
            List<Object> needResList;
            Map<Integer, String> userDepNameMap;
            LocalDateTime endDateTime;
            LocalDateTime startDateTime;
            block70: {
                ArrayList<Object> devList;
                block68: {
                    Util.log.info("type: " + type + ", startTime: " + startTime + ",endTime: " + endTime + ", diskNum: " + diskNum);
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    startDateTime = LocalDateTime.parse(startTime, formatter);
                    endDateTime = LocalDateTime.parse(endTime, formatter);
                    if (endDateTime.toLocalDate().isEqual(LocalDate.now())) {
                        endDateTime = endDateTime.minusDays(1L);
                    }
                    long days = ChronoUnit.DAYS.between(startDateTime.toLocalDate(), endDateTime.toLocalDate()) + 1L;
                    userDepNameMap = this.deviceReportService.getUserDepNameMap(sessionUserId, groupId, organizationId);
                    Set<Integer> deptIdSet = userDepNameMap.keySet();
                    ArrayList<Integer> deptIdList = new ArrayList<Integer>(deptIdSet);
                    List<Object> userDeviceStatus = new ArrayList();
                    if (type == 1) {
                        userDeviceStatus = this.deviceReportService.getUserDeviceStatus(sessionUserId, groupId, deptIdList, null, null, Arrays.asList(2, 20));
                    } else if (type == 2) {
                        userDeviceStatus = this.deviceReportService.getUserDeviceStatus(sessionUserId, groupId, deptIdList, null, null, Arrays.asList(22));
                    }
                    if (type == 3) {
                        userDeviceStatus = this.deviceReportService.getUserDeviceStatus(sessionUserId, groupId, deptIdList, null, null, Arrays.asList(64, 62));
                    }
                    resList = new ArrayList();
                    HashMap<String, Integer> lcMacMap = new HashMap<String, Integer>();
                    PageModel result = new PageModel();
                    devList = new ArrayList<Object>();
                    HashMap<String, DeviceStatus> macAndDevMap = new HashMap<String, DeviceStatus>();
                    for (DeviceStatus item : userDeviceStatus) {
                        Integer dType = item.getDType();
                        String string = item.getExtendCapacity();
                        boolean aBoolean = false;
                        if (type == 1) {
                            aBoolean = AbilityUtil.supportGetNvrStorageInfoReq((Integer)dType, (String)string) != false || dType == 20;
                        } else if (type == 2) {
                            aBoolean = dType == 22;
                        } else {
                            String thirdpartDevId = item.getThirdpartDevId();
                            if (lcMacMap.get(thirdpartDevId) == null && (dType == 64 || dType == 62)) {
                                aBoolean = true;
                                lcMacMap.put(thirdpartDevId, 1);
                            }
                        }
                        if (!aBoolean) continue;
                        devList.add(item);
                        if (type != 1) continue;
                        macAndDevMap.put(item.getMac(), item);
                    }
                    total = devList.size();
                    needResList = type != 1 ? ListUtil.subList(devList, (Integer)pageNum, (Integer)pageSize) : devList;
                    if (Util.isEmpty(needResList)) {
                        return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)total);
                    }
                    if (type != 1) break block68;
                    Dms1DiskByMaclistReq req = new Dms1DiskByMaclistReq();
                    ArrayList arrayList = new ArrayList();
                    if (diskNum != null) {
                        devList.forEach(d -> macList.add(d.getMac()));
                        req.setUsenum(diskNum);
                        req.setMac(arrayList);
                        Util.log.info("dms_disk_by_maclist request: " + JSONAccessor.impl().format((Object)req));
                        MmsRsp listMmsRsp = this.dmsSumFeign.dms1DiskByMaclist(req);
                        Util.log.info("dms_disk_by_maclist response: " + JSONAccessor.impl().format((Object)listMmsRsp));
                        Util.log.info("got all disk info from dms");
                        data = (List)listMmsRsp.getData();
                        if (Util.isEmpty((Collection)data)) {
                            total = 0;
                            return PageModel.empty((long)pageNum.intValue(), (int)pageSize, (long)total);
                        }
                        data.sort(Comparator.comparing(Dms1DiskByMaclistRes::getMac));
                        Map<String, Dms1DiskByMaclistRes> resMap = data.stream().collect(Collectors.toMap(Dms1DiskByMaclistRes::getMac, v -> v));
                        if (status == null) {
                            total = data.size();
                            List dms1DiskByMaclistResList = ListUtil.subList((List)data, (Integer)pageNum, (Integer)pageSize);
                            ArrayList<DiskStatusNewV2Vo> diskStatusNewV2VoList = new ArrayList<DiskStatusNewV2Vo>(resMap.size());
                            for (Dms1DiskByMaclistRes item : dms1DiskByMaclistResList) {
                                DeviceStatus deviceStatus = (DeviceStatus)macAndDevMap.get(item.getMac());
                                String depName = userDepNameMap.get(deviceStatus.getDepId());
                                DiskStatusNewV2Vo vo = this.diskStatusNewV2Vo(type, deviceStatus, depName, resMap, startDateTime, endDateTime);
                                diskStatusNewV2VoList.add(vo);
                            }
                            resList.addAll(diskStatusNewV2VoList);
                        } else {
                            ArrayList<DiskStatusNewV2Vo> diskStatusNewV2VoList = new ArrayList<DiskStatusNewV2Vo>(resMap.size());
                            for (Dms1DiskByMaclistRes dms1DiskByMaclistRes : data) {
                                DeviceStatus deviceStatus = (DeviceStatus)macAndDevMap.get(dms1DiskByMaclistRes.getMac());
                                String depName = userDepNameMap.get(deviceStatus.getDepId());
                                DiskStatusNewV2Vo vo = this.diskStatusNewV2Vo(type, deviceStatus, depName, resMap, startDateTime, endDateTime);
                                diskStatusNewV2VoList.add(vo);
                            }
                            ArrayList<Integer> diskStatusList = new ArrayList<Integer>();
                            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(-1)) == 0) {
                                diskStatusList.add(-1);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) == 0) {
                                diskStatusList.add(0);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(2)) == 0) {
                                diskStatusList.add(1);
                                diskStatusList.add(2);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(3)) == 0) {
                                diskStatusList.add(3);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(4)) == 0) {
                                diskStatusList.add(4);
                            }
                            boolean bl = Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) == 0;
                            boolean matchPart = Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) != 0;
                            Iterator iterator = diskStatusNewV2VoList.iterator();
                            while (iterator.hasNext()) {
                                DiskStatusNewV2Vo diskStatusNewV2Vo = (DiskStatusNewV2Vo)iterator.next();
                                boolean partPassed = false;
                                boolean allPassed = !diskStatusNewV2Vo.getDiskTimeStatusList().isEmpty();
                                for (Map.Entry<Integer, List<DiskTimeStatus>> entry : diskStatusNewV2Vo.getDiskTimeStatusList().entrySet()) {
                                    List<DiskTimeStatus> statusList = entry.getValue();
                                    allPassed = allPassed && !statusList.isEmpty();
                                    for (DiskTimeStatus diskTimeStatus : statusList) {
                                        if (bl) {
                                            boolean bl2 = allPassed = allPassed && diskStatusList.contains(diskTimeStatus.getStatus());
                                        }
                                        if (!matchPart) continue;
                                        partPassed = partPassed || diskStatusList.contains(diskTimeStatus.getStatus());
                                    }
                                }
                                boolean ok = bl && allPassed || matchPart && partPassed;
                                if (ok) continue;
                                iterator.remove();
                            }
                            total = diskStatusNewV2VoList.size();
                            resList.addAll(ListUtil.subList(diskStatusNewV2VoList, (Integer)pageNum, (Integer)pageSize));
                        }
                    } else {
                        HashMap<String, Dms1DiskByMaclistRes> resMap;
                        needResList.forEach(v -> macList.add(v.getMac()));
                        req.setUsenum(Integer.valueOf(-1));
                        req.setMac(arrayList);
                        Util.log.info("dms_disk_by_maclist request: " + JSONAccessor.impl().format((Object)req));
                        MmsRsp listMmsRsp = this.dmsSumFeign.dms1DiskByMaclist(req);
                        Util.log.info("dms_disk_by_maclist response: " + JSONAccessor.impl().format((Object)listMmsRsp));
                        Util.log.info("got all disk info from dms");
                        data = (List)listMmsRsp.getData();
                        Map<String, Dms1DiskByMaclistRes> map = resMap = Util.isEmpty((Collection)data) ? new HashMap<String, Dms1DiskByMaclistRes>() : data.stream().collect(Collectors.toMap(Dms1DiskByMaclistRes::getMac, v -> v));
                        if (status == null) {
                            total = needResList.size();
                            ArrayList<DiskStatusNewV2Vo> diskStatusNewV2VoList = new ArrayList<DiskStatusNewV2Vo>(resMap.size());
                            List deviceStatusList = ListUtil.subList(needResList, (Integer)pageNum, (Integer)pageSize);
                            for (DeviceStatus deviceStatus : deviceStatusList) {
                                String depName = userDepNameMap.get(deviceStatus.getDepId());
                                DiskStatusNewV2Vo vo = this.diskStatusNewV2Vo(type, deviceStatus, depName, resMap, startDateTime, endDateTime);
                                diskStatusNewV2VoList.add(vo);
                            }
                            resList.addAll(diskStatusNewV2VoList);
                        } else {
                            ArrayList<DiskStatusNewV2Vo> diskStatusNewV2VoList = new ArrayList<DiskStatusNewV2Vo>(resMap.size());
                            for (DeviceStatus deviceStatus : needResList) {
                                String depName = userDepNameMap.get(deviceStatus.getDepId());
                                DiskStatusNewV2Vo vo = this.diskStatusNewV2Vo(type, deviceStatus, depName, resMap, startDateTime, endDateTime);
                                diskStatusNewV2VoList.add(vo);
                            }
                            ArrayList<Integer> diskStatusList = new ArrayList<Integer>();
                            if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(-1)) == 0) {
                                diskStatusList.add(-1);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) == 0) {
                                diskStatusList.add(0);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(2)) == 0) {
                                diskStatusList.add(1);
                                diskStatusList.add(2);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(3)) == 0) {
                                diskStatusList.add(3);
                            } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(4)) == 0) {
                                diskStatusList.add(4);
                            }
                            boolean bl = Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) == 0;
                            boolean matchPart = Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) != 0;
                            Iterator iterator = diskStatusNewV2VoList.iterator();
                            while (iterator.hasNext()) {
                                DiskStatusNewV2Vo diskStatusNewV2Vo = (DiskStatusNewV2Vo)iterator.next();
                                boolean partPassed = false;
                                boolean allPassed = !diskStatusNewV2Vo.getDiskTimeStatusList().isEmpty();
                                for (Map.Entry<Integer, List<DiskTimeStatus>> entry : diskStatusNewV2Vo.getDiskTimeStatusList().entrySet()) {
                                    List<DiskTimeStatus> statusList = entry.getValue();
                                    allPassed = allPassed && !statusList.isEmpty();
                                    for (DiskTimeStatus diskTimeStatus : statusList) {
                                        if (bl) {
                                            boolean bl3 = allPassed = allPassed && diskStatusList.contains(diskTimeStatus.getStatus());
                                        }
                                        if (!matchPart) continue;
                                        partPassed = partPassed || diskStatusList.contains(diskTimeStatus.getStatus());
                                    }
                                }
                                boolean ok = bl && allPassed || matchPart && partPassed;
                                if (ok) continue;
                                iterator.remove();
                            }
                            total = diskStatusNewV2VoList.size();
                            resList.addAll(ListUtil.subList(diskStatusNewV2VoList, (Integer)pageNum, (Integer)pageSize));
                        }
                    }
                    break block69;
                }
                if (type != 2) break block70;
                ArrayList<Object> seachDevList = devList;
                if (status != null) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(0)) == 0) {
                        arrayList.add(-1);
                    } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(1)) == 0) {
                        arrayList.add(3);
                        arrayList.add(2);
                    } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(2)) == 0) {
                        arrayList.add(1);
                    } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(3)) == 0) {
                        arrayList.add(4);
                    } else if (Util.compare2((Comparable)status, (Comparable)Integer.valueOf(4)) == 0) {
                        arrayList.add(0);
                    }
                    seachDevList = new ArrayList();
                    List<Integer> deviceStatusIds = devList.stream().map(DeviceStatus::getId).toList();
                    LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DiskStatusHistory::getDeviceStatusId, deviceStatusIds)).ge(DiskStatusHistory::getCreateAt, (Object)startDateTime.toLocalDate())).le(DiskStatusHistory::getCreateAt, (Object)endDateTime.toLocalDate())).in(DiskStatusHistory::getStatus, arrayList);
                    List diskStatusHistoryList = this.diskStatusHistoryMapper.selectList((Wrapper)queryWrapper);
                    block11: for (Object deviceStatus : devList) {
                        for (DiskStatusHistory diskStatusHistory : diskStatusHistoryList) {
                            if (!diskStatusHistory.getDeviceStatusId().equals(((DeviceStatus)deviceStatus).getId())) continue;
                            seachDevList.add(deviceStatus);
                            continue block11;
                        }
                    }
                }
                total = seachDevList.size();
                List list = ListUtil.subList(seachDevList, (Integer)pageNum, (Integer)pageSize);
                Dms1DiskByMaclistReq req = new Dms1DiskByMaclistReq();
                ArrayList macList = new ArrayList();
                list.forEach(d -> macList.add(d.getMac()));
                req.setUsenum(Integer.valueOf(-1));
                req.setMac(macList);
                Util.log.info("dms_disk_by_maclist request: " + JSONAccessor.impl().format((Object)req));
                MmsRsp listMmsRsp = this.dmsSumFeign.dms1DiskByMaclist(req);
                Util.log.info("dms_disk_by_maclist response: " + JSONAccessor.impl().format((Object)listMmsRsp));
                Map<String, Dms1DiskByMaclistRes> resMap = listMmsRsp == null || listMmsRsp.getData() == null ? Map.of() : ((List)listMmsRsp.getData()).stream().collect(Collectors.toMap(Dms1DiskByMaclistRes::getMac, v -> v));
                for (DeviceStatus deviceStatus : list) {
                    String depName = userDepNameMap.get(deviceStatus.getDepId());
                    DiskStatusNewV2Vo vo = this.diskStatusNewV2Vo(type, deviceStatus, depName, resMap, startDateTime, endDateTime);
                    resList.add(vo);
                }
                break block69;
            }
            if (type != 3) break block69;
            for (DeviceStatus deviceStatus : needResList) {
                DiskStatusNewV2Vo vo = new DiskStatusNewV2Vo();
                vo.setDepName(userDepNameMap.get(deviceStatus.getDepId()));
                vo.setDepId(deviceStatus.getDepId());
                Long sumTotalSpace = null;
                Long sumUseSpace = null;
                ArrayList<Integer> typeList = new ArrayList<Integer>();
                typeList.add(3);
                typeList.add(4);
                if (deviceStatus.getDType() != 64 && deviceStatus.getDType() != 62) continue;
                vo.setMac(deviceStatus.getThirdpartDevId());
                vo.setTotalDisksNum(1);
                vo.setUseDisksNum(1);
                vo.setFreeDisksNum(0);
                ArrayList<DisksListBeanVo> disksList = new ArrayList<DisksListBeanVo>();
                DeviceStorage deviceStorage = (DeviceStorage)this.deviceStorageMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStorage::getSerialNumber, (Object)deviceStatus.getThirdpartDevId())).in(DeviceStorage::getType, typeList));
                if (deviceStorage != null) {
                    DisksListBeanVo disksListBeanVo = new DisksListBeanVo();
                    disksListBeanVo.setIndexNum(0);
                    sumTotalSpace = deviceStorage.getTotalCapacity();
                    sumUseSpace = deviceStorage.getTotalCapacity() == null ? null : Long.valueOf(deviceStorage.getTotalCapacity() - deviceStorage.getFreeCapacity());
                    disksListBeanVo.setStatus(deviceStorage.getDisStatus());
                    disksListBeanVo.setTotalSpaceFormat(deviceStorage.getTotalCapacity() == null ? "-" : Util.ByteSizeUnit.G.format(deviceStorage.getTotalCapacity().longValue(), Util.ByteSizeUnit.M, 2));
                    disksListBeanVo.setUseSpaceFormat(sumUseSpace == null ? "-" : Util.ByteSizeUnit.G.format(sumUseSpace.longValue(), Util.ByteSizeUnit.M, 2));
                    disksListBeanVo.setFreeSpaceFormat(deviceStorage.getFreeCapacity() == null ? "-" : Util.ByteSizeUnit.G.format(deviceStorage.getFreeCapacity().longValue(), Util.ByteSizeUnit.M, 2));
                    disksListBeanVo.setTotalSpace(deviceStorage.getTotalCapacity());
                    disksListBeanVo.setUseSpace(sumUseSpace);
                    disksListBeanVo.setFreeSpace(deviceStorage.getFreeCapacity());
                    disksList.add(disksListBeanVo);
                }
                vo.setTotalSpace(sumTotalSpace);
                vo.setUseSpace(sumUseSpace);
                vo.setTotalSpaceFormat(sumTotalSpace == null ? "-" : Util.ByteSizeUnit.G.format(sumTotalSpace.longValue(), Util.ByteSizeUnit.M, 2));
                vo.setUseSpaceFormat(sumUseSpace == null ? "-" : Util.ByteSizeUnit.G.format(sumUseSpace.longValue(), Util.ByteSizeUnit.M, 2));
                vo.setDisksList(disksList);
                Map<Integer, List<DiskTimeStatus>> listMap = this.deviceDiskService.diskNumStatus(startDateTime, endDateTime, type, null, deviceStatus.getThirdpartDevId(), 1, deviceStatus.getDepId());
                vo.setDiskTimeStatusList(listMap);
                HashMap<Integer, LinkedList<Integer>> statusListMap = new HashMap<Integer, LinkedList<Integer>>();
                for (Map.Entry<Integer, List<DiskTimeStatus>> entry : listMap.entrySet()) {
                    Integer key = entry.getKey();
                    for (DiskTimeStatus diskTimeStatus : entry.getValue()) {
                        statusListMap.computeIfAbsent(key, k -> new LinkedList()).add(diskTimeStatus.getStatus());
                    }
                }
                vo.setHistoryStatusMap(statusListMap);
                vo.setHistoryStatusMap(statusListMap);
                if (deviceStatus.getDType() == 64) {
                    vo.setDeviceType(3);
                }
                if (deviceStatus.getDType() == 62) {
                    vo.setDeviceType(4);
                }
                resList.add(vo);
            }
        }
        return PageModel.from((long)pageNum.intValue(), (int)pageSize, (long)total, resList);
    }

    private DiskStatusNewV2Vo diskStatusNewV2Vo(Integer type, DeviceStatus deviceStatus, String depName, Map<String, Dms1DiskByMaclistRes> resMap, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        DiskStatusNewV2Vo vo = new DiskStatusNewV2Vo();
        vo.setDepName(depName);
        vo.setDepId(deviceStatus.getDepId());
        vo.setDeviceStatusId(deviceStatus.getId());
        vo.setDeviceStatusName(deviceStatus.getDeviceName());
        vo.setMac(deviceStatus.getMac());
        if (type == 1 || type == 2) {
            vo.setDeviceType(type);
        } else {
            if (deviceStatus.getDType() == 64) {
                vo.setDeviceType(3);
            }
            if (deviceStatus.getDType() == 62) {
                vo.setDeviceType(4);
            }
        }
        Dms1DiskByMaclistRes dms1DiskByMaclistRes = resMap.get(deviceStatus.getMac());
        if (dms1DiskByMaclistRes != null) {
            vo.setTotalDisksNum(dms1DiskByMaclistRes.getTotalDisksNum());
            vo.setUseDisksNum(dms1DiskByMaclistRes.getUseDisksNum());
            vo.setFreeDisksNum(dms1DiskByMaclistRes.getFreeDisksNum());
            List disksList = dms1DiskByMaclistRes.getDisksList();
            Long sumTotalSpace = 0L;
            Long sumUseSpace = 0L;
            ArrayList<DisksListBeanVo> disksListBeanVoList = new ArrayList<DisksListBeanVo>();
            if (Util.isNotEmpty((Collection)disksList)) {
                boolean hasNum = false;
                for (Dms1DiskByMaclistRes.DisksListBean disksListBean : disksList) {
                    DisksListBeanVo disksListBeanVo = new DisksListBeanVo();
                    BeanUtils.copyProperties((Object)disksListBean, (Object)((Object)disksListBeanVo));
                    disksListBeanVo.setTotalSpaceFormat(disksListBean.getTotalSpace() == null ? "-" : Util.ByteSizeUnit.T.format(disksListBean.getTotalSpace().longValue(), Util.ByteSizeUnit.M, 2));
                    disksListBeanVo.setUseSpaceFormat(disksListBean.getUseSpace() == null ? "-" : Util.ByteSizeUnit.T.format(disksListBean.getUseSpace().longValue(), Util.ByteSizeUnit.M, 2));
                    disksListBeanVo.setFreeSpaceFormat(disksListBean.getFreeSpace() == null ? "-" : Util.ByteSizeUnit.T.format(disksListBean.getFreeSpace().longValue(), Util.ByteSizeUnit.M, 2));
                    disksListBeanVoList.add(disksListBeanVo);
                    sumTotalSpace = sumTotalSpace + (Long)Util.convert2Self((Object)disksListBean.getTotalSpace(), (Object)0L);
                    sumUseSpace = sumUseSpace + (Long)Util.convert2Self((Object)disksListBean.getUseSpace(), (Object)0L);
                    hasNum = hasNum || disksListBean.getTotalSpace() != null || disksListBean.getUseSpace() != null;
                }
                vo.setTotalSpace(sumTotalSpace);
                vo.setUseSpace(sumUseSpace);
                vo.setTotalSpaceFormat(hasNum ? (type == 1 ? Util.ByteSizeUnit.T.format(sumTotalSpace.longValue(), Util.ByteSizeUnit.M, 2) : Util.ByteSizeUnit.G.format(sumTotalSpace.longValue(), Util.ByteSizeUnit.M, 2)) : "-");
                vo.setUseSpaceFormat(hasNum ? (type == 1 ? Util.ByteSizeUnit.T.format(sumUseSpace.longValue(), Util.ByteSizeUnit.M, 2) : Util.ByteSizeUnit.G.format(sumUseSpace.longValue(), Util.ByteSizeUnit.M, 2)) : "-");
            }
            vo.setDisksList(disksListBeanVoList);
        }
        Map<Integer, List<DiskTimeStatus>> listMap = this.deviceDiskService.diskNumStatus(startDateTime, endDateTime, type, deviceStatus.getId(), deviceStatus.getThirdpartDevId(), type == 1 ? (Integer)Util.convert2Self((Object)vo.getTotalDisksNum(), (Object)4) : Integer.valueOf(1), deviceStatus.getDepId());
        vo.setDiskTimeStatusList(listMap);
        HashMap<Integer, LinkedList<Integer>> statusListMap = new HashMap<Integer, LinkedList<Integer>>();
        for (Map.Entry<Integer, List<DiskTimeStatus>> entry : listMap.entrySet()) {
            DiskTimeStatus diskTimeStatus;
            Integer key = entry.getKey();
            Iterator<Object> iterator = entry.getValue().iterator();
            while (iterator.hasNext() && !(diskTimeStatus = (DiskTimeStatus)iterator.next()).isMiss()) {
                statusListMap.computeIfAbsent(key, k -> new LinkedList()).add(diskTimeStatus.getStatus());
            }
        }
        vo.setHistoryStatusMap(statusListMap);
        return vo;
    }

    @Override
    public List<DiskErrDeviceVo> getDiskErrDeviceVo(Integer userId, Integer groupId) {
        List userDepIds = this.userDepartmentPrivilegeFacade.getUserDepIds(userId, groupId);
        List<DeviceStatus> userDeviceStatus = this.deviceReportService.getUserDeviceStatus(userId, groupId, userDepIds);
        return null;
    }
}

