/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportpfconfig;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.platform.mysql.PlatformsMapper;
import com.ovopark.device.modules.reportpfconfig.ReportDeviceConfigService;
import com.ovopark.device.modules.reportpfconfig.devicereport.DeviceFlowReidConfigReportAcl;
import com.ovopark.device.modules.reportpfconfig.vo.DeviceFlowReidConfigReportInParamMo;
import com.ovopark.device.modules.reportpfconfig.vo.DeviceFlowReidConfigReportOutParamVo;
import com.ovopark.device.platform.api.UserDepartmentPrivilegeFacade;
import com.ovopark.device.platform.api.UserRoleFacade;
import com.ovopark.device.platform.api.UsersFacade;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import jakarta.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

@Service(value="reportDeviceConfig")
public class ReportDeviceConfigServiceImpl
implements ReportDeviceConfigService {
    private static final Logger log = LoggerFactory.getLogger(ReportDeviceConfigServiceImpl.class);
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    private PlatformsMapper platformsMapper;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Resource(name="deviceStringRedisTemplate")
    private StringRedisTemplate deviceRedisTemplate;
    @Resource
    private UsersFacade usersService;
    @Resource
    private UserRoleFacade userRoleService;
    @Resource
    private UserDepartmentPrivilegeFacade userDepartmentPrivilegeService;

    @Override
    public BaseResult getDeviceFlowReidConfigReport(DeviceFlowReidConfigReportInParamMo inParam, Integer groupId, Integer userId) {
        Page page = new Page((long)inParam.getPageNumber().intValue(), (long)inParam.getPageSize().intValue());
        String param = "getDeviceFlowReidConfigReport {%s, %s, %s}".formatted(JSONObject.toJSON((Object)inParam), groupId, userId);
        String redisKey = DigestUtils.md5DigestAsHex((byte[])param.getBytes(StandardCharsets.UTF_8));
        String string = (String)this.deviceRedisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            try {
                page = (Page)JSONObject.parseObject((String)string, Page.class);
                return BaseResult.success((Object)page);
            }
            catch (Exception e) {
                log.error("getDeviceFlowReidConfigReportRedisConvert error: {}", (Throwable)e);
                return BaseResult.success((Object)page);
            }
        }
        List<DepartmentOrgMo> depIdsByOrganizeIds = this.getDepIdsByOrganizeIds(groupId, inParam.getOrganizeIds(), userId);
        if (CollectionUtils.isEmpty(depIdsByOrganizeIds)) {
            return BaseResult.success((Object)page);
        }
        List<Integer> depIds = depIdsByOrganizeIds.stream().map(DepartmentOrgMo::getDepId).collect(Collectors.toList());
        List<DeviceStatus> deviceStatuses = this.getDeviceFlowReidConfigReportDeviceList(depIds, inParam);
        if (CollectionUtils.isEmpty(deviceStatuses)) {
            return BaseResult.success((Object)page);
        }
        List<DeviceStatus> deviceStatusList = deviceStatuses.stream().filter(a -> a.getDType() != null && 52 == a.getDType() && a.getExtendCapacity().charAt(34) == '1' || a.getDType() != null && a.getDType() == 20 && a.getExtendCapacity().length() > 64 && a.getExtendCapacity().charAt(63) == '1').collect(Collectors.toList());
        if (CollectionUtils.isEmpty(deviceStatusList)) {
            return BaseResult.success((Object)page);
        }
        List<Integer> getPlatformIds = deviceStatusList.stream().map(DeviceStatus::getPlatformId).collect(Collectors.toList());
        Map<Integer, Platforms> integerPlatformsMap = this.getDeviceFlowReidConfigReportPlatformsList(getPlatformIds);
        List<DeviceFlowReidConfigReportOutParamVo> vos = new ArrayList<DeviceFlowReidConfigReportOutParamVo>();
        Map<Integer, DepartmentOrgMo> collect = depIdsByOrganizeIds.stream().collect(Collectors.toMap(DepartmentOrgMo::getDepId, Function.identity()));
        vos = this.processDeviceFlowReidConfigReport(deviceStatusList, integerPlatformsMap, vos, collect, inParam);
        List rankVos = ListUtil.page((int)(inParam.getPageNumber() - 1), (int)inParam.getPageSize(), vos);
        page.setRecords(rankVos);
        page.setTotal((long)vos.size());
        this.deviceRedisTemplate.opsForValue().set((Object)redisKey, (Object)JSONObject.toJSONString((Object)page), 30L, TimeUnit.MINUTES);
        return BaseResult.success((Object)page);
    }

    private Map<Integer, Platforms> getDeviceFlowReidConfigReportPlatformsList(List<Integer> getPlatformIds) {
        Map integerPlatformsMap = null;
        if (!CollectionUtils.isEmpty(getPlatformIds)) {
            List platformsList = this.platformsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Platforms::getId, Platforms::getUpgradeServer, Platforms::getUpgradePort}).in(Platforms::getId, getPlatformIds)).eq(Platforms::getIsDel, (Object)0));
            integerPlatformsMap = platformsList.stream().collect(Collectors.toMap(Platforms::getId, Function.identity()));
        }
        return integerPlatformsMap;
    }

    private List<DeviceStatus> getDeviceFlowReidConfigReportDeviceList(List<Integer> depIds, DeviceFlowReidConfigReportInParamMo inParam) {
        if (CollectionUtils.isEmpty(depIds)) {
            return new ArrayList<DeviceStatus>();
        }
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{DeviceStatus::getDeviceName, DeviceStatus::getExtendCapacity, DeviceStatus::getMac, DeviceStatus::getDeviceType, DeviceStatus::getPlatformId, DeviceStatus::getDepId, DeviceStatus::getDType}).in(DeviceStatus::getDepId, depIds);
        if (StringUtils.isNotEmpty((CharSequence)inParam.getDeviceTypes())) {
            eq.in(DeviceStatus::getDeviceType, Arrays.asList(inParam.getDeviceTypes().split(",")));
        }
        List deviceStatuses = this.deviceStatusMapper.selectList((Wrapper)eq.eq(DeviceStatus::getIsDelete, (Object)0));
        return deviceStatuses;
    }

    private List<DeviceFlowReidConfigReportOutParamVo> processDeviceFlowReidConfigReport(List<DeviceStatus> deviceStatusList, Map<Integer, Platforms> integerPlatformsMap, List<DeviceFlowReidConfigReportOutParamVo> vos, Map<Integer, DepartmentOrgMo> departmentOrgMoMap, DeviceFlowReidConfigReportInParamMo inParam) {
        for (DeviceStatus deviceStatus : deviceStatusList) {
            String getEmployeeTrackThreshold;
            String deviceType = deviceStatus.getDeviceType();
            if (!StringUtils.equals((CharSequence)"PC8-C", (CharSequence)deviceType) && !StringUtils.equalsIgnoreCase((CharSequence)"PC8-C Plus", (CharSequence)deviceType) && !StringUtils.equalsIgnoreCase((CharSequence)"PC8-C Plus Ver.B", (CharSequence)deviceType) && !StringUtils.equalsIgnoreCase((CharSequence)"PC8-C Plus(W)", (CharSequence)deviceType) && !StringUtils.equalsIgnoreCase((CharSequence)"Dolphin1-A", (CharSequence)deviceType) && !StringUtils.equalsIgnoreCase((CharSequence)"Dolphin1-A Pro", (CharSequence)deviceType) && !StringUtils.equalsIgnoreCase((CharSequence)"Dolphin1-A-16CH", (CharSequence)deviceType) && !StringUtils.equalsIgnoreCase((CharSequence)"Dolphin1-A-32CH", (CharSequence)deviceType) || integerPlatformsMap == null || !integerPlatformsMap.containsKey(deviceStatus.getPlatformId()) || integerPlatformsMap.get(deviceStatus.getPlatformId()) == null || integerPlatformsMap.get(deviceStatus.getPlatformId()).getUpgradeServer() == null || integerPlatformsMap.get(deviceStatus.getPlatformId()).getUpgradePort() == null) continue;
            DeviceFlowReidConfigReportAcl.PlatformReidConfigOutParam data = DeviceFlowReidConfigReportAcl.getDeviceFlowReidConfigReport(new DeviceFlowReidConfigReportAcl.PlatformReidConfigInParam(integerPlatformsMap.get(deviceStatus.getPlatformId()).getUpgradeServer(), integerPlatformsMap.get(deviceStatus.getPlatformId()).getUpgradePort(), deviceStatus.getMac(), deviceType));
            String string = data == null ? "--" : (getEmployeeTrackThreshold = data.getEmployeeTrackThreshold() == null ? "--" : "" + data.getEmployeeTrackThreshold());
            String getEmployeeTimeThreshold = data == null ? "--" : (data.getEmployeeTimeThreshold() == null ? "-- min" : data.getEmployeeTimeThreshold() / 60000 + "min");
            DeviceFlowReidConfigReportOutParamVo deviceFlowReidConfigReportOutParamVo = new DeviceFlowReidConfigReportOutParamVo.Builder().depName(departmentOrgMoMap != null && departmentOrgMoMap.get(deviceStatus.getDepId()) != null ? departmentOrgMoMap.get(deviceStatus.getDepId()).getName() : "").deviceName(deviceStatus.getDeviceName()).deviceType(deviceStatus.getDeviceType()).mac(deviceStatus.getMac()).allDayMerging((String)(data == null ? "-" : data.getDayReidEndHour() + ":" + data.getDayReidEndMinute())).enableStorePasserbyStr(data == null ? "-" : (data.getEnableStorePasserby() != false ? "\u53bb\u91cd" : "\u4e0d\u53bb\u91cd")).employeeCompareLevelStr((String)(data == null ? "-" : "" + data.getEmployeeCompareLevel())).employeeTimeMarkEnable(data == null ? false : data.getEmployeeTimeMarkEnable()).employeeTimeMarkTime((String)(data == null ? "-" : (data != null && data.getEmployeeTimeMarkEnable() == false ? "\u672a\u5f00\u542f" : String.valueOf(data.getEmployeeBeginHour() > 10 ? data.getEmployeeBeginHour() : "0" + data.getEmployeeBeginHour()) + ":" + String.valueOf(data.getEmployeeBeginMinute() > 10 ? data.getEmployeeBeginMinute() : "0" + data.getEmployeeBeginMinute()) + "-" + String.valueOf(data.getEmployeeEndHour() > 10 ? data.getEmployeeEndHour() : "0" + data.getEmployeeEndHour()) + ":" + String.valueOf(data.getEmployeeEndMinute() > 10 ? data.getEmployeeEndMinute() : "0" + data.getEmployeeEndMinute())))).employeeTrackTimeThresholdStr((String)(data == null ? "--" : getEmployeeTrackThreshold + ";" + getEmployeeTimeThreshold)).build();
            vos.add(deviceFlowReidConfigReportOutParamVo);
        }
        vos = this.processDeviceFlowReidConfigReportSort(vos, inParam.getSort());
        return vos;
    }

    private List<DeviceFlowReidConfigReportOutParamVo> processDeviceFlowReidConfigReportSort(List<DeviceFlowReidConfigReportOutParamVo> vos, Integer sort) {
        switch (sort) {
            case 1: {
                vos.sort((a, b) -> a.getEnableStorePasserbyStr().compareTo(b.getEnableStorePasserbyStr()));
                break;
            }
            case 2: {
                vos.sort((a, b) -> b.getEnableStorePasserbyStr().compareTo(a.getEnableStorePasserbyStr()));
                break;
            }
            case 3: {
                vos.sort((a, b) -> a.getEmployeeCompareLevelStr().compareTo(b.getEmployeeCompareLevelStr()));
                break;
            }
            case 4: {
                vos.sort((a, b) -> b.getEmployeeCompareLevelStr().compareTo(a.getEmployeeCompareLevelStr()));
            }
        }
        return vos;
    }

    private List<DepartmentOrgMo> getDepIdsByOrganizeIds(Integer groupId, String organizeIds, Integer userId) {
        try {
            DepIdsAndUserMo mo = new DepIdsAndUserMo();
            if (StringUtils.isNotEmpty((CharSequence)organizeIds)) {
                mo.setOrganizeIdList(Arrays.asList(organizeIds.split(",")));
            }
            mo.setUserGroupId(groupId);
            mo.setUserId(userId);
            com.ovopark.organize.common.base.BaseResult userPrivilegeDepByOrganizeIds = this.userDepPrivilegeApi.getUserPrivilegeDepByOrganizeIds(mo);
            if (!userPrivilegeDepByOrganizeIds.getIsError().booleanValue()) {
                return (List)userPrivilegeDepByOrganizeIds.getData();
            }
        }
        catch (Exception e) {
            log.error("getDeviceFlowReidConfigReport", (Throwable)e);
        }
        return new ArrayList<DepartmentOrgMo>();
    }
}

