/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.tagmgr.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.platform.RedisLock;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.modules.platform.mysql.DevicesMapper;
import com.ovopark.device.modules.tagmgr.model.TagChanged;
import com.ovopark.device.modules.tagmgr.model.TagOpeResult;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTag;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagCnfMapper;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagCnfVo;
import com.ovopark.device.modules.tagmgr.mysql.DeviceTagMapper;
import com.ovopark.device.modules.tagmgr.service.DeviceTagService;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class DeviceTagAssignJob {
    private static final Logger log = LoggerFactory.getLogger(DeviceTagAssignJob.class);
    @Autowired
    private DeviceTagMapper deviceTagMapper;
    @Autowired
    private DeviceTagCnfMapper deviceTagCnfMapper;
    @Autowired
    private DevicesMapper devicesMapper;
    @Autowired
    private DeviceTagService deviceTagService;
    @Autowired
    @Qualifier(value="kafkaMainTemplate")
    private KafkaTemplate kafkaTemplate;
    @Autowired
    private RedisLock redisLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign() {
        List deviceTagList = this.deviceTagMapper.selectList((Wrapper)new LambdaQueryWrapper(DeviceTag.class).eq(DeviceTag::getDelFlag, (Object)0));
        Map<Integer, List<DeviceTag>> listMap = deviceTagList.stream().collect(Collectors.groupingBy(DeviceTag::getGroupId));
        for (Map.Entry<Integer, List<DeviceTag>> entry : listMap.entrySet()) {
            Integer groupId = entry.getKey();
            DeviceTagCnfVo tagCnf = (DeviceTagCnfVo)this.deviceTagCnfMapper.selectById(groupId);
            if (tagCnf == null || Util.compare2((Comparable)tagCnf.getAutoFlag(), (Comparable)Integer.valueOf(0)) == 0) {
                log.info("autoFlag is closed: " + groupId);
                continue;
            }
            List<DeviceTag> tagList = entry.getValue();
            List devicesList = this.devicesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Devices.class).eq(Devices::getGroupId, (Object)groupId)).eq(Devices::getIsDelete, (Object)0));
            String lockKey = "deviceTagPut:lock:" + groupId;
            String requestId = UUID.randomUUID().toString();
            try {
                boolean locked = this.redisLock.tryLock(lockKey, requestId, 30L, TimeUnit.SECONDS);
                if (!locked) continue;
                TagOpeResult tagOpeResult = this.deviceTagService.assign(groupId, null, tagList, devicesList);
                DeviceTagAssignJob.send2Kafka0(this.kafkaTemplate, tagOpeResult.getChangedSet(), new HashSet<Integer>());
            }
            finally {
                this.redisLock.releaseLock(lockKey, requestId);
            }
        }
    }

    public static void send2Kafka0(KafkaTemplate kafkaTemplate, Set<Integer> updated, Set<Integer> deleted) {
        ProducerRecord record;
        String data;
        TagChanged tagChanged;
        for (Integer t : deleted) {
            if (t == null) continue;
            tagChanged = new TagChanged();
            tagChanged.setType(2);
            tagChanged.setDeviceTag(t);
            data = JSONAccessor.impl().format((Object)tagChanged);
            record = new ProducerRecord("device-tag-ref-changed", null, (Object)data);
            kafkaTemplate.send(record);
        }
        for (Integer t : updated) {
            if (t == null) continue;
            tagChanged = new TagChanged();
            tagChanged.setType(1);
            tagChanged.setDeviceTag(t);
            data = JSONAccessor.impl().format((Object)tagChanged);
            record = new ProducerRecord("device-tag-ref-changed", null, (Object)data);
            kafkaTemplate.send(record);
        }
    }
}

