/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.cloud.api.DeviceApi;
import com.ovopark.device.cloud.api.DeviceStatusApi;
import com.ovopark.device.cloud.common.model.mo.DevicesOnlineMo;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.model.OnOffVo;
import com.ovopark.device.platform.utils.BatchConcurrentProcessor;
import com.ovopark.device.sdk.api.TempEzvizApi;
import com.ovopark.device.sdk.common.model.mo.GetEzvizDeviceOnlineMapFeignMo;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.ovopark.device.modules.platform.OnlineFacadeRPC")
public class OnlineFacadeRPC
implements OnlineFacade {
    private static final Logger log = LoggerFactory.getLogger(OnlineFacadeRPC.class);
    public static final String BEAN_NAME = "com.ovopark.device.modules.platform.OnlineFacadeRPC";
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final int TIMEOUT_SECONDS = 30;
    @Resource
    private DeviceStatusApi deviceStatusApi;
    @Resource
    private DeviceApi deviceApi;
    @Autowired
    private TempEzvizApi tempEzvizApi;

    public Map<Integer, Integer> onOffRT(List<Integer> deviceStatusIdList) {
        return BatchConcurrentProcessor.processBatchConcurrentlyGeneric(deviceStatusIdList, (String)"onOffRT", (int)5000, (int)30, (Logger)log, batch -> {
            com.ovopark.device.common.response.BaseResult result = this.deviceStatusApi.getDmsOnlineMap(batch);
            return result != null && result.getIsError() == false && result.getData() != null ? (Map)result.getData() : new HashMap();
        });
    }

    public Map<Integer, Integer> onOffNRT(List<Integer> deviceStatusIdList) {
        return this.onOffRT(deviceStatusIdList);
    }

    public Map<Integer, OnOffVo> onOffTimeRT(List<Integer> deviceStatusIdList) {
        return BatchConcurrentProcessor.processBatchConcurrentlyGeneric(deviceStatusIdList, (String)"onOffTimeRT", (int)5000, (int)30, (Logger)log, batch -> {
            com.ovopark.device.common.response.BaseResult result = this.deviceStatusApi.getDmsOnOffMap(batch);
            if (result != null && !result.getIsError().booleanValue() && Util.isNotEmpty((Map)((Map)result.getData()))) {
                return this.convertOnOffVoMap((Map)result.getData());
            }
            return new HashMap();
        });
    }

    private Map<Integer, OnOffVo> convertOnOffVoMap(Map<Integer, com.ovopark.device.cloud.common.model.vo.OnOffVo> sourceMap) {
        HashMap<Integer, OnOffVo> resultMap = new HashMap<Integer, OnOffVo>();
        if (sourceMap != null && !sourceMap.isEmpty()) {
            sourceMap.forEach((k, v) -> {
                OnOffVo onOffVo = new OnOffVo();
                onOffVo.setId(v.getId());
                onOffVo.setOnline(v.getOnline());
                onOffVo.setOfflineTimeStamp(v.getOfflineTimeStamp());
                onOffVo.setOnlineTimeStamp(v.getOnlineTimeStamp().longValue());
                resultMap.put((Integer)k, onOffVo);
            });
        }
        return resultMap;
    }

    public Map<Integer, OnOffVo> onOffTimeNRT(List<Integer> deviceStatusIdList) {
        return this.onOffTimeRT(deviceStatusIdList);
    }

    public Map<Integer, Integer> getVideoOnlineMap(List<Integer> deviceIdList) {
        return BatchConcurrentProcessor.processBatchConcurrentlyGeneric(deviceIdList, (String)"getVideoOnlineMap", (int)5000, (int)30, (Logger)log, batch -> {
            com.ovopark.device.common.response.BaseResult deviceOnlineStatus = this.deviceApi.getDeviceOnlineStatus(batch);
            if (deviceOnlineStatus != null && !deviceOnlineStatus.getIsError().booleanValue() && CollectionUtils.isNotEmpty((Collection)((Collection)deviceOnlineStatus.getData()))) {
                return this.convertDevicesOnlineMoListToMap((List)deviceOnlineStatus.getData());
            }
            return new HashMap();
        });
    }

    private Map<Integer, Integer> convertDevicesOnlineMoListToMap(List<DevicesOnlineMo> data) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (CollectionUtils.isNotEmpty(data)) {
            data.stream().filter(item -> item.getDevicesId() != null).forEach(item -> result.put(item.getDevicesId(), item.getOnlineFlag()));
        }
        return result;
    }

    public Map<String, Integer> onOffRT_YS(List<String> deviceSerialList) {
        return BatchConcurrentProcessor.processBatchConcurrentlyGeneric(deviceSerialList, (String)"onOffRT_YS", (int)5000, (int)30, (Logger)log, batch -> {
            GetEzvizDeviceOnlineMapFeignMo getEzvizDeviceOnlineMapFeignMo = new GetEzvizDeviceOnlineMapFeignMo();
            getEzvizDeviceOnlineMapFeignMo.setDeviceSerialList(batch);
            getEzvizDeviceOnlineMapFeignMo.setToken(null);
            BaseResult baseResult = this.tempEzvizApi.getEzvizDeviceOnlineMap(getEzvizDeviceOnlineMapFeignMo);
            if (baseResult != null && !baseResult.getIsError().booleanValue() && baseResult.getData() != null) {
                return (Map)baseResult.getData();
            }
            return new HashMap();
        });
    }
}

