/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportpfconfig.report;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.reportpfconfig.ReportDeviceConfigService;
import com.ovopark.device.modules.reportpfconfig.report.model.DeviceFlowReidConfigReportExcelHeader;
import com.ovopark.device.modules.reportpfconfig.report.model.DeviceFlowReidConfigReportExcelParamMo;
import com.ovopark.device.modules.reportpfconfig.report.model.DeviceFlowReidConfigReportExcelParamVo;
import com.ovopark.device.modules.reportpfconfig.vo.DeviceFlowReidConfigReportInParamMo;
import com.ovopark.device.modules.reportpfconfig.vo.DeviceFlowReidConfigReportOutParamVo;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="/ovopark-device-report-form/deviceReport/getDeviceFlowReidConfigReport")
public class DownloadDeviceFlowReidCfgExcel
implements JobOutTaskFlow<DeviceFlowReidConfigReportExcelParamMo> {
    private static final Logger log = LoggerFactory.getLogger(DownloadDeviceFlowReidCfgExcel.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ReportDeviceConfigService deviceReportService;

    public void prepared() {
        log.info("prepared : ");
    }

    public DeviceFlowReidConfigReportExcelParamMo requestParamBody(String requestBody, Session session) {
        log.info("requestParamBody : " + requestBody);
        log.info("session: " + JSONAccessor.impl().format((Object)session));
        DeviceFlowReidConfigReportExcelParamMo paramMo = (DeviceFlowReidConfigReportExcelParamMo)JSONAccessor.impl().read(requestBody, DeviceFlowReidConfigReportExcelParamMo.class);
        paramMo.setLocale(session.clientInfo().getLocale());
        paramMo.setUserId(session.getUserId());
        paramMo.setGroupId(session.getGroupId());
        return paramMo;
    }

    public void execute(DeviceFlowReidConfigReportExcelParamMo requestParamBody, OutStore outStore) {
        log.info("execute : " + JSONAccessor.impl().format((Object)requestParamBody));
        OutStore.SegmentWriter segment = outStore.createSegment("sheet");
        Segment.Header header = segment.header();
        header.all(DeviceFlowReidConfigReportExcelHeader.class, path -> {
            log.info("possible i18 key: " + path);
            String message = this.messageSource.getMessage(path, null, requestParamBody.getLocale() == null ? Locale.CHINA : requestParamBody.getLocale());
            if (path.equalsIgnoreCase(message)) {
                return path.substring(Math.max(0, path.lastIndexOf(".") + 1));
            }
            return message;
        });
        DeviceFlowReidConfigReportInParamMo inParam = new DeviceFlowReidConfigReportInParamMo();
        inParam.setOrganizeIds(requestParamBody.getOrganizeIds());
        inParam.setSort(requestParamBody.getSort());
        inParam.setPageSize(requestParamBody.getPageSize());
        inParam.setPageNumber(requestParamBody.getPageNumber());
        inParam.setDeviceTypes(requestParamBody.getDeviceTypes());
        BaseResult deviceFlowReidConfigReport = this.deviceReportService.getDeviceFlowReidConfigReport(inParam, requestParamBody.getGroupId(), requestParamBody.getUserId());
        Page page = (Page)JSONObject.parseObject((String)JSONObject.toJSONString((Object)deviceFlowReidConfigReport.getData()), Page.class);
        List records = JSONObject.parseArray((String)JSONObject.toJSONString((Object)page.getRecords()), DeviceFlowReidConfigReportOutParamVo.class);
        if (!CollectionUtils.isEmpty((Collection)records)) {
            for (DeviceFlowReidConfigReportOutParamVo record : records) {
                DeviceFlowReidConfigReportExcelParamVo deviceFlowReidConfigReportExcelParamVo = DownloadDeviceFlowReidCfgExcel.getDeviceFlowReidConfigReportExcelParamVo(record);
                segment.append((Model)deviceFlowReidConfigReportExcelParamVo);
            }
        }
        segment.commit();
        outStore.fileName(this.messageSource.getMessage("DeviceFlowReidConfigReportExcelHeader.fileName", null, requestParamBody.getLocale() == null ? Locale.CHINA : requestParamBody.getLocale()));
    }

    @NotNull
    private static DeviceFlowReidConfigReportExcelParamVo getDeviceFlowReidConfigReportExcelParamVo(DeviceFlowReidConfigReportOutParamVo record) {
        DeviceFlowReidConfigReportExcelParamVo deviceFlowReidConfigReportExcelParamVo = new DeviceFlowReidConfigReportExcelParamVo();
        deviceFlowReidConfigReportExcelParamVo.setDepName(record.getDepName());
        deviceFlowReidConfigReportExcelParamVo.setDeviceName(record.getDeviceName());
        deviceFlowReidConfigReportExcelParamVo.setDeviceType(record.getDeviceType());
        deviceFlowReidConfigReportExcelParamVo.setMac(record.getMac());
        deviceFlowReidConfigReportExcelParamVo.setAllDayMerging(record.getAllDayMerging());
        deviceFlowReidConfigReportExcelParamVo.setEnableStorePasserbyStr(record.getEnableStorePasserbyStr());
        deviceFlowReidConfigReportExcelParamVo.setEmployeeCompareLevelStr(record.getEmployeeCompareLevelStr());
        deviceFlowReidConfigReportExcelParamVo.setEmployeeTimeMarkEnableStr(record.getEmployeeTimeMarkTime());
        deviceFlowReidConfigReportExcelParamVo.setEmployeeTrackTimeThresholdStr(record.getEmployeeTrackTimeThresholdStr());
        return deviceFlowReidConfigReportExcelParamVo;
    }

    public void close() {
        log.info("close : ");
    }

    public JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider(DeviceFlowReidConfigReportExcelParamMo requestParamBody, Session session) {
        final Locale locale = requestParamBody.getLocale();
        return new JobOutTaskFlow.ExportTaskInfoProvider(){

            public String name() {
                return DownloadDeviceFlowReidCfgExcel.this.messageSource.getMessage("DeviceFlowReidConfigReportExcelHeader.exportName", null, locale);
            }
        };
    }
}

