/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.cloud.api.DeviceApi;
import com.ovopark.device.cloud.api.DeviceStatusApi;
import com.ovopark.device.cloud.common.model.mo.DevicesOnlineMo;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.model.OnOffVo;
import com.ovopark.device.platform.utils.BatchConcurrentProcessor;
import com.ovopark.device.sdk.api.TempEzvizApi;
import com.ovopark.device.sdk.common.model.mo.GetEzvizDeviceOnlineMapFeignMo;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.ovopark.device.modules.platform.OnlineFacadeRPC")
public class OnlineFacadeRPC
implements OnlineFacade {
    private static final Logger log = LoggerFactory.getLogger(OnlineFacadeRPC.class);
    public static final String BEAN_NAME = "com.ovopark.device.modules.platform.OnlineFacadeRPC";
    private static final int DEFAULT_BATCH_SIZE = 2500;
    private static final int TIMEOUT_SECONDS = 30;
    @Resource
    private DeviceStatusApi deviceStatusApi;
    @Resource
    private DeviceApi deviceApi;
    @Autowired
    private TempEzvizApi tempEzvizApi;

    public Map<Integer, Integer> onOffRT(List<Integer> deviceStatusIdList) {
        log.info("OnlineFacadeRPC.onOffRT:{}", deviceStatusIdList);
        return BatchConcurrentProcessor.processBatchConcurrently(deviceStatusIdList, batch -> {
            try {
                com.ovopark.device.common.response.BaseResult result = this.deviceStatusApi.getDmsOnlineMap(batch);
                if (result.getIsError().booleanValue() || CollectionUtils.isEmpty((Map)((Map)result.getData()))) {
                    log.error("online data err:{}", (Object)IotJsonUtils.beanToJsonString((Object)result));
                } else {
                    log.info("online data online rate:{}/{} \u8fd4\u56de\u7ed3\u679c{}", new Object[]{((Map)result.getData()).values().stream().filter(v -> v == 1).count(), ((Map)result.getData()).size(), result.getRequestId()});
                    if (((Map)result.getData()).values().stream().filter(v -> v == 1).count() < (long)(batch.size() / 2)) {
                        log.error("online data err, \u5728\u7ebf\u8bbe\u5907\u6570\u91cf\u5c0f\u4e8ebatch/2, batch={},result :{}", (Object)batch.size(), (Object)IotJsonUtils.beanToJsonString((Object)result));
                    }
                }
                return result.getIsError() == false && result.getData() != null ? (Map)result.getData() : new HashMap();
            }
            catch (Exception e) {
                log.error("deviceStatusApi.getDmsOnlineMap");
                return new HashMap();
            }
        }, (Logger)log, (String)"onOffRT", (int)2500, (int)30);
    }

    public Map<Integer, Integer> onOffNRT(List<Integer> deviceStatusIdList) {
        return this.onOffRT(deviceStatusIdList);
    }

    public Map<Integer, OnOffVo> onOffTimeRT(List<Integer> deviceStatusIdList) {
        return BatchConcurrentProcessor.processBatchConcurrently(deviceStatusIdList, batch -> {
            try {
                com.ovopark.device.common.response.BaseResult result = this.deviceStatusApi.getDmsOnOffMap(batch);
                if (result != null && !result.getIsError().booleanValue() && Util.isNotEmpty((Map)((Map)result.getData()))) {
                    return this.convertOnOffVoMap((Map)result.getData());
                }
                return new HashMap();
            }
            catch (Exception e) {
                log.error("deviceStatusApi.getDmsOnOffMap");
                return new HashMap();
            }
        }, (Logger)log, (String)"onOffTimeRT", (int)2500, (int)30);
    }

    private Map<Integer, OnOffVo> convertOnOffVoMap(Map<Integer, com.ovopark.device.cloud.common.model.vo.OnOffVo> sourceMap) {
        HashMap<Integer, OnOffVo> resultMap = new HashMap<Integer, OnOffVo>();
        if (sourceMap != null && !sourceMap.isEmpty()) {
            sourceMap.forEach((k, v) -> {
                OnOffVo onOffVo = new OnOffVo();
                onOffVo.setId(v.getId());
                onOffVo.setOnline(v.getOnline());
                onOffVo.setOfflineTimeStamp(v.getOfflineTimeStamp());
                onOffVo.setOnlineTimeStamp(v.getOnlineTimeStamp().longValue());
                resultMap.put((Integer)k, onOffVo);
            });
        }
        return resultMap;
    }

    public Map<Integer, OnOffVo> onOffTimeNRT(List<Integer> deviceStatusIdList) {
        return this.onOffTimeRT(deviceStatusIdList);
    }

    public Map<Integer, Integer> getVideoOnlineMap(List<Integer> deviceIdList) {
        return BatchConcurrentProcessor.processBatchConcurrently(deviceIdList, batch -> {
            try {
                com.ovopark.device.common.response.BaseResult deviceOnlineStatus = this.deviceApi.getDeviceOnlineStatus(batch);
                if (deviceOnlineStatus != null && !deviceOnlineStatus.getIsError().booleanValue() && CollectionUtils.isNotEmpty((Collection)((Collection)deviceOnlineStatus.getData()))) {
                    return this.convertDevicesOnlineMoListToMap((List)deviceOnlineStatus.getData());
                }
                return new HashMap();
            }
            catch (Exception e) {
                log.error("deviceApi.getDeviceOnlineStatus");
                return new HashMap();
            }
        }, (Logger)log, (String)"getVideoOnlineMap", (int)2500, (int)30);
    }

    private Map<Integer, Integer> convertDevicesOnlineMoListToMap(List<DevicesOnlineMo> data) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (CollectionUtils.isNotEmpty(data)) {
            data.stream().filter(item -> item.getDevicesId() != null).forEach(item -> result.put(item.getDevicesId(), item.getOnlineFlag()));
        }
        return result;
    }

    public Map<String, Integer> onOffRT_YS(List<String> deviceSerialList) {
        return BatchConcurrentProcessor.processBatchConcurrently(deviceSerialList, batch -> {
            try {
                GetEzvizDeviceOnlineMapFeignMo getEzvizDeviceOnlineMapFeignMo = new GetEzvizDeviceOnlineMapFeignMo();
                getEzvizDeviceOnlineMapFeignMo.setDeviceSerialList(batch);
                getEzvizDeviceOnlineMapFeignMo.setToken(null);
                BaseResult baseResult = this.tempEzvizApi.getEzvizDeviceOnlineMap(getEzvizDeviceOnlineMapFeignMo);
                if (baseResult != null && !baseResult.getIsError().booleanValue() && baseResult.getData() != null) {
                    return (Map)baseResult.getData();
                }
                return new HashMap();
            }
            catch (Exception e) {
                log.error("tempEzvizApi.getEzvizDeviceOnlineMap");
                return new HashMap();
            }
        }, (Logger)log, (String)"onOffRT_YS", (int)2500, (int)30);
    }
}

