/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.xdth;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.modules.platform.DeviceSharedConfig;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.modules.platform.mysql.Platforms;
import com.ovopark.device.modules.platform.mysql.PlatformsMapper;
import com.ovopark.device.modules.xdth.XDTHService;
import com.ovopark.device.sdk.common.model.vo.DeptTodoEventVo;
import com.ovopark.device.thirdparty.ovoIot.model.ResultRes;
import com.ovopark.device.thirdparty.ovoIot.model.req.PushTodoMsgEventReq;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XDTHServiceImpl
implements XDTHService {
    private static final Logger log = LoggerFactory.getLogger(XDTHServiceImpl.class);
    @Autowired
    private PlatformsMapper platformsMapper;
    @Autowired
    private NvrService nvrService;
    @Autowired
    private DeviceSharedConfig deviceSharedConfig;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    JobService jobService;

    @Override
    public boolean pushTodoMsgEvent(DeptTodoEventVo deptTodoEventVo) {
        Integer deptId = deptTodoEventVo.getDeptId();
        List deviceStatusList = this.deviceStatusMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DeviceStatus.class).eq(DeviceStatus::getDepId, (Object)deptId)).eq(DeviceStatus::getIsDelete, (Object)0)).isNull(DeviceStatus::getPId)).in(DeviceStatus::getDType, new Object[]{2, 20}));
        if (Util.isEmpty((Collection)deviceStatusList)) {
            log.info("cannot find any device");
            return false;
        }
        DeviceStatus deviceStatus = null;
        for (DeviceStatus ds : deviceStatusList) {
            if (!this.deviceSharedConfig.getXdthMac().contains(ds.getMac())) continue;
            deviceStatus = ds;
            break;
        }
        if (deviceStatus == null) {
            log.info("cannot find any device: " + this.deviceSharedConfig.getXdthMac() + ", db: " + JSONAccessor.impl().format((Object)deviceStatusList));
            return false;
        }
        final Platforms platform = (Platforms)this.platformsMapper.selectById(deviceStatus.getPlatformId());
        final PushTodoMsgEventReq pushTodoMsgEventReq = new PushTodoMsgEventReq();
        BeanUtils.copyProperties((Object)deptTodoEventVo, (Object)pushTodoMsgEventReq);
        log.info("request pushTodoMsgEvent: " + String.valueOf(pushTodoMsgEventReq));
        log.info("request pushTodoMsgEvent , platform: " + JSONAccessor.impl().format((Object)platform));
        final DeviceStatus finalDeviceStatus = deviceStatus;
        ResultRes resultRes = (ResultRes)this.jobService.doOnceOnDevice(deviceStatus.getId(), null, null, null, "pushTodoMsgEvent", JSONAccessor.impl().format((Object)pushTodoMsgEventReq), null, null, (JobService.TaskCallListener)new JobService.TaskCallListener<ResultRes>(){

            public ResultRes on(JobService.TaskContext taskContext) {
                Integer dType = finalDeviceStatus.getDType();
                if (dType == 2 || dType == 20) {
                    ResultRes resultRes = XDTHServiceImpl.this.nvrService.pushTodoMsgEvent(finalDeviceStatus.getMac(), pushTodoMsgEventReq, platform.getUpgradeServer(), platform.getUpgradePort(), platform.getNewDmsFlag());
                    log.info("pushTodoMsgEvent result from device: " + JSONAccessor.impl().format((Object)resultRes));
                    taskContext.completedDesc(JSONAccessor.impl().format((Object)resultRes));
                    return resultRes;
                }
                log.info("\u8bbe\u5907\u4e0d\u652f\u6301");
                return null;
            }
        });
        return resultRes != null;
    }
}

