/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.dlm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.device.modules.dlm.OnOffEvent;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.es7x.Document;
import java.time.LocalDateTime;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface OnOffSnapshot {
    public void collect(OnOffEvent var1);

    public void mergeIntervalsThenSubscribe(Consumer<OnOffEvent> var1);

    public void write2ExcelThenSubscribe(Consumer<String> var1);

    public int size();

    public void close();

    public void mergeIntervals2ESModelThenSubscribe(Consumer<OnOffESModel> var1, Predicate<OnOffEvent> var2);

    default public void mergeIntervals2ESModelThenSubscribe(Consumer<OnOffESModel> consumer, String fromTime, String endTime) {
        final long fromBaseTime = Util.dateTime((String)fromTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}).toInstant(Util.GMT_08).toEpochMilli();
        final long endBaseTime = Util.dateTime((String)endTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}).toInstant(Util.GMT_08).toEpochMilli();
        this.mergeIntervals2ESModelThenSubscribe(consumer, new Predicate<OnOffEvent>(){

            @Override
            public boolean test(OnOffEvent onOffEvent) {
                return onOffEvent.getTimestampMs() > fromBaseTime && onOffEvent.getTimestampMs() < endBaseTime;
            }
        });
    }

    default public void mergeIntervals2ESModelThenSubscribe(Consumer<OnOffESModel> consumer, String fromTime) {
        final long fromBaseTime = Util.dateTime((String)fromTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}).toInstant(Util.GMT_08).toEpochMilli();
        this.mergeIntervals2ESModelThenSubscribe(consumer, new Predicate<OnOffEvent>(){

            @Override
            public boolean test(OnOffEvent onOffEvent) {
                return onOffEvent.getTimestampMs() > fromBaseTime;
            }
        });
    }

    public static class OnOffESModel
    implements Document<String> {
        public static final String INDEX = "device-onoffday-all";
        public static final String INDEX_READ = "device-onoffday-read";
        private String nvrMac;
        private Integer channel;
        private String mac;
        private String onOffList;
        private String day;
        private long fromTime;
        private long endTime;
        private LocalDateTime time;
        private String id;
        private String docIndexName;
        @JsonIgnore
        private transient StringBuilder tempStringBuilder;

        public String id() {
            return this.id;
        }

        public void id(String id) {
            this.id = id;
        }

        public void docIndexName(String index) {
            this.docIndexName = index;
        }

        public String getNvrMac() {
            return this.nvrMac;
        }

        public Integer getChannel() {
            return this.channel;
        }

        public String getMac() {
            return this.mac;
        }

        public String getOnOffList() {
            return this.onOffList;
        }

        public String getDay() {
            return this.day;
        }

        public long getFromTime() {
            return this.fromTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public LocalDateTime getTime() {
            return this.time;
        }

        public String getId() {
            return this.id;
        }

        public String getDocIndexName() {
            return this.docIndexName;
        }

        public StringBuilder getTempStringBuilder() {
            return this.tempStringBuilder;
        }

        public void setNvrMac(String nvrMac) {
            this.nvrMac = nvrMac;
        }

        public void setChannel(Integer channel) {
            this.channel = channel;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public void setOnOffList(String onOffList) {
            this.onOffList = onOffList;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setFromTime(long fromTime) {
            this.fromTime = fromTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public void setTime(LocalDateTime time) {
            this.time = time;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setDocIndexName(String docIndexName) {
            this.docIndexName = docIndexName;
        }

        @JsonIgnore
        public void setTempStringBuilder(StringBuilder tempStringBuilder) {
            this.tempStringBuilder = tempStringBuilder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OnOffESModel)) {
                return false;
            }
            OnOffESModel other = (OnOffESModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFromTime() != other.getFromTime()) {
                return false;
            }
            if (this.getEndTime() != other.getEndTime()) {
                return false;
            }
            Integer this$channel = this.getChannel();
            Integer other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            String this$nvrMac = this.getNvrMac();
            String other$nvrMac = other.getNvrMac();
            if (this$nvrMac == null ? other$nvrMac != null : !this$nvrMac.equals(other$nvrMac)) {
                return false;
            }
            String this$mac = this.getMac();
            String other$mac = other.getMac();
            if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
                return false;
            }
            String this$onOffList = this.getOnOffList();
            String other$onOffList = other.getOnOffList();
            if (this$onOffList == null ? other$onOffList != null : !this$onOffList.equals(other$onOffList)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            LocalDateTime this$time = this.getTime();
            LocalDateTime other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$docIndexName = this.getDocIndexName();
            String other$docIndexName = other.getDocIndexName();
            return !(this$docIndexName == null ? other$docIndexName != null : !this$docIndexName.equals(other$docIndexName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OnOffESModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fromTime = this.getFromTime();
            result = result * 59 + (int)($fromTime >>> 32 ^ $fromTime);
            long $endTime = this.getEndTime();
            result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
            Integer $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            String $nvrMac = this.getNvrMac();
            result = result * 59 + ($nvrMac == null ? 43 : $nvrMac.hashCode());
            String $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
            String $onOffList = this.getOnOffList();
            result = result * 59 + ($onOffList == null ? 43 : $onOffList.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            LocalDateTime $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $docIndexName = this.getDocIndexName();
            result = result * 59 + ($docIndexName == null ? 43 : $docIndexName.hashCode());
            return result;
        }

        public String toString() {
            return "OnOffSnapshot.OnOffESModel(nvrMac=" + this.getNvrMac() + ", channel=" + this.getChannel() + ", mac=" + this.getMac() + ", onOffList=" + this.getOnOffList() + ", day=" + this.getDay() + ", fromTime=" + this.getFromTime() + ", endTime=" + this.getEndTime() + ", time=" + String.valueOf(this.getTime()) + ", id=" + this.getId() + ", docIndexName=" + this.getDocIndexName() + ", tempStringBuilder=" + String.valueOf(this.getTempStringBuilder()) + ")";
        }
    }
}

